/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaComboBoxUI;
import org.violetlib.aqua.AquaImageFactory;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.PopupButtonLayoutConfiguration;

public class AquaComboBoxRendererInternal<E>
extends JLabel
implements ListCellRenderer<E> {
    protected final JComboBox<?> fComboBox;
    protected boolean fSelected;
    protected boolean fChecked;
    protected boolean fInList;
    protected boolean fEditable;
    protected boolean fDrawCheckedItem = true;
    protected boolean fIsDark;
    protected static int checkMarkLeftInset = 5;
    protected static int checkMarkTopInset = 3;
    protected static int menuLabelLeftInset = 21;
    protected static int editableMenuLabelLeftInset = 5;
    protected static int menuLabelRightInset = 5;
    protected static int menuLabelTopInset = 0;
    protected static int menuLabelBottomInset = 1;
    protected static int miniMenuLabelTopInset = 1;
    protected static int miniMenuLabelBottomInset = 0;
    protected static int buttonLabelLeftInset = 0;
    protected static int buttonLabelTopInset = 0;
    protected static int buttonLabelBottomInset = 0;
    protected static int buttonLabelRightInset = 0;

    public AquaComboBoxRendererInternal(JComboBox<?> jComboBox) {
        this.fComboBox = jComboBox;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension;
        String string = this.getText();
        if (string == null || string.isEmpty()) {
            this.setText(" ");
            dimension = super.getPreferredSize();
            this.setText("");
        } else {
            dimension = super.getPreferredSize();
        }
        return dimension;
    }

    @Override
    protected void paintBorder(Graphics graphics) {
    }

    @Override
    public int getBaseline(int n, int n2) {
        return super.getBaseline(n, n2) - 1;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends E> jList, E e, int n, boolean bl, boolean bl2) {
        Object object;
        this.fInList = n >= 0;
        this.fSelected = bl;
        if (n < 0) {
            n = this.fComboBox.getSelectedIndex();
        }
        if (n >= 0) {
            object = this.fComboBox.getItemAt(n);
            this.fChecked = this.fInList && object != null && object.equals(this.fComboBox.getSelectedItem()) && !this.isPullDown(this.fComboBox);
        } else {
            this.fChecked = false;
        }
        this.fEditable = this.fComboBox.isEditable();
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setFont(jList.getFont());
        if (e instanceof Icon) {
            this.setIcon((Icon)e);
            this.setText(null);
        } else {
            this.setIcon(null);
            this.setText(e == null ? " " : e.toString());
        }
        object = AppearanceManager.getAppearance(this.fComboBox);
        this.fIsDark = ((AquaAppearance)object).isDark();
        return this;
    }

    @Override
    @NotNull
    public Insets getInsets(@Nullable Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        AquaUIPainter.Size size = this.getComboBoxSizeVariant();
        if (this.fInList) {
            insets.top = size == AquaUIPainter.Size.MINI ? miniMenuLabelTopInset : menuLabelTopInset;
            insets.bottom = size == AquaUIPainter.Size.MINI ? miniMenuLabelBottomInset : menuLabelBottomInset;
            insets.left = this.fEditable ? editableMenuLabelLeftInset : menuLabelLeftInset;
            insets.right = menuLabelRightInset;
        } else {
            insets.top = buttonLabelTopInset;
            insets.bottom = buttonLabelBottomInset;
            insets.right = buttonLabelRightInset;
            insets.left = buttonLabelLeftInset;
        }
        return insets;
    }

    protected void setDrawCheckedItem(boolean bl) {
        this.fDrawCheckedItem = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.fInList) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.fChecked && !this.fEditable && this.fDrawCheckedItem) {
                AquaUIPainter.Size size = this.getComboBoxSizeVariant();
                Icon icon = AquaImageFactory.getPopupMenuItemCheckIcon(size);
                Color color = this.getForeground();
                Image image = AquaImageFactory.getProcessedImage(icon, (Object)color);
                int n = this.getHeight();
                int n2 = checkMarkLeftInset;
                int n3 = Math.max(checkMarkTopInset, (n - icon.getIconHeight() - 1) / 2);
                graphics.drawImage(image, n2, n3, null);
            }
        }
        super.paintComponent(graphics);
    }

    protected AquaUIPainter.Size getComboBoxSizeVariant() {
        AquaComboBoxUI aquaComboBoxUI = AquaUtils.getUI(this.fComboBox, AquaComboBoxUI.class);
        if (aquaComboBoxUI != null) {
            return aquaComboBoxUI.getSizeVariant();
        }
        return AquaUIPainter.Size.REGULAR;
    }

    protected boolean isPullDown(JComboBox jComboBox) {
        AquaComboBoxUI aquaComboBoxUI;
        if (!jComboBox.isEditable() && (aquaComboBoxUI = AquaUtils.getUI(jComboBox, AquaComboBoxUI.class)) != null) {
            PopupButtonLayoutConfiguration popupButtonLayoutConfiguration = (PopupButtonLayoutConfiguration)aquaComboBoxUI.getLayoutConfiguration();
            return popupButtonLayoutConfiguration != null && !popupButtonLayoutConfiguration.isPopUp();
        }
        return false;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void repaint() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    public void firePropertyChange(String string, byte by, byte by2) {
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

