/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.plaf.ColorUIResource;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.violetlib.aqua.AppearanceContext;
import org.violetlib.aqua.AppearanceManager;
import org.violetlib.aqua.AquaAppearance;
import org.violetlib.aqua.AquaContextualColorImpl;
import org.violetlib.aqua.AquaListUI;
import org.violetlib.aqua.AquaTableUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.BasicContextualColors;
import org.violetlib.aqua.BasicContextualColorsImpl;
import org.violetlib.aqua.ContainerContextualColors;
import org.violetlib.aqua.ContextualColor;
import org.violetlib.aqua.EffectName;
import org.violetlib.aqua.OSXSystemProperties;
import org.violetlib.aqua.StripedContainerContextualColors;
import org.violetlib.aqua.UniformContainerContextualColors;

public class AquaColors {
    public static final String COMPONENT_COLORS_KEY = "Aqua.componentColors";
    private static final ContextualColor CELL_FOREGROUND_COLORS = AquaColors.createCellForegroundColors();
    public static final BasicContextualColors TEXT_COLORS = AquaColors.createBasicTextColors();
    public static final BasicContextualColors LABELLED_BUTTON_COLORS = AquaColors.createLabeledButtonColors();
    public static final BasicContextualColors PUSH_BUTTON_COLORS = AquaColors.createButtonColors("PushButton", "pushButtonText");
    public static final BasicContextualColors TEXTURED_COLORS = AquaColors.createButtonColors("TexturedButton", "texturedText");
    public static final BasicContextualColors TEXTURED_TOOLBAR_COLORS = AquaColors.createButtonColors("TexturedToolbarButton", "texturedToolbarText");
    public static final BasicContextualColors GRADIENT_BUTTON_COLORS = AquaColors.createButtonColors("GradientButton", "gradientText");
    public static final BasicContextualColors ROUNDED_RECT_BUTTON_COLORS = AquaColors.createButtonColors("RoundedRectButton", "roundedRectText");
    public static final BasicContextualColors BEVEL_BUTTON_COLORS = AquaColors.createButtonColors("BevelButton", "bevelText");
    public static final BasicContextualColors ROUND_BUTTON_COLORS = AquaColors.createButtonColors("RoundButton", "roundText");
    public static final BasicContextualColors INLINE_BUTTON_COLORS = AquaColors.createButtonColors("InlineButton", "inlineButtonText");
    public static final BasicContextualColors RECESSED_BUTTON_COLORS = AquaColors.createButtonColors("RecessedButton", "recessedText");
    public static final BasicContextualColors TOOLBAR_ITEM_COLORS = AquaColors.createButtonColors("ToolbarItem", "toolbarItemText");
    public static final BasicContextualColors POP_UP_DOWN_BUTTON_COLORS = AquaColors.createButtonColors("PopUpDown", "pushPopText");
    public static final BasicContextualColors SEGMENTED_BUTTON_COLORS = AquaColors.createButtonColors("SegmentedButton", "segmentedText");
    public static final BasicContextualColors TAB_COLORS = AquaColors.createButtonColors("TabButton", "tabText");
    public static final BasicContextualColors SEGMENTED_NONEXCLUSIVE_BUTTON_COLORS = AquaColors.createButtonColors("NonexclusiveSegmentedButton", "nonexclusiveText");
    public static final BasicContextualColors SEGMENTED_SEPARATED_BUTTON_COLORS = AquaColors.createButtonColors("SegmentedSeparatedButton", "segmentedSeparatedText");
    public static final BasicContextualColors SEGMENTED_SEPARATED_NONEXCLUSIVE_BUTTON_COLORS = AquaColors.createButtonColors("NonexclusiveSegmentedSeparatedButton", "nonexclusiveSeparatedText");
    public static final BasicContextualColors TEXTURED_SEGMENTED_BUTTON_COLORS = AquaColors.createButtonColors("TexturedSegmentedButton", "texturedSegmentedText");
    public static final BasicContextualColors TEXTURED_SEGMENTED_TOOLBAR_BUTTON_COLORS = AquaColors.createButtonColors("TexturedSegmentedToolbarButton", "texturedSegmentedToolbarText");
    public static final BasicContextualColors TEXTURED_NONEXCLUSIVE_COLORS = AquaColors.createButtonColors("NonexclusiveTextured", "nonexclusiveTexturedText");
    public static final BasicContextualColors TEXTURED_TOOLBAR_NONEXCLUSIVE_COLORS = AquaColors.createButtonColors("NonexclusiveTexturedToolbar", "nonexclusiveTexturedToolbarText");
    public static final BasicContextualColors GRADIENT_SEGMENTED_BUTTON_COLORS = AquaColors.createButtonColors("GradientSegmentedButton", "gradientSegmentedText");
    public static final BasicContextualColors CELL_TEXT_COLORS = AquaColors.createCellTextColors();
    public static final BasicContextualColors CONTROL_COLORS = AquaColors.createBasicControlColors();
    public static final BasicContextualColors CLEAR_CONTROL_COLORS = AquaColors.createBasicClearControlColors();
    public static final BasicContextualColors TOOL_TIP_COLORS = AquaColors.createToolTipColors();
    private static final BasicContextualColors MENU_COLORS = AquaColors.createMenuColors();
    private static final BasicContextualColors LEGACY_MENU_COLORS = AquaColors.createLegacyMenuColors();
    public static final BasicContextualColors SEPARATOR_COLORS = AquaColors.createSeparatorColors();
    public static final BasicContextualColors TABLE_HEADER_COLORS = AquaColors.createTableHeaderColors();
    public static final ContainerContextualColors CONTAINER_COLORS = AquaColors.createContainerColors();
    public static final ContainerContextualColors STRIPED_CONTAINER_COLORS = AquaColors.createStripedContainerColors();
    public static final ContainerContextualColors SIDEBAR_CONTAINER_COLORS = AquaColors.createSidebarContainerColors();
    public static final Color CLEAR = new ColorUIResource(new Color(0, 0, 0, 0));
    public static final Color MAGIC_ERASER = new ColorUIResource(new Color(0, 0, 0, 0));
    private static boolean COLORS_DEBUG = false;
    @Nullable
    private static BasicContextualColors COLORS_DEBUG_CHOICE = TEXTURED_SEGMENTED_BUTTON_COLORS;
    private static boolean currentColorsDebugFlag;
    private static final List<String> allColorSuffixes;

    public static void setupDebugging(@Nullable BasicContextualColors basicContextualColors) {
        currentColorsDebugFlag = COLORS_DEBUG && (COLORS_DEBUG_CHOICE == null || COLORS_DEBUG_CHOICE == basicContextualColors);
    }

    public static void clearDebugging() {
        currentColorsDebugFlag = false;
    }

    public static boolean isDebugging() {
        return currentColorsDebugFlag;
    }

    @NotNull
    public static String toString(@Nullable Color color) {
        if (color == null) {
            return "<null>";
        }
        String string = color.getClass().getName() + "[" + color.getRed() + "," + color.getGreen() + "," + color.getBlue();
        int n = color.getAlpha();
        if (n != 255) {
            string = string + "," + n;
        }
        string = string + "]";
        return string;
    }

    @NotNull
    public static BasicContextualColors getMenuColors() {
        return OSXSystemProperties.OSVersion < 1014 ? LEGACY_MENU_COLORS : MENU_COLORS;
    }

    @NotNull
    public static Color getForeground(@NotNull JComponent jComponent, @NotNull String string) {
        Color color = jComponent.getForeground();
        return AquaColors.getDefaultColor(jComponent, color, string);
    }

    @NotNull
    public static Color getForeground(@NotNull JComponent jComponent, @NotNull String string, @NotNull EffectName effectName) {
        Color color = jComponent.getForeground();
        return AquaColors.getDefaultColor(jComponent, color, string, effectName);
    }

    @NotNull
    public static Color getBackground(@NotNull Component component, @NotNull String string) {
        Color color = component.getBackground();
        return AquaColors.getDefaultColor(component, color, string);
    }

    @NotNull
    public static Color getBackground(@NotNull Component component, @NotNull String string, @NotNull EffectName effectName) {
        Color color = component.getBackground();
        return AquaColors.getDefaultColor(component, color, string, effectName);
    }

    public static boolean isPriority(@Nullable Color color) {
        if (color == null) {
            return false;
        }
        if (color instanceof ColorUIResource) {
            return false;
        }
        return !(color instanceof SystemColor);
    }

    @NotNull
    public static Color getDefaultColor(@NotNull Component component, @NotNull Color color, @NotNull String string) {
        if (AquaColors.isPriority(color)) {
            return color;
        }
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(component);
        Color color2 = aquaAppearance.getColor(string);
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    @NotNull
    public static Color getDefaultColor(@NotNull Component component, @NotNull Color color, @NotNull String string, @NotNull EffectName effectName) {
        if (AquaColors.isPriority(color)) {
            return color;
        }
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(component);
        Color color2 = aquaAppearance.getColorForOptionalEffect(string, effectName);
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    @NotNull
    public static Color getSystemColor(@NotNull JComponent jComponent, @NotNull String string) {
        AquaAppearance aquaAppearance = AppearanceManager.getAppearance(jComponent);
        Color color = aquaAppearance.getColor(string);
        if (color != null) {
            return color;
        }
        throw new UnsupportedOperationException("System color " + string + " is not defined in " + aquaAppearance.getName());
    }

    @NotNull
    public static Color getSystemColor(@NotNull JComponent jComponent, @NotNull String string, @NotNull EffectName effectName) {
        AquaAppearance aquaAppearance = AppearanceManager.ensureAppearance(jComponent);
        Color color = aquaAppearance.getColorForOptionalEffect(string, effectName);
        if (color != null) {
            return color;
        }
        throw new UnsupportedOperationException("System color " + string + " is not defined in " + aquaAppearance.getName());
    }

    @NotNull
    private static BasicContextualColors createBasicTextColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("BasicTextColors.background", "textBackground");
        aquaContextualColorImpl.setAllNames();
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("BasicTextColors.foreground", "text");
        aquaContextualColorImpl2.setAllNames();
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static ContextualColor createCellForegroundColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("CellTextColors.foreground", "cell");
        aquaContextualColorImpl.setAllNames();
        return aquaContextualColorImpl;
    }

    @NotNull
    private static BasicContextualColors createCellTextColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("CellTextColors.background", "cellBackground");
        aquaContextualColorImpl.setAllNames();
        return new BasicContextualColorsImpl(aquaContextualColorImpl, CELL_FOREGROUND_COLORS);
    }

    @NotNull
    private static BasicContextualColors createButtonColors(@NotNull String string, @NotNull String string2) {
        String string3 = string + ".background";
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl(string3, "clear");
        aquaContextualColorImpl.setSelectedName("selectedTextBackground");
        aquaContextualColorImpl.setInactiveSelectedName("selectedTextBackground_inactive");
        String string4 = string + ".foreground";
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl(string4, string2);
        aquaContextualColorImpl2.setAllNames();
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createBasicControlColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("BasicControlColors.background", "controlBackground");
        aquaContextualColorImpl.setSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setInactiveSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("BasicControlColors.foreground", "controlText");
        aquaContextualColorImpl2.setSelectedName("alternateSelectedControlText");
        aquaContextualColorImpl2.setInactiveSelectedName("unemphasizedSelectedControlText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createLabeledButtonColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("LabeledButtonColors.background", "clear");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("LabeledButtonColors.foreground", "controlText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createBasicClearControlColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("BasicClearControlColors.background", "clear");
        aquaContextualColorImpl.setSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setInactiveSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("BasicClearControlColors.foreground", "controlText");
        aquaContextualColorImpl2.setSelectedName("alternateSelectedControlText");
        aquaContextualColorImpl2.setInactiveSelectedName("unemphasizedSelectedControlText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createToolTipColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("ToolTipColors.background", "controlBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("ToolTipColors.foreground", "controlText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createMenuColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("MenuColors.background", "clear");
        aquaContextualColorImpl.setSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setInactiveSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("MenuColors.foreground", "controlText");
        aquaContextualColorImpl2.setSelectedName("selectedMenuItemText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColors createLegacyMenuColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("LegacyMenuColors.background", "menuBackground");
        aquaContextualColorImpl.setSelectedName("menuSelectedBackground");
        aquaContextualColorImpl.setInactiveSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("LegacyMenuColors.foreground", "menuForeground");
        aquaContextualColorImpl2.setSelectedName("selectedMenuItemText");
        aquaContextualColorImpl2.setInactiveSelectedName("unemphasizedSelectedControlText");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColorsImpl createSeparatorColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("SeparatorColors.background", "clear");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("SeparatorColors.foreground", "separator");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static BasicContextualColorsImpl createTableHeaderColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("TableHeaderColors.background", "tableHeaderBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("TableHeaderColors.foreground", "tableHeader");
        aquaContextualColorImpl2.setSelectedName("selectedTableHeader");
        return new BasicContextualColorsImpl(aquaContextualColorImpl, aquaContextualColorImpl2);
    }

    @NotNull
    private static ContainerContextualColors createContainerColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("ContainerColors.background", "controlBackground");
        aquaContextualColorImpl.setActiveDefaultSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("ContainerColors.grid", "grid");
        return new UniformContainerContextualColors(aquaContextualColorImpl, CELL_FOREGROUND_COLORS, aquaContextualColorImpl2);
    }

    @NotNull
    private static ContainerContextualColors createSidebarContainerColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("SidebarContainerColors.background", "controlBackground");
        aquaContextualColorImpl.setActiveDefaultSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("SidebarContainerColors.foreground", "controlText");
        aquaContextualColorImpl2.setInactiveName("controlText");
        AquaContextualColorImpl aquaContextualColorImpl3 = new AquaContextualColorImpl("SidebarContainerColors.grid", "grid");
        return new UniformContainerContextualColors(aquaContextualColorImpl, aquaContextualColorImpl2, aquaContextualColorImpl3);
    }

    @NotNull
    private static ContainerContextualColors createStripedContainerColors() {
        AquaContextualColorImpl aquaContextualColorImpl = new AquaContextualColorImpl("StripedContainerColors.background", "controlBackground");
        aquaContextualColorImpl.setActiveDefaultSelectedName("selectedContentBackground");
        aquaContextualColorImpl.setSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl2 = new AquaContextualColorImpl("StripedContainerColors.background 1", "alternatingContentBackground_1");
        aquaContextualColorImpl2.setActiveDefaultSelectedName("selectedContentBackground");
        aquaContextualColorImpl2.setSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl3 = new AquaContextualColorImpl("StripedContainerColors.background 0", "alternatingContentBackground_0");
        aquaContextualColorImpl3.setActiveDefaultSelectedName("selectedContentBackground");
        aquaContextualColorImpl3.setSelectedName("unemphasizedSelectedTextBackground");
        AquaContextualColorImpl aquaContextualColorImpl4 = new AquaContextualColorImpl("StripedContainerColors.grid", "grid");
        return new StripedContainerContextualColors(aquaContextualColorImpl, aquaContextualColorImpl2, aquaContextualColorImpl3, CELL_FOREGROUND_COLORS, aquaContextualColorImpl4);
    }

    @NotNull
    public static <T extends BasicContextualColors> T getColors(@NotNull Class<T> clazz, @NotNull Component component, @NotNull T t) {
        JComponent jComponent;
        Object object;
        if (component instanceof JComponent && (object = (jComponent = (JComponent)component).getClientProperty(COMPONENT_COLORS_KEY)) != null && clazz.isAssignableFrom(object.getClass())) {
            return (T)((BasicContextualColors)object);
        }
        return t;
    }

    public static void installColors(@NotNull JComponent jComponent, @NotNull AppearanceContext appearanceContext, @NotNull BasicContextualColors basicContextualColors) {
        if (jComponent instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            AquaColors.installTextColors(jTextComponent, appearanceContext, basicContextualColors);
        } else if (jComponent instanceof JTable) {
            JTable jTable = (JTable)jComponent;
            boolean bl = AquaColors.getTableStriped(jTable);
            AquaColors.installTableColors(jTable, appearanceContext, basicContextualColors, bl);
        } else if (jComponent instanceof JList) {
            JList jList = (JList)jComponent;
            boolean bl = AquaColors.getListStriped(jList);
            AquaColors.installListColors(jList, appearanceContext, basicContextualColors, bl);
        } else {
            AquaColors.installBasicColors(jComponent, appearanceContext, basicContextualColors);
        }
    }

    private static boolean getListStriped(@NotNull JList jList) {
        AquaListUI aquaListUI = AquaUtils.getUI(jList, AquaListUI.class);
        return aquaListUI != null && aquaListUI.isStriped();
    }

    private static boolean getTableStriped(@NotNull JTable jTable) {
        AquaTableUI aquaTableUI = AquaUtils.getUI(jTable, AquaTableUI.class);
        return aquaTableUI != null && aquaTableUI.isStriped();
    }

    private static void installBasicColors(@NotNull Component component, @NotNull AppearanceContext appearanceContext, @NotNull BasicContextualColors basicContextualColors) {
        Color color;
        Color color2 = component.getBackground();
        if (!AquaColors.isPriority(color2)) {
            component.setBackground(basicContextualColors.getBackground(appearanceContext));
        }
        if (!AquaColors.isPriority(color = component.getForeground())) {
            component.setForeground(basicContextualColors.getForeground(appearanceContext));
        }
    }

    private static void installTextColors(@NotNull JTextComponent jTextComponent, @NotNull AppearanceContext appearanceContext, @NotNull BasicContextualColors basicContextualColors) {
        Color color;
        Color color2;
        Color color3;
        Color color4;
        Color color5;
        AppearanceContext appearanceContext2 = appearanceContext.withSelected(true);
        Color color6 = jTextComponent.getBackground();
        if (!AquaColors.isPriority(color6)) {
            jTextComponent.setBackground(basicContextualColors.getBackground(appearanceContext));
        }
        if (!AquaColors.isPriority(color5 = jTextComponent.getForeground())) {
            jTextComponent.setForeground(basicContextualColors.getForeground(appearanceContext));
        }
        if (!AquaColors.isPriority(color4 = jTextComponent.getCaretColor())) {
            jTextComponent.setCaretColor(basicContextualColors.getForeground(appearanceContext));
        }
        if (!AquaColors.isPriority(color3 = jTextComponent.getSelectionColor())) {
            jTextComponent.setSelectionColor(basicContextualColors.getBackground(appearanceContext2));
        }
        if (!AquaColors.isPriority(color2 = jTextComponent.getSelectedTextColor())) {
            jTextComponent.setSelectedTextColor(basicContextualColors.getForeground(appearanceContext2));
        }
        if (!AquaColors.isPriority(color = jTextComponent.getDisabledTextColor())) {
            jTextComponent.setDisabledTextColor(basicContextualColors.getForeground(appearanceContext));
        }
    }

    private static void installTableColors(@NotNull JTable jTable, @NotNull AppearanceContext appearanceContext, @NotNull BasicContextualColors basicContextualColors, boolean bl) {
        Object object;
        if (bl) {
            jTable.setBackground(CLEAR);
        } else if (!AquaColors.isPriority(jTable.getBackground())) {
            jTable.setBackground(basicContextualColors.getBackground(appearanceContext));
        }
        if (!AquaColors.isPriority(jTable.getForeground())) {
            jTable.setForeground(basicContextualColors.getForeground(appearanceContext));
        }
        if (basicContextualColors instanceof ContainerContextualColors) {
            object = (ContainerContextualColors)basicContextualColors;
            if (!AquaColors.isPriority(jTable.getGridColor())) {
                jTable.setGridColor(object.getGrid(appearanceContext));
            }
        }
        object = appearanceContext.withSelected(true);
        if (!AquaColors.isPriority(jTable.getSelectionBackground())) {
            jTable.setSelectionBackground(basicContextualColors.getBackground((AppearanceContext)object));
        }
        if (!AquaColors.isPriority(jTable.getSelectionForeground())) {
            jTable.setSelectionForeground(basicContextualColors.getForeground((AppearanceContext)object));
        }
    }

    private static void installListColors(@NotNull JList jList, @NotNull AppearanceContext appearanceContext, @NotNull BasicContextualColors basicContextualColors, boolean bl) {
        if (bl) {
            jList.setBackground(CLEAR);
        } else if (!AquaColors.isPriority(jList.getBackground())) {
            jList.setBackground(basicContextualColors.getBackground(appearanceContext));
        }
        if (!AquaColors.isPriority(jList.getForeground())) {
            jList.setForeground(basicContextualColors.getForeground(appearanceContext));
        }
        AppearanceContext appearanceContext2 = appearanceContext.withSelected(true);
        if (!AquaColors.isPriority(jList.getSelectionBackground())) {
            jList.setSelectionBackground(basicContextualColors.getBackground(appearanceContext2));
        }
        if (!AquaColors.isPriority(jList.getSelectionForeground())) {
            jList.setSelectionForeground(basicContextualColors.getForeground(appearanceContext2));
        }
    }

    @NotNull
    public static Color getOrdinaryColor(@NotNull Color color) {
        if (color.getClass() == Color.class) {
            return color;
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    @NotNull
    public static List<String> getAllColorSuffixes() {
        return allColorSuffixes;
    }

    @Nullable
    public static String withoutInactive(@NotNull String string) {
        if (string.equals("_inactive")) {
            return "";
        }
        if (string.equals("_inactive_disabled")) {
            return "_disabled";
        }
        return null;
    }

    @NotNull
    public static String createSelectedColorName(@NotNull String string) {
        return "selected" + AquaColors.capitalize(string);
    }

    @NotNull
    public static String capitalize(@NotNull String string) {
        char c;
        if (!string.isEmpty() && !Character.isUpperCase(c = string.charAt(0))) {
            return Character.toUpperCase(c) + string.substring(1);
        }
        return string;
    }

    static {
        allColorSuffixes = Collections.unmodifiableList(Arrays.asList("_rollover", "_pressed", "_inactive", "_disabled", "_inactive_disabled", "_focused"));
    }

    public static class GradientColor
    extends ColorUIResource {
        @NotNull
        private final Color finish;
        private final boolean useMagicEraser;

        public GradientColor(@NotNull Color color, @NotNull Color color2) {
            super(color);
            this.finish = color2;
            this.useMagicEraser = false;
        }

        public GradientColor(@NotNull Color color, @NotNull Color color2, boolean bl) {
            super(color);
            this.finish = color2;
            this.useMagicEraser = bl;
            if (bl && color.getAlpha() == 255 && color2.getAlpha() == 255) {
                System.err.println("Magic eraser not needed with opaque gradient");
            }
        }

        @NotNull
        public Color getStart() {
            return this;
        }

        @NotNull
        public Color getFinish() {
            return this.finish;
        }

        public boolean useMagicEraser() {
            return this.useMagicEraser;
        }
    }

    public static class TintedEraser
    extends ColorUIResource {
        public TintedEraser(int n, int n2) {
            super(new Color(n, n, n, n2));
        }
    }
}

