/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.text.View;
import org.violetlib.aqua.AquaButtonUI;
import org.violetlib.aqua.AquaLabeledButtonBorder;
import org.violetlib.aqua.AquaUtilControlSize;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.jnr.aqua.AquaUIPainter;

public abstract class AquaButtonLabeledUI
extends AquaButtonUI {
    protected RecyclableSizingIcon regularIcon;
    protected RecyclableSizingIcon smallIcon;
    protected RecyclableSizingIcon miniIcon;
    protected final AquaLabeledButtonBorder widgetBorder;

    public AquaButtonLabeledUI(AquaLabeledButtonBorder aquaLabeledButtonBorder) {
        this.widgetBorder = aquaLabeledButtonBorder;
    }

    @Override
    protected Border getDefaultBorder(AbstractButton abstractButton, boolean bl) {
        return this.widgetBorder;
    }

    public Icon getDefaultIcon(JComponent jComponent) {
        AquaUIPainter.Size size;
        if (this.regularIcon == null) {
            this.regularIcon = this.createDefaultIcon(AquaUIPainter.Size.REGULAR);
            this.smallIcon = this.createDefaultIcon(AquaUIPainter.Size.SMALL);
            this.miniIcon = this.createDefaultIcon(AquaUIPainter.Size.MINI);
        }
        if ((size = AquaUtilControlSize.getUserSizeFrom(jComponent)) == AquaUIPainter.Size.REGULAR) {
            return (Icon)this.regularIcon.get();
        }
        if (size == AquaUIPainter.Size.SMALL) {
            return (Icon)this.smallIcon.get();
        }
        if (size == AquaUIPainter.Size.MINI) {
            return (Icon)this.miniIcon.get();
        }
        return (Icon)this.regularIcon.get();
    }

    protected RecyclableSizingIcon createDefaultIcon(AquaUIPainter.Size size) {
        return this.widgetBorder.createDefaultIcon(size);
    }

    @Override
    public Shape getFocusRingOutline(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = AquaUtils.getFontMetrics(jComponent, null, font);
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(abstractButton.getWidth(), abstractButton.getHeight());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(abstractButton);
        }
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        AquaUtils.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        return this.widgetBorder.getFocusRingOutline(abstractButton, rectangle2);
    }

    @Override
    public synchronized void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        ButtonModel buttonModel = abstractButton.getModel();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Dimension dimension = abstractButton.getSize();
        Insets insets = jComponent.getInsets();
        Rectangle rectangle = new Rectangle(abstractButton.getWidth(), abstractButton.getHeight());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Icon icon = abstractButton.getIcon();
        if (abstractButton.isOpaque()) {
            graphics.setColor(abstractButton.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width = abstractButton.getWidth() - (insets.right + rectangle.x);
        rectangle.height = abstractButton.getHeight() - (insets.bottom + rectangle.y);
        String string = AquaUtils.layoutCompoundLabel(jComponent, fontMetrics, abstractButton.getText(), icon != null ? icon : this.getDefaultIcon(abstractButton), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        if (icon == null) {
            this.widgetBorder.paintBackground(jComponent, graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            if (!buttonModel.isEnabled()) {
                icon = buttonModel.isSelected() ? abstractButton.getDisabledSelectedIcon() : abstractButton.getDisabledIcon();
            } else if (buttonModel.isPressed() && buttonModel.isArmed()) {
                icon = abstractButton.getPressedIcon();
                if (icon == null) {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (buttonModel.isSelected()) {
                if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                    icon = abstractButton.getRolloverSelectedIcon();
                    if (icon == null) {
                        icon = abstractButton.getSelectedIcon();
                    }
                } else {
                    icon = abstractButton.getSelectedIcon();
                }
            } else if (abstractButton.isRolloverEnabled() && buttonModel.isRollover()) {
                icon = abstractButton.getRolloverIcon();
            }
            if (icon == null) {
                icon = abstractButton.getIcon();
            }
            icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                view.paint(graphics, rectangle3);
            } else {
                this.paintText(graphics, abstractButton, rectangle3, string);
            }
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (jComponent.getComponentCount() > 0) {
            return null;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        String string = abstractButton.getText();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon(abstractButton);
        }
        Font font = abstractButton.getFont();
        FontMetrics fontMetrics = abstractButton.getFontMetrics(font);
        Rectangle rectangle = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE);
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        AquaUtils.layoutCompoundLabel(jComponent, fontMetrics, string, icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, string == null ? 0 : abstractButton.getIconTextGap());
        int n = Math.min(rectangle2.x, rectangle3.x);
        int n2 = Math.max(rectangle2.x + rectangle2.width, rectangle3.x + rectangle3.width);
        int n3 = Math.min(rectangle2.y, rectangle3.y);
        int n4 = Math.max(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height);
        int n5 = n2 - n;
        int n6 = n4 - n3;
        Insets insets = abstractButton.getInsets();
        return new Dimension(n5 += insets.left + insets.right, n6 += insets.top + insets.bottom);
    }

    public static class RecyclableSizingIcon
    extends AquaUtils.RecyclableSingleton<Icon> {
        final int iconWidth;
        final int iconHeight;

        public RecyclableSizingIcon(int n) {
            this.iconWidth = this.iconHeight = n;
        }

        public RecyclableSizingIcon(int n, int n2) {
            this.iconWidth = n;
            this.iconHeight = n2;
        }

        @Override
        protected Icon getInstance() {
            return new ImageIcon(new BufferedImage(this.iconWidth, this.iconHeight, 3));
        }
    }
}

