/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MultiResolutionImage;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.violetlib.aqua.JavaSupport;
import org.violetlib.aqua.VImageCache;

public class Aqua9MappedMultiResolutionImage
extends Image
implements MultiResolutionImage {
    private final Image baseImage;
    private final MyVariantMapper mapper;
    private int availableInfo;

    public Aqua9MappedMultiResolutionImage(MultiResolutionImage multiResolutionImage, Function<Image, Image> function) {
        this.baseImage = (Image)((Object)multiResolutionImage);
        this.mapper = new MyVariantMapper(multiResolutionImage, function);
    }

    @Override
    public List<Image> getResolutionVariants() {
        ArrayList<Image> arrayList = new ArrayList<Image>();
        MultiResolutionImage multiResolutionImage = (MultiResolutionImage)((Object)this.baseImage);
        for (Image image : multiResolutionImage.getResolutionVariants()) {
            int n = image.getWidth(null);
            int n2 = image.getHeight(null);
            if (n <= 0 || n2 <= 0) continue;
            Image image2 = this.mapper.apply(n, n2);
            arrayList.add(image2);
        }
        return arrayList;
    }

    @Override
    public ImageProducer getSource() {
        return this.baseImage.getSource();
    }

    @Override
    public Graphics getGraphics() {
        throw new UnsupportedOperationException("getGraphics() not supported on multiresolution images");
    }

    @Override
    public Image getResolutionVariant(double d, double d2) {
        ImageCacheKey imageCacheKey;
        int n = (int)Math.ceil(d);
        int n2 = (int)Math.ceil(d2);
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Invalid image size: " + n + "x" + n2);
        }
        VImageCache vImageCache = VImageCache.getInstance();
        Image image = vImageCache.getImage(imageCacheKey = new ImageCacheKey(this, n, n2));
        if (image == null) {
            image = this.mapper.apply(n, n2);
            vImageCache.setImage(imageCacheKey, image);
        }
        JavaSupport.preload(image, this.availableInfo);
        return image;
    }

    public Aqua9MappedMultiResolutionImage map(Function<Image, Image> function) {
        return new Aqua9MappedMultiResolutionImage(this, function);
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 1);
        return this.baseImage.getWidth(imageObserver);
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 2);
        return this.baseImage.getHeight(imageObserver);
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 4);
        return Image.UndefinedProperty;
    }

    @Override
    public Image getScaledInstance(int n, int n2, int n3) {
        return this.getResolutionVariant(n, n2);
    }

    private void updateInfo(ImageObserver imageObserver, int n) {
        this.availableInfo |= imageObserver == null ? 32 : n;
    }

    private static class ImageCacheKey
    implements VImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final int w;
        private final int h;
        private final Image baseImage;

        ImageCacheKey(Image image, int n, int n2) {
            this.baseImage = image;
            this.w = n;
            this.h = n2;
            this.pixelCount = n * n2;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int n = this.baseImage.hashCode();
            n = 31 * n + this.w;
            n = 31 * n + this.h;
            return n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageCacheKey) {
                ImageCacheKey imageCacheKey = (ImageCacheKey)object;
                return this.baseImage == imageCacheKey.baseImage && this.w == imageCacheKey.w && this.h == imageCacheKey.h;
            }
            return false;
        }
    }

    private static class MyVariantMapper
    implements BiFunction<Integer, Integer, Image> {
        private final MultiResolutionImage source;
        private final Function<Image, Image> mapper;

        public MyVariantMapper(MultiResolutionImage multiResolutionImage, Function<Image, Image> function) {
            this.source = multiResolutionImage;
            this.mapper = function;
        }

        @Override
        public Image apply(Integer n, Integer n2) {
            Image image = this.source.getResolutionVariant(n.intValue(), n2.intValue());
            return this.mapper.apply(image);
        }
    }
}

