/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.github;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import feign.Client;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.form.FormEncoder;
import feign.httpclient.ApacheHttpClient;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jreleaser.bundle.RB;
import org.jreleaser.logging.JReleaserLogger;
import org.jreleaser.model.spi.release.User;
import org.jreleaser.sdk.commons.ClientUtils;
import org.jreleaser.sdk.commons.RestAPIException;
import org.jreleaser.sdk.github.api.GhPackageVersion;
import org.jreleaser.sdk.github.api.GhRelease;
import org.jreleaser.sdk.github.api.GhReleaseNotes;
import org.jreleaser.sdk.github.api.GhReleaseNotesParams;
import org.jreleaser.sdk.github.api.GhSearchUser;
import org.jreleaser.sdk.github.api.GhUser;
import org.jreleaser.sdk.github.api.GithubAPI;
import org.jreleaser.sdk.github.internal.Page;
import org.jreleaser.sdk.github.internal.PaginatingDecoder;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.StringUtils;

class XGithub {
    public static final String USERS_NOREPLY_GITHUB_COM = "@users.noreply.github.com";
    private final JReleaserLogger logger;
    private final GithubAPI api;

    XGithub(JReleaserLogger logger, String endpoint, String token, int connectTimeout, int readTimeout) {
        Objects.requireNonNull(logger, "'logger' must not be null");
        StringUtils.requireNonBlank((String)token, (String)"'token' must not be blank");
        StringUtils.requireNonBlank((String)endpoint, (String)"'endpoint' must not be blank");
        ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE).setSerializationInclusion(JsonInclude.Include.NON_NULL).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.INDENT_OUTPUT, true);
        this.logger = logger;
        this.api = (GithubAPI)ClientUtils.builder((JReleaserLogger)logger, (int)connectTimeout, (int)readTimeout).client((Client)new ApacheHttpClient()).encoder((Encoder)new FormEncoder((Encoder)new JacksonEncoder(objectMapper))).decoder((Decoder)new PaginatingDecoder((Decoder)new JacksonDecoder(objectMapper))).requestInterceptor(template -> template.header("Authorization", new String[]{String.format("token %s", token)})).target(GithubAPI.class, endpoint);
    }

    void updateRelease(String owner, String repo, String tag, Long id, GhRelease release) throws RestAPIException {
        this.logger.debug(RB.$((String)"git.update.release", (Object[])new Object[0]), new Object[]{owner, repo, tag});
        this.api.updateRelease(release, owner, repo, id);
    }

    private String getPrivateEmailUserId(String email) {
        if (!email.endsWith(USERS_NOREPLY_GITHUB_COM)) {
            return null;
        }
        String username = email.substring(0, email.indexOf("@"));
        if (username.contains("+")) {
            username = username.substring(username.indexOf("+") + 1);
        }
        return username;
    }

    Optional<User> findUser(String email, String name) throws RestAPIException {
        GhUser user;
        this.logger.debug(RB.$((String)"git.user.lookup", (Object[])new Object[0]), new Object[]{name, email});
        String username = this.getPrivateEmailUserId(email);
        if (null != username && null != (user = this.api.getUser(username))) {
            return Optional.of(new User(user.getLogin(), email, user.getHtmlUrl()));
        }
        GhSearchUser search = this.api.searchUser(CollectionUtils.mapOf((Object[])new Object[]{"q", email}));
        if (search.getTotalCount() > 0) {
            GhUser user2 = search.getItems().get(0);
            return Optional.of(new User(user2.getLogin(), email, user2.getHtmlUrl()));
        }
        return Optional.empty();
    }

    GhReleaseNotes generateReleaseNotes(String owner, String repo, GhReleaseNotesParams params) throws RestAPIException {
        this.logger.info(RB.$((String)"github.generate.release.notes", (Object[])new Object[0]), new Object[]{owner, repo, params.getPreviousTagName(), params.getTagName()});
        return this.api.generateReleaseNotes(params, owner, repo);
    }

    List<GhPackageVersion> listPackageVersions(String packageType, String packageName) throws IOException {
        this.logger.debug(RB.$((String)"github.list.versions", (Object[])new Object[0]), new Object[]{packageType, packageName});
        ArrayList<GhPackageVersion> issues = new ArrayList<GhPackageVersion>();
        Page<List<GhPackageVersion>> page = this.api.listPackageVersions0(packageType, packageName);
        issues.addAll((Collection)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            try {
                this.collectPackageVersions(page, issues);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }
        return issues;
    }

    private void collectPackageVersions(Page<List<GhPackageVersion>> page, List<GhPackageVersion> issues) throws URISyntaxException {
        URI next = new URI(page.getLinks().next());
        this.logger.debug(next.toString());
        page = this.api.listPackageVersions1(next);
        issues.addAll((Collection<GhPackageVersion>)page.getContent());
        if (page.hasLinks() && page.getLinks().hasNext()) {
            this.collectPackageVersions(page, issues);
        }
    }

    void deletePackageVersion(String packageType, String packageName, String packageVersion) throws RestAPIException {
        this.logger.debug(RB.$((String)"github.delete.package.version", (Object[])new Object[0]), new Object[]{packageVersion, packageName});
        this.api.deletePackageVersion(packageType, packageName, packageVersion);
    }

    void deletePackage(String packageType, String packageName) throws RestAPIException {
        this.logger.debug(RB.$((String)"github.delete.package", (Object[])new Object[0]), new Object[]{packageType, packageName});
        this.api.deletePackage(packageType, packageName);
    }
}

