/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.packagers;

import java.io.Reader;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.stream.Collectors;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.distributions.Distribution;
import org.jreleaser.model.internal.packagers.WingetPackager;
import org.jreleaser.model.spi.packagers.PackagerProcessingException;
import org.jreleaser.mustache.MustacheUtils;
import org.jreleaser.mustache.TemplateContext;
import org.jreleaser.mustache.Templates;
import org.jreleaser.packagers.AbstractRepositoryPackagerProcessor;
import org.jreleaser.templates.TemplateUtils;
import org.jreleaser.util.PlatformUtils;

public class WingetPackagerProcessor
extends AbstractRepositoryPackagerProcessor<WingetPackager> {
    public WingetPackagerProcessor(JReleaserContext context) {
        super(context);
    }

    @Override
    protected void doPackageDistribution(Distribution distribution, TemplateContext props, Path packageDirectory) throws PackagerProcessingException {
        super.doPackageDistribution(distribution, props, packageDirectory);
        this.copyPreparedFiles(props);
    }

    @Override
    protected void fillPackagerProperties(TemplateContext props, Distribution distribution) {
        String desc = this.context.getModel().getProject().getLongDescription();
        desc = Arrays.stream(desc.split(System.lineSeparator())).map(line -> "  " + line).collect(Collectors.joining(System.lineSeparator()));
        props.set("projectLongDescription", (Object)MustacheUtils.passThrough((String)("|" + System.lineSeparator() + desc)));
        props.set("wingetDefaultLocale", (Object)((WingetPackager)this.packager).getDefaultLocale());
        props.set("wingetAuthor", (Object)((WingetPackager)this.packager).getAuthor());
        props.set("wingetMoniker", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getMoniker(), (TemplateContext)props));
        props.set("wingetMinimumOsVersion", (Object)((WingetPackager)this.packager).getMinimumOsVersion());
        props.set("wingetProductCode", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getProductCode(), (TemplateContext)props));
        props.set("wingetHasTags", (Object)(!((WingetPackager)this.packager).getTags().isEmpty() ? 1 : 0));
        props.set("wingetTags", (Object)((WingetPackager)this.packager).getTags());
        props.set("wingetPackageIdentifier", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPackage().getIdentifier(), (TemplateContext)props));
        props.set("wingetPackageName", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPackage().getName(), (TemplateContext)props));
        props.set("wingetPackageVersion", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPackage().getVersion(), (TemplateContext)props));
        props.set("wingetPackageUrl", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPackage().getUrl(), (TemplateContext)props));
        props.set("wingetPackagePublisher", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPublisher().getName(), (TemplateContext)props));
        props.set("wingetPublisherUrl", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPublisher().getUrl(), (TemplateContext)props));
        props.set("wingetPublisherSupportUrl", (Object)Templates.resolveTemplate((String)((WingetPackager)this.packager).getPublisher().getSupportUrl(), (TemplateContext)props));
        props.set("wingetInstallerType", (Object)((WingetPackager)this.packager).getInstaller().getType().toString());
        props.set("wingetScope", (Object)((WingetPackager)this.packager).getInstaller().getScope().toString());
        props.set("wingetInstallModes", (Object)((WingetPackager)this.packager).getInstaller().getModes());
        props.set("wingetUpgradeBehavior", (Object)((WingetPackager)this.packager).getInstaller().getUpgradeBehavior().toString());
        props.set("wingetReleaseDate", (Object)new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        String platform = (String)props.get("distributionArtifactPlatform");
        if (PlatformUtils.isIntel32((String)platform)) {
            platform = "x86";
        } else if (PlatformUtils.isIntel64((String)platform)) {
            platform = "x64";
        } else if (PlatformUtils.isArm32((String)platform)) {
            platform = "arm";
        } else if (PlatformUtils.isArm64((String)platform)) {
            platform = "arm64";
        }
        props.set("wingetInstallerArchitecture", (Object)platform);
    }

    @Override
    protected String applyTemplate(String fileName, Reader reader, TemplateContext props) {
        if ("locale.yaml".equals(fileName = TemplateUtils.trimTplExtension((String)fileName))) {
            props.set("wingetManifestType", (Object)"defaultLocale");
            props.set("wingetPackageLocale", (Object)((WingetPackager)this.packager).getDefaultLocale());
        } else if (fileName.startsWith("locale.")) {
            String locale = fileName.substring(7);
            locale = locale.substring(0, locale.length() - 5);
            props.set("wingetManifestType", (Object)"locale");
            props.set("wingetPackageLocale", (Object)locale);
        }
        return super.applyTemplate(fileName, reader, props);
    }

    @Override
    protected void writeFile(Distribution distribution, String content, TemplateContext props, Path outputDirectory, String fileName) throws PackagerProcessingException {
        fileName = TemplateUtils.trimTplExtension((String)fileName);
        String packageIdentifier = ((WingetPackager)this.getPackager()).getPackage().getIdentifier();
        if ("version.yaml".equals(fileName)) {
            fileName = packageIdentifier + ".version.yaml";
            outputDirectory = this.resolvePackageDirectory(outputDirectory, packageIdentifier);
        } else if ("installer.yaml".equals(fileName)) {
            fileName = packageIdentifier + ".installer.yaml";
            outputDirectory = this.resolvePackageDirectory(outputDirectory, packageIdentifier);
        } else if ("locale.yaml".equals(fileName)) {
            fileName = packageIdentifier + ".locale." + ((WingetPackager)this.getPackager()).getDefaultLocale() + ".yaml";
            outputDirectory = this.resolvePackageDirectory(outputDirectory, packageIdentifier);
        } else if (fileName.startsWith("locale") && fileName.endsWith(".yaml")) {
            fileName = packageIdentifier + "." + fileName;
            outputDirectory = this.resolvePackageDirectory(outputDirectory, packageIdentifier);
        }
        Path outputFile = outputDirectory.resolve(fileName);
        this.writeFile(content, outputFile);
    }

    private Path resolvePackageDirectory(Path outputDirectory, String packageIdentifier) {
        return outputDirectory.resolve(packageIdentifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + "/" + packageIdentifier.replace(".", "/") + "/" + this.context.getModel().getProject().getResolvedVersion());
    }
}

