/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.HttpUploader;
import org.jreleaser.model.internal.validation.common.HttpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class HttpUploaderValidator {
    private HttpUploaderValidator() {
    }

    public static void validateHttpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, HttpUploader> http = context.getModel().getUpload().getHttp();
        if (!http.isEmpty()) {
            context.getLogger().debug("upload.http");
        }
        for (Map.Entry<String, HttpUploader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            HttpUploaderValidator.validateHttp(context, e.getValue(), errors);
        }
    }

    private static void validateHttp(JReleaserContext context, HttpUploader http, Errors errors) {
        context.getLogger().debug("upload.http.{}", new Object[]{http.getName()});
        Validator.resolveActivatable(context, (Activatable)http, CollectionUtils.listOf((Object[])new String[]{"upload.http." + http.getName(), "upload.http"}), "NEVER");
        if (!http.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(http.isArtifacts() || http.isFiles() || http.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{http.getType(), http.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            http.disable();
            return;
        }
        if (StringUtils.isBlank((String)http.getUploadUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.http." + http.getName() + ".uploadUrl"}));
        }
        if (StringUtils.isBlank((String)http.getDownloadUrl())) {
            http.setDownloadUrl(http.getUploadUrl());
        }
        if (null == http.getMethod()) {
            http.setMethod(Http.Method.PUT);
        }
        HttpValidator.validateHttp(context, http, "upload", http.getName(), errors);
        Validator.validateTimeout(http);
    }
}

