/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.assemble;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Archive;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.assemble.NativeImageAssembler;
import org.jreleaser.model.internal.common.Artifact;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class NativeImageAssemblerResolver {
    private NativeImageAssemblerResolver() {
    }

    public static void resolveNativeImageOutputs(JReleaserContext context, Errors errors) {
        List<NativeImageAssembler> activeNativeImages = context.getModel().getAssemble().getActiveNativeImages();
        if (!activeNativeImages.isEmpty()) {
            context.getLogger().debug("assemble.nativeImage");
        }
        for (NativeImageAssembler nativeImage : activeNativeImages) {
            if (!nativeImage.isExported()) continue;
            NativeImageAssemblerResolver.resolveNativeImageOutputs(context, nativeImage, errors);
        }
    }

    private static void resolveNativeImageOutputs(JReleaserContext context, NativeImageAssembler nativeImage, Errors errors) {
        Path baseOutputDirectory = context.getAssembleDirectory().resolve(nativeImage.getName()).resolve(nativeImage.getType());
        String imageName = nativeImage.getResolvedImageName(context);
        if (StringUtils.isNotBlank((String)nativeImage.getImageNameTransform())) {
            imageName = nativeImage.getResolvedImageNameTransform(context);
        }
        for (Artifact graalJdk : nativeImage.getGraalJdks()) {
            if (!context.isPlatformSelected(graalJdk)) continue;
            String platform = graalJdk.getPlatform();
            String platformReplaced = nativeImage.getPlatform().applyReplacements(platform);
            String str = graalJdk.getExtraProperties().getOrDefault("archiveFormat", nativeImage.getArchiveFormat()).toString();
            Archive.Format archiveFormat = Archive.Format.of((String)str);
            Path image = baseOutputDirectory.resolve(imageName + "-" + platformReplaced + "." + archiveFormat.extension()).toAbsolutePath();
            if (!Files.exists(image, new LinkOption[0])) {
                errors.assembly(RB.$((String)"validation_missing_assembly", (Object[])new Object[]{nativeImage.getType(), nativeImage.getName(), nativeImage.getName()}));
                continue;
            }
            Artifact artifact = Artifact.of(image, platform);
            artifact.setExtraProperties(nativeImage.getExtraProperties());
            artifact.activate();
            nativeImage.addOutput(artifact);
        }
    }
}

