/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.TeamsAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class TeamsAnnouncerValidator {
    private static final String DEFAULT_TEAMS_TPL = "src/jreleaser/templates/teams.tpl";

    private TeamsAnnouncerValidator() {
    }

    public static void validateTeams(JReleaserContext context, TeamsAnnouncer teams, Errors errors) {
        context.getLogger().debug("announce.teams");
        Validator.resolveActivatable(context, (Activatable)teams, "announce.teams", "NEVER");
        if (!teams.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        teams.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.teams.webhook", "TEAMS_WEBHOOK"}), "announce.teams.webhook", teams.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)teams.getMessageTemplate())) {
            teams.setMessageTemplate(DEFAULT_TEAMS_TPL);
        }
        if (StringUtils.isNotBlank((String)teams.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(teams.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"teams.messageTemplate", teams.getMessageTemplate()}));
        }
        Validator.validateTimeout(teams);
    }
}

