/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.MastodonAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class MastodonAnnouncerValidator {
    private MastodonAnnouncerValidator() {
    }

    public static void validateMastodon(JReleaserContext context, MastodonAnnouncer mastodon, Errors errors) {
        context.getLogger().debug("announce.mastodon");
        Validator.resolveActivatable(context, (Activatable)mastodon, "announce.mastodon", "NEVER");
        if (!mastodon.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        mastodon.setHost(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.mastodon.host", "mastodon.host"}), "announce.mastodon.host", mastodon.getHost(), errors));
        mastodon.setAccessToken(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.mastodon.access.token", "MASTODON_ACCESS_TOKEN"}), "announce.mastodon.accessToken", mastodon.getAccessToken(), errors, context.isDryrun()));
        if (StringUtils.isNotBlank((String)mastodon.getStatusTemplate()) && !Files.exists(context.getBasedir().resolve(mastodon.getStatusTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"mastodon.statusTemplate", mastodon.getStatusTemplate()}));
        }
        if (StringUtils.isBlank((String)mastodon.getStatus()) && StringUtils.isBlank((String)mastodon.getStatusTemplate()) && mastodon.getStatuses().isEmpty()) {
            mastodon.setStatus(RB.$((String)"default.release.message", (Object[])new Object[0]));
        }
        Validator.validateTimeout(mastodon);
    }
}

