/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.announce;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collection;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.announce.DiscordAnnouncer;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class DiscordAnnouncerValidator {
    private static final String DEFAULT_DISCORD_TPL = "src/jreleaser/templates/discord.tpl";

    private DiscordAnnouncerValidator() {
    }

    public static void validateDiscord(JReleaserContext context, DiscordAnnouncer discord, Errors errors) {
        context.getLogger().debug("announce.discord");
        Validator.resolveActivatable(context, (Activatable)discord, "announce.discord", "NEVER");
        if (!discord.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        discord.setWebhook(Validator.checkProperty(context, (Collection<String>)CollectionUtils.listOf((Object[])new String[]{"announce.discord.webhook", "DISCORD_WEBHOOK"}), "announce.discord.webhook", discord.getWebhook(), errors, context.isDryrun()));
        if (StringUtils.isBlank((String)discord.getMessage()) && StringUtils.isBlank((String)discord.getMessageTemplate())) {
            if (Files.exists(context.getBasedir().resolve(DEFAULT_DISCORD_TPL), new LinkOption[0])) {
                discord.setMessageTemplate(DEFAULT_DISCORD_TPL);
            } else {
                discord.setMessage(RB.$((String)"default.release.message", (Object[])new Object[0]));
            }
        }
        if (StringUtils.isNotBlank((String)discord.getMessageTemplate()) && !Files.exists(context.getBasedir().resolve(discord.getMessageTemplate().trim()), new LinkOption[0])) {
            errors.configuration(RB.$((String)"validation_directory_not_exist", (Object[])new Object[]{"discord.messageTemplate", discord.getMessageTemplate()}));
        }
        Validator.validateTimeout(discord);
    }
}

