/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.sdk.git;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.EmptyCommitException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.GpgObjectSigner;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.spi.release.Commit;
import org.jreleaser.model.spi.release.Repository;
import org.jreleaser.sdk.git.JReleaserGpgSigner;
import org.jreleaser.util.Env;
import org.jreleaser.util.StringUtils;

public class GitSdk {
    public static final String REFS_TAGS = "refs/tags/";
    public static final String REFS_HEADS = "refs/heads/";
    public static final String REFS_REMOTES = "refs/remotes/";
    private final File basedir;
    private final boolean gitRootSearch;

    private GitSdk(File basedir, boolean gitRootSearch) {
        this.basedir = basedir;
        this.gitRootSearch = gitRootSearch;
    }

    public Git open() throws IOException {
        if (!this.gitRootSearch) {
            return Git.open((File)this.basedir);
        }
        for (File dir = this.basedir; null != dir; dir = dir.getParentFile()) {
            try {
                return Git.open((File)dir);
            }
            catch (RepositoryNotFoundException e) {
                continue;
            }
        }
        throw new RepositoryNotFoundException(this.basedir);
    }

    public Repository getRemote() throws IOException {
        Git git = this.open();
        String remote = GitSdk.resolveDefaultGitRemoteName();
        try {
            RemoteConfig remoteConfig = git.remoteList().call().stream().filter(rc -> remote.equals(rc.getName())).findFirst().orElseThrow(() -> new IOException(RB.$((String)"ERROR_git_repository_remote", (Object[])new Object[]{remote})));
            List uris = remoteConfig.getURIs();
            if (uris.isEmpty()) {
                throw new IOException(RB.$((String)"ERROR_git_repository_remote_missing_url", (Object[])new Object[]{remote}));
            }
            URIish uri = (URIish)uris.get(0);
            Repository.Kind kind = Repository.Kind.OTHER;
            switch (uri.getHost()) {
                case "github.com": {
                    kind = Repository.Kind.GITHUB;
                    break;
                }
                case "gitlab.com": {
                    kind = Repository.Kind.GITLAB;
                    break;
                }
                case "codeberg.org": {
                    kind = Repository.Kind.CODEBERG;
                    break;
                }
            }
            String[] parts = uri.getPath().split("/");
            if (parts.length < 2) {
                throw new IOException(RB.$((String)"ERROR_git_repository_remote_url_parse", (Object[])new Object[]{uri.getPath()}));
            }
            String owner = parts[parts.length - 2];
            String name = parts[parts.length - 1].replace(".git", "");
            return new Repository(kind, owner, name, null, uri.toString());
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_repository_origin_remote", (Object[])new Object[0]), e);
        }
    }

    public List<String> getLocalBranchNames() throws IOException {
        Git git = this.open();
        try {
            return git.branchList().call().stream().map(GitSdk::extractHeadName).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_repository_list_local_branch", (Object[])new Object[0]), e);
        }
    }

    public List<String> getRemoteBranches() throws IOException {
        Git git = this.open();
        try {
            return git.branchList().setListMode(ListBranchCommand.ListMode.REMOTE).call().stream().map(GitSdk::extractRemoteName).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_repository_list_local_branch", (Object[])new Object[0]), e);
        }
    }

    public Commit head() throws IOException {
        Git git = this.open();
        RevWalk walk = new RevWalk(git.getRepository());
        ObjectId head = git.getRepository().resolve("HEAD");
        RevCommit commit = null;
        try {
            commit = walk.parseCommit((AnyObjectId)head);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException(RB.$((String)"ERROR_head_commit_not_found", (Object[])new Object[0]));
        }
        Ref ref = git.getRepository().findRef("HEAD");
        PersonIdent authorIdent = commit.getAuthorIdent();
        Date authorDate = authorIdent.getWhen();
        TimeZone authorTimeZone = authorIdent.getTimeZone();
        ZoneId zoneId = ZoneId.of(authorTimeZone.getID());
        LocalDateTime local = LocalDateTime.ofInstant(authorDate.toInstant(), zoneId);
        ZonedDateTime zoned = ZonedDateTime.of(local, zoneId);
        return new Commit(commit.getId().abbreviate(7).name(), commit.getId().name(), GitSdk.extractHeadName(ref), commit.getCommitTime(), zoned);
    }

    public RevCommit resolveSingleCommit(Git git, Ref tag) throws GitAPIException {
        try {
            Iterable commits = git.log().add((AnyObjectId)this.getObjectId(git, tag)).setMaxCount(1).call();
            if (null == commits) {
                throw new EmptyCommitException(RB.$((String)"ERROR_git_commit_not_found", (Object[])new Object[]{tag.getName()}));
            }
            Iterator iterator = commits.iterator();
            if (iterator.hasNext()) {
                return (RevCommit)iterator.next();
            }
            throw new EmptyCommitException(RB.$((String)"ERROR_git_commit_not_found", (Object[])new Object[]{tag.getName()}));
        }
        catch (IOException e) {
            throw new EmptyCommitException(RB.$((String)"ERROR_git_commit_not_found", (Object[])new Object[]{tag.getName()}), (Throwable)e);
        }
    }

    public ObjectId getObjectId(Git git, Ref ref) throws IOException {
        Ref peeled = git.getRepository().getRefDatabase().peel(ref);
        return null != peeled.getPeeledObjectId() ? peeled.getPeeledObjectId() : peeled.getObjectId();
    }

    public void deleteTag(String tagName) throws IOException {
        Git git = this.open();
        try {
            git.tagDelete().setTags(new String[]{tagName}).call();
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_delete_tag", (Object[])new Object[]{tagName}), e);
        }
    }

    public boolean findTag(String tagName) throws IOException {
        Git git = this.open();
        try {
            return git.tagList().call().stream().map(GitSdk::extractTagName).anyMatch(tagName::matches);
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_find_tag", (Object[])new Object[]{tagName}), e);
        }
    }

    public boolean isShallow() {
        Path path = this.basedir.toPath();
        return Files.exists(path.resolve(".git/shallow"), new LinkOption[0]);
    }

    public void tag(String tagName, JReleaserContext context) throws IOException {
        this.tag(tagName, false, context);
    }

    public void tag(String tagName, boolean force, JReleaserContext context) throws IOException {
        Git git = this.open();
        try {
            boolean signEnabled = context.getModel().getRelease().getReleaser().isSign();
            git.tag().setSigned(signEnabled).setSigningKey("**********").setGpgSigner((GpgObjectSigner)new JReleaserGpgSigner(context, signEnabled)).setName(tagName).setForceUpdate(force).call();
        }
        catch (GitAPIException e) {
            throw new IOException(RB.$((String)"ERROR_git_create_tag", (Object[])new Object[]{tagName}), e);
        }
    }

    public static String resolveDefaultGitRemoteName() {
        String remoteName = Env.env((String)"DEFAULT_GIT_REMOTE", (String)"");
        if (StringUtils.isBlank((String)remoteName)) {
            remoteName = "origin";
        }
        return remoteName;
    }

    public static GitSdk of(JReleaserContext context) {
        return GitSdk.of(context.getBasedir().toFile(), context.isGitRootSearch());
    }

    public static GitSdk of(Path basedir, boolean gitRootSearch) {
        return GitSdk.of(basedir.toFile(), gitRootSearch);
    }

    public static GitSdk of(File basedir, boolean gitRootSearch) {
        return new GitSdk(basedir, gitRootSearch);
    }

    public static String extractTagName(Ref tag) {
        if (tag.getName().startsWith(REFS_TAGS)) {
            return tag.getName().substring(REFS_TAGS.length());
        }
        return "";
    }

    public static String extractHeadName(Ref ref) {
        if (ref.getTarget().getName().startsWith(REFS_HEADS)) {
            return ref.getTarget().getName().substring(REFS_HEADS.length());
        }
        return "";
    }

    public static String extractRemoteName(Ref ref) {
        String remoteName;
        String remoteAndBranch;
        if (ref.getTarget().getName().startsWith(REFS_REMOTES) && (remoteAndBranch = ref.getTarget().getName().substring(REFS_REMOTES.length())).startsWith(remoteName = GitSdk.resolveDefaultGitRemoteName())) {
            return remoteAndBranch.substring(remoteName.length() + 1);
        }
        return "";
    }

    public static class TagComparator
    implements Comparator<Ref> {
        @Override
        public int compare(Ref tag1, Ref tag2) {
            String tagName1 = GitSdk.extractTagName(tag1);
            String tagName2 = GitSdk.extractTagName(tag2);
            return tagName1.compareTo(tagName2);
        }
    }
}

