/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.jreleaser.model.Domain;
import org.jreleaser.util.Env;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class Milestone
implements Domain {
    public static final String MILESTONE_NAME = "MILESTONE_NAME";
    private Boolean close;
    private String name;
    private String cachedName;

    void setAll(Milestone changelog) {
        this.close = changelog.close;
        this.name = changelog.name;
    }

    public String getConfiguredName() {
        return Env.resolve((String)MILESTONE_NAME, (String)this.cachedName);
    }

    public String getResolvedName(Map<String, Object> props) {
        if (StringUtils.isBlank((String)this.cachedName)) {
            this.cachedName = this.getConfiguredName();
        }
        if (StringUtils.isBlank((String)this.cachedName)) {
            this.cachedName = MustacheUtils.applyTemplate((String)this.name, props);
        } else if (this.cachedName.contains("{{")) {
            this.cachedName = MustacheUtils.applyTemplate((String)this.cachedName, props);
        }
        return this.cachedName;
    }

    public String getEffectiveName() {
        return this.cachedName;
    }

    public Boolean isClose() {
        return this.close == null || this.close != false;
    }

    public void setClose(Boolean close) {
        this.close = close;
    }

    public boolean isCloseSet() {
        return this.close != null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Object> asMap(boolean full) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", this.name);
        map.put("close", this.isClose());
        return map;
    }
}

