/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.fasterxml.jackson.databind.JsonMappingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import org.kohsuke.github.GHFileNotFoundException;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHRef
extends GitHubInteractiveObject {
    private String ref;
    private String url;
    private GHObject object;

    public String getRef() {
        return this.ref;
    }

    public URL getUrl() {
        return GitHubClient.parseURL(this.url);
    }

    public GHObject getObject() {
        return this.object;
    }

    public void updateTo(String sha) throws IOException {
        this.updateTo(sha, false);
    }

    public void updateTo(String sha, Boolean force) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.root.createRequest().method("PATCH")).with("sha", sha)).with("force", force)).withUrlPath(this.url, new String[0])).fetch(GHRef.class).wrap(this.root);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root.createRequest().method("DELETE")).withUrlPath(this.url, new String[0])).send();
    }

    GHRef wrap(GitHub root) {
        this.root = root;
        return this;
    }

    static GHRef read(GHRepository repository, String refName) throws IOException {
        GHRef result;
        block4: {
            if (refName.startsWith("refs/")) {
                refName = refName.replaceFirst("refs/", "");
            }
            result = null;
            try {
                result = ((Requester)repository.root.createRequest().withUrlPath(repository.getApiTailUrl(String.format("git/refs/%s", refName)), new String[0])).fetch(GHRef.class).wrap(repository.root);
            }
            catch (IOException e) {
                if (e.getCause() instanceof JsonMappingException) break block4;
                throw e;
            }
        }
        if (result == null || !result.getRef().endsWith(refName)) {
            throw new GHFileNotFoundException(String.format("git/refs/%s", refName) + " {\"message\":\"Not Found\",\"documentation_url\":\"https://developer.github.com/v3/git/refs/#get-a-reference\"}");
        }
        return result;
    }

    static PagedIterable<GHRef> readMatching(GHRepository repository, String refType) throws IOException {
        if (refType.startsWith("refs/")) {
            refType = refType.replaceFirst("refs/", "");
        }
        String url = repository.getApiTailUrl(String.format("git/refs/%s", refType));
        if (refType.equals("")) {
            url = url.substring(0, url.length() - 1);
        }
        return ((Requester)repository.root.createRequest().withUrlPath(url, new String[0])).toIterable(GHRef[].class, item -> item.wrap(repository.root));
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD", "NP_UNWRITTEN_FIELD"}, justification="JSON API")
    public static class GHObject {
        private String type;
        private String sha;
        private String url;

        public String getType() {
            return this.type;
        }

        public String getSha() {
            return this.sha;
        }

        public URL getUrl() {
            return GitHubClient.parseURL(this.url);
        }
    }
}

