/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.validation;

import org.jreleaser.model.Chocolatey;
import org.jreleaser.model.ChocolateyBucket;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.JReleaserModel;
import org.jreleaser.model.validation.DistributionsValidator;
import org.jreleaser.model.validation.ExtraPropertiesValidator;
import org.jreleaser.model.validation.TemplateValidator;
import org.jreleaser.model.validation.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public abstract class ChocolateyValidator
extends Validator {
    public static void validateChocolatey(JReleaserContext context, Distribution distribution, Chocolatey tool, Errors errors) {
        JReleaserModel model = context.getModel();
        Chocolatey parentTool = model.getPackagers().getChocolatey();
        if (!tool.isActiveSet() && parentTool.isActiveSet()) {
            tool.setActive(parentTool.getActive());
        }
        if (!tool.resolveEnabled(context.getModel().getProject(), distribution)) {
            return;
        }
        GitService service = model.getRelease().getGitService();
        if (!service.isReleaseSupported()) {
            tool.disable();
            return;
        }
        context.getLogger().debug("distribution.{}.chocolatey", new Object[]{distribution.getName()});
        ChocolateyValidator.validateCommitAuthor(tool, parentTool);
        ChocolateyBucket bucket = tool.getBucket();
        bucket.resolveEnabled(model.getProject());
        ChocolateyValidator.validateTap(context, distribution, bucket, parentTool.getBucket(), "chocolatey.bucket");
        TemplateValidator.validateTemplate(context, distribution, tool, parentTool, errors);
        ExtraPropertiesValidator.mergeExtraProperties(tool, parentTool);
        ChocolateyValidator.validateContinueOnError(tool, parentTool);
        if (StringUtils.isBlank((String)tool.getUsername())) {
            tool.setUsername(service.getOwner());
        }
        if (!tool.isRemoteBuildSet() && parentTool.isRemoteBuildSet()) {
            tool.setRemoteBuild(parentTool.isRemoteBuild());
        }
        if (StringUtils.isBlank((String)tool.getTitle())) {
            tool.setTitle(parentTool.getTitle());
        }
        if (StringUtils.isBlank((String)tool.getTitle())) {
            tool.setTitle(model.getProject().getName());
        }
        if (!tool.isRemoteBuild()) {
            tool.setApiKey(ChocolateyValidator.checkProperty(context, "CHOCOLATEY_API_KEY", "chocolatey.apiKey", tool.getApiKey(), errors, context.isDryrun()));
        }
        DistributionsValidator.validateArtifactPlatforms(context, distribution, tool, errors);
    }
}

