/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jreleaser.model.AbstractJavaAssembler;
import org.jreleaser.model.Artifact;
import org.jreleaser.model.Distribution;
import org.jreleaser.model.Glob;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.util.MustacheUtils;
import org.jreleaser.util.StringUtils;

public class NativeImage
extends AbstractJavaAssembler {
    public static final String TYPE = "native-image";
    private final List<String> args = new ArrayList<String>();
    private final Artifact graal = new Artifact();
    private final Artifact mainJar = new Artifact();
    private final List<Glob> jars = new ArrayList<Glob>();
    private final List<Glob> files = new ArrayList<Glob>();
    private String imageName;
    private String imageNameTransform;

    public NativeImage() {
        super(TYPE);
    }

    @Override
    public Distribution.DistributionType getDistributionType() {
        return Distribution.DistributionType.NATIVE_IMAGE;
    }

    void setAll(NativeImage nativeImage) {
        super.setAll(nativeImage);
        this.imageName = nativeImage.imageName;
        this.imageNameTransform = nativeImage.imageNameTransform;
        this.setGraal(nativeImage.graal);
        this.setMainJar(nativeImage.mainJar);
        this.setArgs(nativeImage.args);
        this.setJars(nativeImage.jars);
        this.setFiles(nativeImage.files);
    }

    public String getResolvedImageName(JReleaserContext context) {
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageName, props);
    }

    public String getResolvedImageNameTransform(JReleaserContext context) {
        if (StringUtils.isBlank((String)this.imageNameTransform)) {
            return null;
        }
        Map<String, Object> props = context.props();
        props.putAll(this.props());
        return MustacheUtils.applyTemplate((String)this.imageNameTransform, props);
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public String getImageNameTransform() {
        return this.imageNameTransform;
    }

    public void setImageNameTransform(String imageNameTransform) {
        this.imageNameTransform = imageNameTransform;
    }

    public Artifact getGraal() {
        return this.graal;
    }

    public void setGraal(Artifact graal) {
        this.graal.setAll(graal);
    }

    public Artifact getMainJar() {
        return this.mainJar;
    }

    public void setMainJar(Artifact mainJar) {
        this.mainJar.setAll(mainJar);
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args.clear();
        this.args.addAll(args);
    }

    public void addArgs(List<String> args) {
        this.args.addAll(args);
    }

    public void addArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.add(arg.trim());
        }
    }

    public void removeArg(String arg) {
        if (StringUtils.isNotBlank((String)arg)) {
            this.args.remove(arg.trim());
        }
    }

    public List<Glob> getJars() {
        return this.jars;
    }

    public void setJars(List<Glob> jars) {
        this.jars.clear();
        this.jars.addAll(jars);
    }

    public void addJars(List<Glob> jars) {
        this.jars.addAll(jars);
    }

    public void addJar(Glob jar) {
        if (null != jar) {
            this.jars.add(jar);
        }
    }

    public List<Glob> getFiles() {
        return this.files;
    }

    public void setFiles(List<Glob> files) {
        this.files.clear();
        this.files.addAll(files);
    }

    public void addFiles(List<Glob> files) {
        this.files.addAll(files);
    }

    public void addFile(Glob file) {
        if (null != file) {
            this.files.add(file);
        }
    }

    @Override
    protected void asMap(boolean full, Map<String, Object> props) {
        super.asMap(full, props);
        props.put("imageName", this.imageName);
        props.put("imageNameTransform", this.imageNameTransform);
        props.put("graal", this.graal.asMap(full));
        props.put("mainJar", this.mainJar.asMap(full));
        props.put("args", this.args);
        LinkedHashMap<String, Map<String, Object>> mappedJars = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.jars.size(); ++i) {
            mappedJars.put("glob " + i, this.jars.get(i).asMap(full));
        }
        props.put("jars", mappedJars);
        LinkedHashMap<String, Map<String, Object>> mappedFiles = new LinkedHashMap<String, Map<String, Object>>();
        for (int i = 0; i < this.files.size(); ++i) {
            mappedFiles.put("glob " + i, this.files.get(i).asMap(full));
        }
        props.put("files", mappedFiles);
    }
}

