/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.builder.IResettableBuilder;
import com.helger.commons.state.ETriState;
import com.helger.commons.string.ToStringGenerator;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicThreadFactory.class);
    private static Thread.UncaughtExceptionHandler s_aDefaultUncaughtExceptionHandler = (thread, throwable) -> {
        if (LOGGER.isErrorEnabled()) {
            LOGGER.error("Uncaught exception from Thread " + thread.getName(), throwable);
        }
    };
    private final AtomicLong m_aThreadCounter = new AtomicLong();
    private final ThreadFactory m_aWrappedFactory;
    private final Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler;
    private final String m_sNamingPattern;
    private final Integer m_aPriority;
    private final ETriState m_eDaemon;

    public static void setDefaultUncaughtExceptionHandler(@Nonnull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        ValueEnforcer.notNull(uncaughtExceptionHandler, "DefaultUncaughtExceptionHandler");
        s_aDefaultUncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    @Nonnull
    public static Thread.UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return s_aDefaultUncaughtExceptionHandler;
    }

    protected BasicThreadFactory(@Nonnull Builder builder) {
        this.m_aWrappedFactory = builder.m_aWrappedFactory == null ? new ExtendedDefaultThreadFactory(builder.m_aThreadGroup) : builder.m_aWrappedFactory;
        this.m_sNamingPattern = builder.m_sNamingPattern;
        this.m_aPriority = builder.m_nPriority;
        this.m_eDaemon = builder.m_eDaemon;
        this.m_aUncaughtExceptionHandler = builder.m_aUncaughtExceptionHandler;
    }

    @Nonnull
    public final ThreadFactory getWrappedFactory() {
        return this.m_aWrappedFactory;
    }

    @Nonnull
    public final String getNamingPattern() {
        return this.m_sNamingPattern;
    }

    @Nonnull
    public final ETriState getDaemon() {
        return this.m_eDaemon;
    }

    @Nullable
    public final Integer getPriority() {
        return this.m_aPriority;
    }

    public final Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.m_aUncaughtExceptionHandler;
    }

    public long getThreadCount() {
        return this.m_aThreadCounter.get();
    }

    @OverrideOnDemand
    protected void initializeThread(@Nonnull Thread thread) {
        if (this.m_sNamingPattern != null) {
            Long l = this.m_aThreadCounter.incrementAndGet();
            thread.setName(String.format((Locale)null, this.m_sNamingPattern, l));
        }
        if (this.m_aUncaughtExceptionHandler != null) {
            thread.setUncaughtExceptionHandler(this.m_aUncaughtExceptionHandler);
        }
        if (this.m_aPriority != null) {
            thread.setPriority(this.m_aPriority);
        }
        if (this.m_eDaemon.isDefined()) {
            thread.setDaemon(this.m_eDaemon.getAsBooleanValue());
        }
    }

    @Override
    @Nonnull
    public Thread newThread(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        Thread thread = this.getWrappedFactory().newThread(runnable);
        this.initializeThread(thread);
        return thread;
    }

    public String toString() {
        return new ToStringGenerator(this).append("ThreadCounter", this.m_aThreadCounter).append("WrappedFactory", this.m_aWrappedFactory).append("UncaughtExceptionHandler", this.m_aUncaughtExceptionHandler).append("NamingPattern", this.m_sNamingPattern).append("Priority", this.m_aPriority).append("Daemon", this.m_eDaemon).getToString();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Thread.UncaughtExceptionHandler access$600() {
        return s_aDefaultUncaughtExceptionHandler;
    }

    public static class Builder
    implements IResettableBuilder<BasicThreadFactory> {
        private ThreadFactory m_aWrappedFactory;
        private ThreadGroup m_aThreadGroup;
        private Thread.UncaughtExceptionHandler m_aUncaughtExceptionHandler = BasicThreadFactory.access$600();
        private String m_sNamingPattern;
        private Integer m_nPriority;
        private ETriState m_eDaemon = ETriState.UNDEFINED;

        @Nonnull
        public final Builder wrappedFactory(@Nonnull ThreadFactory threadFactory) {
            ValueEnforcer.notNull(threadFactory, "Factory");
            this.m_aWrappedFactory = threadFactory;
            return this;
        }

        @Nonnull
        public final Builder threadGroup(@Nullable ThreadGroup threadGroup) {
            this.m_aThreadGroup = threadGroup;
            return this;
        }

        @Nonnull
        public final Builder uncaughtExceptionHandler(@Nonnull Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
            ValueEnforcer.notNull(uncaughtExceptionHandler, "ExceptionHandler");
            this.m_aUncaughtExceptionHandler = uncaughtExceptionHandler;
            return this;
        }

        @Nonnull
        public final Builder namingPattern(@Nonnull String string) {
            ValueEnforcer.notNull(string, "NamingPattern");
            this.m_sNamingPattern = string;
            return this;
        }

        @Nonnull
        public final Builder priority(int n) {
            this.m_nPriority = n;
            return this;
        }

        @Nonnull
        public final Builder daemon(boolean bl) {
            this.m_eDaemon = ETriState.valueOf(bl);
            return this;
        }

        @Override
        public void reset() {
            this.m_aWrappedFactory = null;
            this.m_aThreadGroup = null;
            this.m_aUncaughtExceptionHandler = null;
            this.m_sNamingPattern = null;
            this.m_nPriority = null;
            this.m_eDaemon = null;
        }

        @Override
        @Nonnull
        public BasicThreadFactory build() {
            return new BasicThreadFactory(this);
        }
    }

    static class ExtendedDefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger FACTORY_ID = new AtomicInteger(1);
        private final ThreadGroup m_aGroup;
        private final AtomicInteger m_aThreadNumber = new AtomicInteger(1);
        private final String m_sNamePrefix;

        ExtendedDefaultThreadFactory(@Nullable ThreadGroup threadGroup) {
            SecurityManager securityManager = System.getSecurityManager();
            this.m_aGroup = securityManager != null ? securityManager.getThreadGroup() : (threadGroup != null ? threadGroup : Thread.currentThread().getThreadGroup());
            this.m_sNamePrefix = "factory-" + FACTORY_ID.getAndIncrement() + "-thread-";
        }

        @Override
        @Nonnull
        public Thread newThread(@Nonnull Runnable runnable) {
            Thread thread = new Thread(this.m_aGroup, runnable, this.m_sNamePrefix + this.m_aThreadNumber.getAndIncrement(), 0L);
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

