/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JMeterError;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanShellInterpreter {
    private static final Logger log = LoggerFactory.getLogger(BeanShellInterpreter.class);
    private static final Method bshGet;
    private static final Method bshSet;
    private static final Method bshEval;
    private static final Method bshSource;
    private static final Class<?> bshClass;
    private static final String BSH_INTERPRETER = "bsh.Interpreter";
    private Object bshInstance = null;
    private final String initFile;
    private final Logger logger;

    public BeanShellInterpreter() throws ClassNotFoundException {
        this(null, null);
    }

    public BeanShellInterpreter(String init, Logger log) throws ClassNotFoundException {
        this.initFile = init;
        this.logger = log;
        this.init();
    }

    private void init() throws ClassNotFoundException {
        if (bshClass == null) {
            throw new ClassNotFoundException(BSH_INTERPRETER);
        }
        try {
            this.bshInstance = bshClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            log.error("Can't instantiate BeanShell", (Throwable)e);
            throw new ClassNotFoundException("Can't instantiate BeanShell", e);
        }
        if (this.logger != null) {
            try {
                this.set("log", this.logger);
            }
            catch (JMeterException e) {
                log.warn("Can't set logger variable", (Throwable)e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.initFile)) {
            String fileToUse = this.initFile;
            File in = new File(fileToUse);
            if (!in.exists() && !(in = new File(fileToUse = JMeterUtils.getJMeterHome() + File.separator + "bin" + File.separator + this.initFile)).exists()) {
                log.warn("Cannot find init file: {}", (Object)this.initFile);
            }
            if (!in.canRead()) {
                log.warn("Cannot read init file: {}", (Object)fileToUse);
            }
            try {
                this.source(fileToUse);
            }
            catch (JMeterException e) {
                log.warn("Cannot source init file: {}", (Object)fileToUse, (Object)e);
            }
        }
    }

    public void reset() throws ClassNotFoundException {
        this.init();
    }

    private Object bshInvoke(Method m, Object[] o, boolean shouldLog) throws JMeterException {
        Object r = null;
        String errorString = "Error invoking bsh method: ";
        try {
            r = m.invoke(this.bshInstance, o);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            String message = "Error invoking bsh method: " + m.getName();
            log.error(message);
            throw new JMeterError(message, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String message = "Error invoking bsh method: " + m.getName();
            Throwable cause = e.getCause();
            if (cause != null) {
                message = message + "\t" + cause.getLocalizedMessage();
            }
            if (shouldLog) {
                log.error(message);
            }
            throw new JMeterException(message, (Throwable)e);
        }
        return r;
    }

    public Object eval(String s) throws JMeterException {
        return this.bshInvoke(bshEval, new Object[]{s}, true);
    }

    public Object evalNoLog(String s) throws JMeterException {
        return this.bshInvoke(bshEval, new Object[]{s}, false);
    }

    public Object set(String s, Object o) throws JMeterException {
        return this.bshInvoke(bshSet, new Object[]{s, o}, true);
    }

    public Object set(String s, boolean b) throws JMeterException {
        return this.bshInvoke(bshSet, new Object[]{s, b}, true);
    }

    public Object source(String s) throws JMeterException {
        return this.bshInvoke(bshSource, new Object[]{s}, true);
    }

    public Object get(String s) throws JMeterException {
        return this.bshInvoke(bshGet, new Object[]{s}, true);
    }

    public static boolean isInterpreterPresent() {
        return bshClass != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Method get = null;
        Method eval = null;
        Method set = null;
        Method source = null;
        Class<?> clazz = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            clazz = loader.loadClass(BSH_INTERPRETER);
            Class<String> string = String.class;
            Class<Object> object = Object.class;
            get = clazz.getMethod("get", string);
            eval = clazz.getMethod("eval", string);
            set = clazz.getMethod("set", string, object);
            source = clazz.getMethod("source", string);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            log.error("Beanshell Interpreter not found", (Throwable)e);
        }
        finally {
            bshEval = eval;
            bshGet = get;
            bshSet = set;
            bshSource = source;
            bshClass = clazz;
        }
    }
}

