/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.table.renderer;

import com.github.weisj.darklaf.delegate.TableCellRendererDelegate;
import com.github.weisj.darklaf.ui.cell.CellUtil;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererCheckBox;
import com.github.weisj.darklaf.ui.cell.DarkCellRendererRadioButton;
import com.github.weisj.darklaf.ui.table.DarkTableCellFocusBorder;
import com.github.weisj.darklaf.ui.table.DarkTableUI;
import com.github.weisj.darklaf.ui.table.TableConstants;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class DarkTableCellRendererDelegate
extends TableCellRendererDelegate
implements TableConstants {
    private final DarkCellRendererCheckBox checkBoxRenderer = new DarkCellRendererCheckBox();
    private final DarkCellRendererRadioButton radioRenderer = new DarkCellRendererRadioButton();

    public DarkTableCellRendererDelegate(TableCellRenderer renderer) {
        super(renderer);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        boolean paintSelected;
        boolean columnLeadSelection;
        boolean booleanRenderer = TableConstants.useBooleanEditorForValue(value, table, column);
        TableCellRenderer renderer = booleanRenderer ? this.getBooleanRenderer(table) : super.getDelegate();
        Component component = renderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        boolean isRowFocus = DarkTableCellFocusBorder.isRowFocusBorder(table) && table.getSelectionModel().getLeadSelectionIndex() == row;
        boolean rowLeadSelection = table.getSelectionModel().getLeadSelectionIndex() == row;
        boolean bl = columnLeadSelection = table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == column;
        if (rowLeadSelection && !columnLeadSelection && PropertyUtil.getBooleanProperty((JComponent)table, (String)"JTable.rowFocusBorder")) {
            columnLeadSelection = true;
        }
        boolean isLeadSelectionCell = DarkUIUtil.hasFocus(table) && rowLeadSelection && columnLeadSelection;
        boolean bl2 = paintSelected = isSelected && !isLeadSelectionCell;
        if (component instanceof JComponent) {
            this.setupBorderStyle(table, row, column, (JComponent)component, isLeadSelectionCell, isRowFocus);
        }
        CellUtil.setupTableForeground(component, table, paintSelected, row);
        CellUtil.setupTableBackground(component, table, paintSelected, row);
        return component;
    }

    public void setupBorderStyle(JTable table, int row, int column, JComponent component, boolean isLeadSelectionCell, boolean isRowFocus) {
        Border focusBorder = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
        if ((isRowFocus || isLeadSelectionCell) && !table.isEditing()) {
            PropertyUtil.installBorder((JComponent)component, (Border)focusBorder);
            if (isRowFocus) {
                component.putClientProperty("JTable.rowFocusBorder", true);
                JTableHeader header = table.getTableHeader();
                TableColumn draggedColumn = header == null ? null : header.getDraggedColumn();
                boolean forceLeft = false;
                boolean forceRight = false;
                if (draggedColumn != null) {
                    int index = DarkTableUI.viewIndexForColumn(draggedColumn, table);
                    forceLeft = column == index + 1 || column == index;
                    forceRight = column == index - 1 || column == index;
                }
                component.putClientProperty("JTable.forcePaintRight", forceRight);
                component.putClientProperty("JTable.forcePaintLeft", forceLeft);
            } else {
                component.putClientProperty("JTable.rowFocusBorder", false);
            }
        } else if (component.getBorder() == focusBorder) {
            component.setBorder(UIManager.getBorder("Table.cellNoFocusBorder"));
        }
    }

    protected TableCellRenderer getBooleanRenderer(JTable table) {
        if (PropertyUtil.isPropertyEqual((JComponent)table, (String)"JTable.booleanRenderType", (Object)"radioButton")) {
            return this.radioRenderer;
        }
        return this.checkBoxRenderer;
    }
}

