/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.ui.spinner.DarkSpinnerUI;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class DarkSpinnerListener
extends MouseAdapter
implements PropertyChangeListener,
FocusListener,
SpinnerConstants {
    protected final JSpinner spinner;
    protected final DarkSpinnerUI ui;

    public DarkSpinnerListener(JSpinner spinner, DarkSpinnerUI ui) {
        this.spinner = spinner;
        this.ui = ui;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        this.spinner.getEditor().requestFocusInWindow();
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.spinner.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.spinner.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        Component editorComponent = this.ui.getEditorComponent();
        JComponent editor = this.ui.getEditor();
        if ("opaque".equals(key)) {
            boolean val = Boolean.TRUE.equals(evt.getNewValue());
            this.spinner.getEditor().setOpaque(val);
            if (editorComponent instanceof JComponent) {
                ((JComponent)editorComponent).setOpaque(val);
            }
        } else if ("JComponent.isTableEditor".equals(key)) {
            if (Boolean.FALSE.equals(evt.getNewValue()) && editor instanceof JSpinner.DefaultEditor) {
                int alignment = UIManager.getInt("Spinner.editorAlignment");
                JFormattedTextField text = ((JSpinner.DefaultEditor)editor).getTextField();
                text.setHorizontalAlignment(alignment);
            }
            this.spinner.revalidate();
            this.spinner.repaint();
        } else if ("JSpinner.cellEditorAlignment".equals(key) && SpinnerConstants.isTableCellEditor(this.spinner)) {
            if (editorComponent instanceof JTextField && evt.getNewValue() instanceof Integer) {
                ((JTextField)editorComponent).setHorizontalAlignment((Integer)evt.getNewValue());
            }
            this.spinner.revalidate();
        } else if ("JSpinner.variant".equals(key)) {
            this.spinner.repaint();
        } else if ("JComponent.isTreeEditor".equals(key)) {
            this.spinner.revalidate();
            this.spinner.repaint();
        } else if ("enabled".equals(key)) {
            PropertyUtil.installBackground((Component)this.spinner, (Color)(this.spinner.isEnabled() ? this.ui.background : this.ui.inactiveBackground));
        }
    }
}

