/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.scrollpane;

import com.github.weisj.darklaf.graphics.Animator;
import com.github.weisj.darklaf.ui.scrollpane.DarkScrollBarUI;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarConstants;
import com.github.weisj.darklaf.ui.scrollpane.ScrollBarUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DarkScrollBarListener
extends MouseAdapter
implements AdjustmentListener,
ScrollBarConstants {
    private static final float MAX_TRACK_ALPHA = 0.3f;
    private static final float MAX_THUMB_ALPHA = 1.0f;
    private static final int DELAY_FRAMES = 6;
    private static final int FADEOUT_FRAMES_COUNT = 16;
    private static final int FADEIN_FRAMES_COUNT = 8;
    private static final int FADEOUT_FRAME_COUNT_FACTOR = 25;
    private static final int FADEIN_FRAME_COUNT_FACTOR = 25;
    protected final JScrollBar scrollbar;
    private final DarkScrollBarUI ui;
    private final Animator trackFadeoutAnimator;
    private final Animator trackFadeinAnimator;
    private final Animator thumbFadeoutAnimator;
    private final Animator thumbFadeinAnimator;
    protected boolean mouseOverThumb = false;
    protected boolean mouseOverTrack = false;
    protected float trackAlpha;
    protected float thumbAlpha;

    public DarkScrollBarListener(JScrollBar scrollbar, DarkScrollBarUI ui) {
        this.scrollbar = scrollbar;
        this.ui = ui;
        this.trackFadeoutAnimator = this.createTrackFadeoutAnimator();
        this.trackFadeinAnimator = this.createTrackFadeinAnimator();
        this.thumbFadeoutAnimator = this.createThumbFadeoutAnimator();
        this.thumbFadeinAnimator = this.createThumbFadeinAnimator();
    }

    public void uninstall() {
        this.trackFadeoutAnimator.dispose();
        this.thumbFadeoutAnimator.dispose();
        this.trackFadeinAnimator.dispose();
        this.thumbFadeinAnimator.dispose();
    }

    public float getTrackAlpha() {
        return this.trackAlpha;
    }

    public float getThumbAlpha() {
        return this.thumbAlpha;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.scrollbar.getParent() instanceof JScrollPane && !((JScrollPane)this.scrollbar.getParent()).isWheelScrollingEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 1 && !e.isShiftDown() || this.scrollbar.getOrientation() == 0 && e.isShiftDown()) {
            this.scrollbar.setValueIsAdjusting(true);
            JScrollPane sp = (JScrollPane)PropertyUtil.getObject((JComponent)this.scrollbar, (String)"JScrollBar.scrollPaneParent", JScrollPane.class);
            if (this.scrollbar.getParent() instanceof JScrollPane) {
                ScrollBarUtil.doScroll(this.scrollbar, ((JScrollPane)this.scrollbar.getParent()).getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else if (sp != null) {
                ScrollBarUtil.doScroll(this.scrollbar, sp.getViewport(), e, this.scrollbar.getParent().getComponentOrientation().isLeftToRight());
            } else {
                ScrollBarUtil.doScroll(this.scrollbar, null, e, this.scrollbar.getComponentOrientation().isLeftToRight());
            }
            this.scrollbar.setValueIsAdjusting(false);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e == null) {
            return;
        }
        boolean overThumb = this.isOverThumb(e.getPoint());
        if (overThumb != this.mouseOverThumb) {
            this.mouseOverThumb = overThumb;
            if (!this.scrollbar.getValueIsAdjusting()) {
                this.resetThumbAnimator();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!this.ui.getTrackBounds().contains(e.getPoint())) {
            this.mouseOverTrack = false;
            this.resetTrackAnimator();
        }
        if (!this.ui.getThumbBounds().contains(e.getPoint())) {
            this.mouseOverThumb = false;
            this.resetThumbAnimator();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.ui.getThumbBounds().isEmpty()) {
            return;
        }
        this.mouseOverTrack = true;
        if (!this.scrollbar.getValueIsAdjusting()) {
            this.resetTrackAnimator();
        }
        this.mouseMoved(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.ui.getThumbBounds().isEmpty()) {
            return;
        }
        this.mouseOverTrack = false;
        if (!this.scrollbar.getValueIsAdjusting()) {
            this.resetTrackAnimator();
        }
        this.mouseMoved(e);
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!e.getValueIsAdjusting()) {
            return;
        }
        JScrollBar scrollBar = (JScrollBar)e.getAdjustable();
        int extent = scrollBar.getModel().getExtent();
        int value = scrollBar.getValue() + extent;
        if (value == extent || value == scrollBar.getMaximum()) {
            return;
        }
        Point p = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(p, this.scrollbar);
        if (!(this.ui.getThumbBounds().contains(p) || e.getValueIsAdjusting() || this.thumbFadeinAnimator.isRunning())) {
            this.mouseOverThumb = true;
            this.resetThumbAnimator();
        }
    }

    protected boolean isOverThumb(Point p) {
        Rectangle bounds = this.ui.getThumbBounds();
        return bounds != null && bounds.contains(p);
    }

    protected void resetThumbAnimator() {
        this.resetAnimators(this.thumbFadeinAnimator, this.thumbFadeoutAnimator, this.mouseOverThumb, this.thumbAlpha, 1.0f);
    }

    protected void resetTrackAnimator() {
        this.resetAnimators(this.trackFadeinAnimator, this.trackFadeoutAnimator, this.mouseOverTrack, this.trackAlpha, 0.3f);
    }

    protected void resetAnimators(Animator fadeInAnimator, Animator fadeOutAnimator, boolean overAnimatedComponent, float currentAlpha, float maxAlpha) {
        fadeInAnimator.reset();
        fadeOutAnimator.reset();
        if (this.scrollbar != null && (this.scrollbar.getValueIsAdjusting() || overAnimatedComponent)) {
            fadeOutAnimator.suspend();
            int startFrame = (int)(currentAlpha / maxAlpha * fadeInAnimator.getTotalFrames());
            fadeInAnimator.resume(startFrame);
        } else {
            fadeInAnimator.suspend();
            int startFrame = 0;
            if (currentAlpha < maxAlpha) {
                startFrame = (int)((1.0 - (double)(currentAlpha / maxAlpha)) * (double)fadeOutAnimator.getTotalFrames());
            }
            fadeOutAnimator.resume(startFrame);
        }
    }

    protected Animator createTrackFadeoutAnimator() {
        return new TrackFadeOutAnimator();
    }

    protected Animator createThumbFadeoutAnimator() {
        return new ThumbFadeOutAnimator();
    }

    protected Animator createTrackFadeinAnimator() {
        return new TrackFadeInAnimator();
    }

    protected Animator createThumbFadeinAnimator() {
        return new ThumbFadeInAnimator();
    }

    protected class ThumbFadeOutAnimator
    extends Animator {
        public ThumbFadeOutAnimator() {
            super("Adjustment fadeout", 16, 400, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            DarkScrollBarListener.this.thumbAlpha = 1.0f;
            if (frame > 6) {
                DarkScrollBarListener.this.thumbAlpha *= (float)(1.0 - (double)frame / (double)totalFrames);
            }
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkScrollBarListener.this.thumbAlpha = 0.0f;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }
    }

    protected class TrackFadeInAnimator
    extends Animator {
        public TrackFadeInAnimator() {
            super("Track fadein", 8, 200, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            DarkScrollBarListener.this.trackAlpha = (float)frame * 0.3f / (float)totalFrames;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkScrollBarListener.this.trackAlpha = 0.3f;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }
    }

    protected class ThumbFadeInAnimator
    extends Animator {
        public ThumbFadeInAnimator() {
            super("Thumb fadein", 4, 200, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            DarkScrollBarListener.this.thumbAlpha = (float)frame * 1.0f / (float)totalFrames;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkScrollBarListener.this.thumbAlpha = 1.0f;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
                Point p = MouseInfo.getPointerInfo().getLocation();
                SwingUtilities.convertPointFromScreen(p, DarkScrollBarListener.this.scrollbar);
                if (!DarkScrollBarListener.this.ui.getThumbBounds().contains(p) && !DarkScrollBarListener.this.scrollbar.getValueIsAdjusting()) {
                    DarkScrollBarListener.this.mouseOverThumb = false;
                    DarkScrollBarListener.this.resetThumbAnimator();
                }
            }
        }
    }

    protected class TrackFadeOutAnimator
    extends Animator {
        public TrackFadeOutAnimator() {
            super("Track fadeout", 16, 400, false);
        }

        @Override
        public void paintNow(int frame, int totalFrames, int cycle) {
            DarkScrollBarListener.this.trackAlpha = 0.3f;
            if (frame > 6) {
                DarkScrollBarListener.this.trackAlpha *= (float)(1.0 - (double)frame / (double)totalFrames);
            }
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }

        @Override
        protected void paintCycleEnd() {
            DarkScrollBarListener.this.trackAlpha = 0.0f;
            if (DarkScrollBarListener.this.scrollbar != null) {
                ((JComponent)DarkScrollBarListener.this.scrollbar.getParent()).paintImmediately(DarkScrollBarListener.this.scrollbar.getBounds());
            }
        }
    }
}

