/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.button;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.button.ButtonConstants;
import com.github.weisj.darklaf.util.AlignmentExt;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkButtonBorder
implements Border,
UIResource {
    private final Color focusBorderColor = UIManager.getColor("Button.focusBorderColor");
    private final Color defaultBorderColor = UIManager.getColor("Button.defaultBorderColor");
    private final Color borderColor = UIManager.getColor("Button.activeBorderColor");
    private final Color inactiveBorderColor = UIManager.getColor("Button.inactiveBorderColor");
    private final int arc = UIManager.getInt("Button.arc");
    private final int focusArc = UIManager.getInt("Button.focusArc");
    private final int squareFocusArc = UIManager.getInt("Button.squareFocusArc");
    private final int altArc = UIManager.getInt("Button.altArc");
    private final int minimumArc = UIManager.getInt("Button.minimumArc");
    private final int borderSize = UIManager.getInt("Button.borderThickness");
    private final int shadowSize = UIManager.getInt("Button.shadowHeight");

    public static boolean showDropShadow(JComponent c) {
        return DarkButtonBorder.showDropShadow(DarkButtonBorder.getCornerFlag(c)) && !ButtonConstants.isBorderlessVariant(c);
    }

    public static boolean showDropShadow(AlignmentExt a) {
        return a == null || a == AlignmentExt.SOUTH || a == AlignmentExt.SOUTH_EAST || a == AlignmentExt.SOUTH_WEST || a == AlignmentExt.LEFT || a == AlignmentExt.RIGHT || a == AlignmentExt.BOTTOM || a == AlignmentExt.MIDDLE_HORIZONTAL;
    }

    protected int getArc(Component c) {
        return ButtonConstants.chooseArcWithBorder(c, this.arc, 0, this.altArc, this.getBorderSize());
    }

    protected int getFocusArc(Component c) {
        return ButtonConstants.chooseArcWithBorder(c, this.focusArc, this.minimumArc, this.squareFocusArc, this.getBorderSize());
    }

    public static AlignmentExt getCornerFlag(Component component) {
        return (AlignmentExt)PropertyUtil.getObject((Component)component, (String)"JButton.cornerFlag", AlignmentExt.class, null);
    }

    protected int getShadowSize(JComponent c) {
        return DarkButtonBorder.showDropShadow(c) ? this.getShadowSize() : 0;
    }

    protected int getShadowSize() {
        return this.shadowSize;
    }

    protected int getBorderSize() {
        return this.borderSize;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (ButtonConstants.isBorderlessVariant(c)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(x, y);
        int arc = this.getArc(c);
        int focusArc = this.getFocusArc(c);
        GraphicsContext config = new GraphicsContext(g);
        AlignmentExt corner = DarkButtonBorder.getCornerFlag(c);
        boolean paintShadow = DarkButtonBorder.showDropShadow(corner);
        boolean focus = this.paintFocus(c);
        int shadowHeight = paintShadow ? this.getShadowSize() : 0;
        int borderSize = this.getBorderSize();
        Insets insetMask = new Insets(borderSize, borderSize, Math.max(borderSize, shadowHeight), borderSize);
        Insets focusIns = new Insets(0, 0, 0, 0);
        if (corner != null) {
            focusIns = corner.maskInsets(focusIns, -borderSize - focusArc);
            insetMask = corner.maskInsets(insetMask, -arc);
        }
        int bx = insetMask.left;
        int by = insetMask.top;
        int bw = width - insetMask.left - insetMask.right;
        int bh = height - insetMask.top - insetMask.bottom;
        int fx = focusIns.left;
        int fy = focusIns.top;
        int fw = width - focusIns.left - focusIns.right;
        int fh = by + bh + borderSize - focusIns.top - focusIns.bottom;
        if (this.paintFocus(c)) {
            g.translate(fx, fy);
            PaintUtil.paintFocusBorder(g2, fw, fh, focusArc, borderSize);
            g.translate(-fx, -fy);
        }
        g2.setColor(this.getBorderColor(c, focus));
        PaintUtil.paintLineBorder(g2, bx, by, bw, bh, arc);
        if (corner != null) {
            this.paintNeighbourFocus(g2, c, width, height);
        }
        config.restore();
    }

    protected void paintNeighbourFocus(Graphics2D g2, Component c, int width, int height) {
        JComponent bottomRight;
        boolean paintBottomRight;
        JComponent bottomLeft;
        boolean paintBottomLeft;
        JComponent bottom;
        boolean paintBottom;
        JComponent topRight;
        boolean paintTopRight;
        JComponent topLeft;
        boolean paintTopLeft;
        JComponent top;
        boolean paintTop;
        JComponent right;
        boolean paintRight;
        JComponent left = ButtonConstants.getNeighbour("JButton.leftNeighbour", c);
        boolean paintLeft = DarkUIUtil.hasFocus(left);
        if (paintLeft) {
            AlignmentExt corner = DarkButtonBorder.getCornerFlag(left);
            Insets ins = new Insets(0, 0, 0, 0);
            if (corner != null) {
                ins = corner.maskInsets(ins, this.borderSize);
            }
            int h = height - Math.max(0, this.getShadowSize(left) - this.borderSize);
            g2.translate(-3 * this.borderSize + 1, -ins.top);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, h + ins.top + ins.bottom, this.getFocusArc(left), this.borderSize);
            g2.translate(-(-3 * this.borderSize + 1), ins.bottom);
        }
        if (paintRight = DarkUIUtil.hasFocus(right = ButtonConstants.getNeighbour("JButton.rightNeighbour", c))) {
            AlignmentExt corner = DarkButtonBorder.getCornerFlag(right);
            Insets ins = new Insets(0, 0, 0, 0);
            if (corner != null) {
                ins = corner.maskInsets(ins, this.borderSize);
            }
            int h = height - Math.max(0, this.getShadowSize(right) - this.borderSize);
            g2.translate(width - this.borderSize - 1, -ins.top);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, h + ins.top + ins.bottom, this.getFocusArc(right), this.borderSize);
            g2.translate(-(width - this.borderSize - 1), ins.top);
        }
        if (paintTop = DarkUIUtil.hasFocus(top = ButtonConstants.getNeighbour("JButton.topNeighbour", c))) {
            AlignmentExt corner = DarkButtonBorder.getCornerFlag(top);
            Insets ins = new Insets(0, 0, 0, 0);
            if (corner != null) {
                ins = corner.maskInsets(ins, this.borderSize);
            }
            g2.translate(-ins.left, -3 * this.borderSize + 1);
            PaintUtil.paintFocusBorder(g2, width + ins.right + ins.left, 4 * this.borderSize, this.getFocusArc(top), this.borderSize);
            g2.translate(ins.left, -(-3 * this.borderSize + 1));
        }
        if (paintTopLeft = DarkUIUtil.hasFocus(topLeft = ButtonConstants.getNeighbour("JButton.topLeftNeighbour", c))) {
            g2.translate(-3 * this.borderSize + 1, -3 * this.borderSize + 1);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, 4 * this.borderSize, this.getFocusArc(topLeft), this.borderSize);
            g2.translate(-(-3 * this.borderSize + 1), -(-3 * this.borderSize + 1));
        }
        if (paintTopRight = DarkUIUtil.hasFocus(topRight = ButtonConstants.getNeighbour("JButton.topRightNeighbour", c))) {
            g2.translate(width - this.borderSize - 1, -3 * this.borderSize + 1);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, 4 * this.borderSize, this.getFocusArc(topRight), this.borderSize);
            g2.translate(-(width - this.borderSize - 1), -(-3 * this.borderSize + 1));
        }
        if (paintBottom = DarkUIUtil.hasFocus(bottom = ButtonConstants.getNeighbour("JButton.bottomNeighbour", c))) {
            AlignmentExt corner = DarkButtonBorder.getCornerFlag(bottom);
            Insets ins = new Insets(0, 0, 0, 0);
            if (corner != null) {
                ins = corner.maskInsets(ins, this.borderSize);
            }
            g2.translate(-ins.left, height - this.borderSize - 1);
            PaintUtil.paintFocusBorder(g2, width + ins.left + ins.right, 4 * this.borderSize, this.getFocusArc(bottom), this.borderSize);
            g2.translate(ins.left, -(height - this.borderSize - 1));
        }
        if (paintBottomLeft = DarkUIUtil.hasFocus(bottomLeft = ButtonConstants.getNeighbour("JButton.bottomLeftNeighbour", c))) {
            g2.translate(-3 * this.borderSize + 1, height - this.borderSize - 1);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, 4 * this.borderSize, this.getFocusArc(bottomLeft), this.borderSize);
            g2.translate(-(-3 * this.borderSize + 1), -(height - this.borderSize - 1));
        }
        if (paintBottomRight = DarkUIUtil.hasFocus(bottomRight = ButtonConstants.getNeighbour("JButton.bottomRightNeighbour", c))) {
            g2.translate(width - this.borderSize - 1, height - this.borderSize - 1);
            PaintUtil.paintFocusBorder(g2, 4 * this.borderSize, 4 * this.borderSize, this.getFocusArc(bottomRight), this.borderSize);
            g2.translate(-(width - this.borderSize - 1), -(height - this.borderSize - 1));
        }
    }

    protected boolean paintFocus(Component c) {
        if (c instanceof AbstractButton) {
            return ((AbstractButton)c).isFocusPainted() && c.hasFocus();
        }
        return c.hasFocus();
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected Color getBorderColor(Component c, boolean focus) {
        if (focus) {
            return this.focusBorderColor;
        }
        if (c instanceof JComponent && ButtonConstants.isDefaultButton((JComponent)c) && c.isEnabled()) {
            return this.defaultBorderColor;
        }
        if (c.isEnabled()) {
            return this.borderColor;
        }
        return this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (ButtonConstants.isBorderlessVariant(c)) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        boolean shadowVariant = ButtonConstants.isBorderless(c);
        int shadow = shadowVariant ? 0 : this.getShadowSize();
        return this.maskInsets(new InsetsUIResource(this.borderSize, this.borderSize, Math.max(this.borderSize, shadow), this.borderSize), c, shadow);
    }

    protected Insets maskInsets(Insets ins, Component c, int shadow) {
        AlignmentExt alignment = DarkButtonBorder.getCornerFlag(c);
        if (alignment == null) {
            return ins;
        }
        Insets insetMask = new Insets(this.borderSize, this.borderSize, Math.max(this.borderSize, shadow), this.borderSize);
        insetMask = alignment.maskInsetsInverted(insetMask);
        ins.top -= insetMask.top;
        ins.bottom -= insetMask.bottom;
        ins.left -= insetMask.left;
        ins.right -= insetMask.right;
        return ins;
    }
}

