/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.settings;

import com.github.weisj.darklaf.LafManager;
import com.github.weisj.darklaf.components.DefaultButton;
import com.github.weisj.darklaf.icons.IconLoader;
import com.github.weisj.darklaf.settings.DefaultSettingsConfiguration;
import com.github.weisj.darklaf.settings.SettingsConfiguration;
import com.github.weisj.darklaf.settings.ThemeSettingsPanel;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.event.ThemePreferenceChangeEvent;
import com.github.weisj.darklaf.theme.event.ThemePreferenceListener;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.theme.info.FontSizeRule;
import com.github.weisj.darklaf.theme.info.PreferredThemeStyle;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.Locale;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ThemeSettings
implements ThemePreferenceListener {
    private static final Logger LOGGER = LogUtil.getLogger(ThemeSettings.class);
    private static final LazyValue<ThemeSettings> instance = new LazyValue(ThemeSettings::new);
    private static final LazyValue<Icon> icon = new LazyValue(() -> UIManager.getIcon("ThemeSettings.icon"));
    private final LazyValue<ThemeSettingsPanel> settingsPanel;
    private JDialog dialog;
    private final SettingsConfiguration savedConfiguration;
    private final SettingsConfiguration currentConfiguration;

    public static ThemeSettings getInstance() {
        return (ThemeSettings)instance.get();
    }

    public static boolean isInitialized() {
        return instance.isInitialized();
    }

    public static void showSettingsDialog(Component parent) {
        ThemeSettings.showSettingsDialog(parent, Dialog.ModalityType.MODELESS);
    }

    public static void showSettingsDialog(Component parent, Dialog.ModalityType modalityType) {
        ThemeSettings.getInstance().showDialog(parent, modalityType);
    }

    protected ThemeSettings() {
        LafManager.addThemePreferenceChangeListener(this);
        this.currentConfiguration = new DefaultSettingsConfiguration();
        this.savedConfiguration = new DefaultSettingsConfiguration();
        this.settingsPanel = new LazyValue(() -> {
            ThemeSettingsPanel panel = new ThemeSettingsPanel();
            panel.loadConfiguration(this.currentConfiguration);
            return panel;
        });
    }

    protected JDialog createDialog(Window parent) {
        JDialog dialog = new JDialog(parent);
        dialog.setIconImage(IconLoader.createFrameIcon((Icon)ThemeSettings.getIcon(), (Window)dialog));
        dialog.setTitle(this.getTitle());
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add((Component)this.settingsPanel.get(), "Center");
        contentPane.add(this.createButtonPanel(), "South");
        dialog.setContentPane(contentPane);
        dialog.setDefaultCloseOperation(2);
        dialog.pack();
        dialog.setLocationByPlatform(true);
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    public void showDialog(Component parent, Dialog.ModalityType modal) {
        Window parentWindow = DarkUIUtil.getWindow(this.getSettingsPanel());
        if (parentWindow != null && parentWindow != DarkUIUtil.getWindow(this.dialog)) {
            throw new IllegalStateException("Can't show dialog while settings panel is used elsewhere");
        }
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.requestFocusInWindow();
            return;
        }
        this.refresh();
        Window window = DarkUIUtil.getWindow(parent);
        this.dialog = this.createDialog(window);
        this.dialog.setModalityType(modal);
        this.dialog.setVisible(true);
    }

    public JComponent getSettingsPanel() {
        return (JComponent)this.settingsPanel.get();
    }

    public boolean isSystemPreferencesEnabled() {
        return this.currentConfiguration.isSystemPreferencesEnabled();
    }

    public boolean isAccentColorFollowsSystem() {
        return this.currentConfiguration.isAccentColorFollowsSystem();
    }

    public boolean isFontSizeFollowsSystem() {
        return this.currentConfiguration.isFontSizeFollowsSystem();
    }

    public boolean isSelectionColorFollowsSystem() {
        return this.currentConfiguration.isSelectionColorFollowsSystem();
    }

    public boolean isThemeFollowsSystem() {
        return this.currentConfiguration.isThemeFollowsSystem();
    }

    public AccentColorRule getAccentColorRule() {
        return this.currentConfiguration.getAccentColorRule();
    }

    public FontSizeRule getFontSizeRule() {
        return this.currentConfiguration.getFontSizeRule();
    }

    public Theme getTheme() {
        return this.currentConfiguration.getTheme();
    }

    public void setSystemPreferencesEnabled(boolean enabled) {
        if (this.isSystemPreferencesEnabled() != enabled) {
            LOGGER.info("Setting systemPreferencesEnabled = " + enabled);
            this.currentConfiguration.setSystemPreferencesEnabled(enabled);
            this.updateSettingsPanel();
        }
    }

    public void setAccentColorFollowsSystem(boolean accentColorFollowsSystem) {
        if (this.isAccentColorFollowsSystem() != accentColorFollowsSystem) {
            LOGGER.info("Setting accentColorFollowsSystem = " + accentColorFollowsSystem);
            this.currentConfiguration.setAccentColorFollowsSystem(accentColorFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setFontSizeFollowsSystem(boolean fontSizeFollowsSystem) {
        if (this.isFontSizeFollowsSystem() != fontSizeFollowsSystem) {
            LOGGER.info("Setting fontSizeFollowsSystem = " + fontSizeFollowsSystem);
            this.currentConfiguration.setFontSizeFollowsSystem(fontSizeFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setSelectionColorFollowsSystem(boolean selectionColorFollowsSystem) {
        if (this.isSelectionColorFollowsSystem() != selectionColorFollowsSystem) {
            LOGGER.info("Setting selectionColorFollowsSystem = " + selectionColorFollowsSystem);
            this.currentConfiguration.setSelectionColorFollowsSystem(selectionColorFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setThemeFollowsSystem(boolean themeFollowsSystem) {
        if (this.isThemeFollowsSystem() != themeFollowsSystem) {
            LOGGER.info("Setting themeFollowsSystem = " + themeFollowsSystem);
            this.currentConfiguration.setThemeFollowsSystem(themeFollowsSystem);
            this.updateSettingsPanel();
        }
    }

    public void setAccentColorRule(AccentColorRule accentColorRule) {
        if (!Objects.equals(this.getAccentColorRule(), accentColorRule)) {
            LOGGER.info("Setting accentColorRule = " + accentColorRule);
            this.currentConfiguration.setAccentColorRule(accentColorRule);
            this.updateSettingsPanel();
        }
    }

    public void setFontSizeRule(FontSizeRule fontSizeRule) {
        if (!Objects.equals(this.getFontSizeRule(), fontSizeRule)) {
            LOGGER.info("Setting fontSizeRule = " + fontSizeRule);
            this.currentConfiguration.setFontSizeRule(fontSizeRule);
            this.updateSettingsPanel();
        }
    }

    public void setTheme(Theme theme) {
        if (!Objects.equals(this.getTheme(), theme)) {
            LOGGER.info("Setting theme = " + theme);
            this.currentConfiguration.setTheme(theme);
            this.updateSettingsPanel();
        }
    }

    protected Component createButtonPanel() {
        Locale l = Locale.getDefault();
        DefaultButton ok = new DefaultButton(UIManager.getString((Object)"dialog_ok", l));
        ok.setDefaultCapable(true);
        ok.addActionListener(e -> {
            this.apply();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton cancel = new JButton(UIManager.getString((Object)"dialog_cancel", l));
        cancel.addActionListener(e -> {
            this.revert();
            this.dialog.dispatchEvent(new WindowEvent(this.dialog, 201));
        });
        JButton apply = new JButton(UIManager.getString((Object)"dialog_apply", l));
        apply.addActionListener(e -> this.apply());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(ok);
        box.add(cancel);
        box.add(apply);
        box.setBorder(((ThemeSettingsPanel)this.settingsPanel.get()).getBorder());
        return box;
    }

    public void refresh() {
        Theme theme = LafManager.getTheme();
        this.currentConfiguration.setTheme(theme);
        this.currentConfiguration.setFontSizeRule(theme.getFontSizeRule());
        this.currentConfiguration.setAccentColorRule(theme.getAccentColorRule());
        this.currentConfiguration.setSystemPreferencesEnabled(LafManager.isPreferenceChangeReportingEnabled());
        this.updateSettingsPanel();
    }

    private void updateSettingsPanel() {
        this.settingsPanel.ifPresent(p -> p.loadConfiguration(this.currentConfiguration));
    }

    private void fetchFromSettingsPanel() {
        this.settingsPanel.ifPresent(ThemeSettingsPanel::updateConfiguration);
    }

    public void save() {
        this.fetchFromSettingsPanel();
        LafManager.enabledPreferenceChangeReporting(this.currentConfiguration.isSystemPreferencesEnabled());
        this.savedConfiguration.load(this.currentConfiguration);
        LOGGER.fine(() -> "Saving settings " + this.savedConfiguration);
    }

    public void setConfiguration(SettingsConfiguration configuration) {
        this.currentConfiguration.load(configuration);
    }

    public void apply() {
        this.save();
        this.peek();
    }

    public void peek() {
        this.applyTheme(this.getEffectiveTheme());
    }

    private Theme getEffectiveTheme() {
        return this.getEffectiveTheme(LafManager.getPreferredThemeStyle());
    }

    private Theme getEffectiveTheme(PreferredThemeStyle themeStyle) {
        Theme baseTheme = this.getEffectiveBaseTheme(themeStyle);
        if (baseTheme == null) {
            return null;
        }
        FontSizeRule fontSizeRule = this.getEffectiveFontSizeRule(baseTheme, themeStyle);
        AccentColorRule accentColorRule = this.getEffectiveAccentColorRule(baseTheme);
        return baseTheme.derive(fontSizeRule, accentColorRule);
    }

    private Theme getEffectiveBaseTheme(PreferredThemeStyle preferredThemeStyle) {
        return this.isThemeFollowsSystem() ? LafManager.themeForPreferredStyle(preferredThemeStyle) : this.getTheme();
    }

    private FontSizeRule getEffectiveFontSizeRule(Theme theme, PreferredThemeStyle preferredThemeStyle) {
        if (theme == null) {
            return FontSizeRule.getDefault();
        }
        return this.isFontSizeFollowsSystem() ? preferredThemeStyle.getFontSizeRule() : this.getFontSizeRule();
    }

    private AccentColorRule getEffectiveAccentColorRule(Theme theme) {
        if (theme == null) {
            return AccentColorRule.getDefault();
        }
        return this.currentConfiguration.getAccentColorRule();
    }

    public void revert() {
        this.currentConfiguration.load(this.savedConfiguration);
        this.refresh();
    }

    protected void applyTheme(Theme theme) {
        if (theme == null) {
            return;
        }
        if (LafManager.getTheme().appearsEqualTo(theme)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            LafManager.installTheme(theme);
            this.refresh();
        });
    }

    public static Icon getIcon() {
        return (Icon)icon.get();
    }

    public String getTitle() {
        return UIManager.getString((Object)"title", Locale.getDefault());
    }

    public void themePreferenceChanged(ThemePreferenceChangeEvent e) {
        this.refresh();
        this.applyTheme(this.getEffectiveTheme(e.getPreferredThemeStyle()));
    }
}

