/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.tabframe;

import java.awt.Component;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class ToggleSplitPane
extends JSplitPane {
    private int disabledPos = 0;
    private int disabledMax = -1;
    private boolean resizable = true;
    private boolean lastEnabled = true;
    private double restorePercentage;
    private boolean isInLayout = false;
    private boolean enabled = true;

    public ToggleSplitPane() {
        this(null);
    }

    public ToggleSplitPane(String name) {
        this.setName(name);
        this.putClientProperty("JSplitPane.style", "invisible");
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (!resizable) {
            this.lastEnabled = this.isEnabled();
            this.setEnabled(false);
            this.disabledPos = super.getDividerLocation();
            this.disabledMax = this.getMaximumDividerLocation();
            this.getDivider().setEnabled(false);
            this.setComponentZOrder(this.getDivider(), this.getComponentCount() - 1);
        } else {
            this.setEnabled(this.lastEnabled);
            this.getDivider().setEnabled(this.lastEnabled);
            this.setComponentZOrder(this.getDivider(), 0);
        }
    }

    protected BasicSplitPaneDivider getDivider() {
        return ((BasicSplitPaneUI)this.getUI()).getDivider();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        ((BasicSplitPaneUI)this.getUI()).getDivider().setEnabled(enabled);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setEnabled(this.enabled);
        this.setResizable(this.resizable);
    }

    public void savePosition() {
        this.savePosition(this.getRelativeDividerLocation());
    }

    public void savePosition(double position) {
        this.restorePercentage = Math.max(0.0, Math.min(1.0, position));
    }

    public double getRelativeDividerLocation() {
        if (this.getOrientation() == 1) {
            return (double)this.getDividerLocation() / (double)this.getWidth();
        }
        return (double)this.getDividerLocation() / (double)this.getHeight();
    }

    public void restorePosition() {
        this.setDividerLocation(this.restorePercentage);
        this.doLayout();
    }

    public void forceSetDividerLocation(int location) {
        super.setDividerLocation(location);
    }

    public void forceSetDividerLocation(double proportionalLocation) {
        if (proportionalLocation < 0.0 || proportionalLocation > 1.0) {
            throw new IllegalArgumentException("proportional location must be between 0.0 and 1.0.");
        }
        if (this.getOrientation() == 0) {
            super.setDividerLocation((int)((double)this.getHeight() * proportionalLocation));
        } else {
            super.setDividerLocation((int)((double)this.getWidth() * proportionalLocation));
        }
    }

    @Override
    public int getLastDividerLocation() {
        if (this.resizable) {
            return super.getLastDividerLocation();
        }
        return this.disabledMax == this.disabledPos ? this.getMaximumDividerLocation() : this.disabledPos;
    }

    @Override
    public int getDividerLocation() {
        if (this.resizable) {
            return super.getDividerLocation();
        }
        return this.disabledMax == this.disabledPos ? this.getMaximumDividerLocation() : this.disabledPos;
    }

    @Override
    public void setDividerLocation(int location) {
        if (this.isInLayout) {
            return;
        }
        this.isInLayout = true;
        if (this.resizable) {
            super.setDividerLocation(location);
        } else if (this.disabledPos == this.disabledMax) {
            super.setDividerLocation(this.getMaximumDividerLocation());
            this.doLayout();
        } else if (this.disabledPos == 0) {
            super.setDividerLocation(0);
            this.doLayout();
        }
        this.isInLayout = false;
    }

    @Override
    public int getMaximumDividerLocation() {
        int max = this.getOrientation() == 1 ? this.getWidth() : this.getHeight();
        return Math.max(max, this.getMinimumDividerLocation());
    }

    @Override
    public int getMinimumDividerLocation() {
        Component comp = this.getRightComponent();
        return comp == null ? 0 : (this.getOrientation() == 1 ? comp.getMinimumSize().width : comp.getMinimumSize().height);
    }
}

