/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.ui.popupmenu.PopupMenuContainer;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.Popup;

public class ScrollPopupMenu
extends JPopupMenu {
    private final PopupMenuContainer popupMenuContainer = new PopupMenuContainer();
    private int maxHeight;
    private Popup popup;
    private int posX;
    private int posY;
    private boolean isVisible;

    public ScrollPopupMenu(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    protected void showPopup() {
        this.isVisible = true;
        this.popup = this.createPopup();
        this.popup.show();
    }

    public JScrollPane getScrollPane() {
        return this.popupMenuContainer.getScrollPane();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setLocation(int x, int y) {
        this.posX = x;
        this.posY = y;
    }

    @Override
    public void setVisible(boolean b) {
        if (b == this.isVisible()) {
            return;
        }
        if (b) {
            if (this.isPopupMenu()) {
                MenuElement[] menuElements = new MenuElement[1];
                if (this.getSubElements().length > 0) {
                    menuElements = new MenuElement[2];
                    menuElements[1] = this.getSubElements()[0];
                }
                menuElements[0] = this;
                MenuSelectionManager.defaultManager().setSelectedPath(menuElements);
            }
            this.firePopupMenuWillBecomeVisible();
            this.showPopup();
            this.firePropertyChange("visible", Boolean.FALSE, Boolean.TRUE);
        } else {
            this.hidePopup();
        }
    }

    protected void hidePopup() {
        if (this.popup != null) {
            this.firePopupMenuWillBecomeInvisible();
            this.popup.hide();
            this.isVisible = false;
            this.popup = null;
            this.firePropertyChange("visible", Boolean.TRUE, Boolean.FALSE);
            if (this.isPopupMenu()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private Popup createPopup() {
        return this.popupMenuContainer.createPopup(this, this.posX, this.posY, this.maxHeight);
    }

    @Override
    public void pack() {
    }

    private boolean isPopupMenu() {
        Component invoker = this.getInvoker();
        return invoker != null && !(invoker instanceof JMenu);
    }
}

