/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components;

import com.github.weisj.darklaf.delegate.ScrollLayoutManagerDelegate;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;

public class OverlayScrollPane
extends JLayeredPane
implements PropertyChangeListener {
    protected final JScrollPane scrollPane;
    private final ControlPanel controlPanel;

    public OverlayScrollPane() {
        this(null);
    }

    public OverlayScrollPane(JComponent view) {
        this(view, 20, 30);
    }

    public OverlayScrollPane(JComponent view, int vsbPolicy, int hsbPolicy) {
        this.scrollPane = this.createScrollPane(view, vsbPolicy, hsbPolicy);
        this.setupScrollPane(this.scrollPane);
        this.setViewportView(view);
        this.add((Component)this.scrollPane, JLayeredPane.DEFAULT_LAYER);
        this.controlPanel = new ControlPanel(this.scrollPane);
        this.add((Component)this.controlPanel, JLayeredPane.PALETTE_LAYER);
    }

    public OverlayScrollPane(JScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        this.setupScrollPane(scrollPane);
        this.add((Component)scrollPane, JLayeredPane.DEFAULT_LAYER);
        this.controlPanel = new ControlPanel(scrollPane);
        this.add((Component)this.controlPanel, JLayeredPane.PALETTE_LAYER);
    }

    protected JScrollPane createScrollPane(JComponent view, int vsbPolicy, int hsbPolicy) {
        return new JScrollPane(view, vsbPolicy, hsbPolicy);
    }

    protected void setupScrollPane(JScrollPane scrollPane) {
        PopupScrollBar verticalScrollBar = this.createScrollBar(1);
        verticalScrollBar.putClientProperty("JScrollBar.scrollPaneParent", scrollPane);
        PopupScrollBar horizontalScrollBar = this.createScrollBar(0);
        horizontalScrollBar.putClientProperty("JScrollBar.scrollPaneParent", scrollPane);
        scrollPane.addPropertyChangeListener(this);
        this.updateScrollPaneUI();
        scrollPane.setVerticalScrollBar(verticalScrollBar);
        scrollPane.setHorizontalScrollBar(horizontalScrollBar);
        scrollPane.setColumnHeader(scrollPane.getColumnHeader());
        scrollPane.setRowHeader(scrollPane.getRowHeader());
    }

    protected PopupScrollBar createScrollBar(int orientation) {
        return new PopupScrollBar(orientation);
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    @Override
    public void doLayout() {
        this.scrollPane.setSize(this.getSize());
        this.controlPanel.setSize(this.getSize());
        this.scrollPane.doLayout();
    }

    public void setVerticalScrollBarPolicy(int policy) {
        this.scrollPane.setVerticalScrollBarPolicy(policy);
        this.controlPanel.showVerticalScrollBar(policy != 21);
    }

    public void setHorizontalScrollBarPolicy(int policy) {
        this.scrollPane.setHorizontalScrollBarPolicy(policy);
        this.controlPanel.showHorizontalScrollBar(policy != 31);
    }

    public JScrollBar getVerticalScrollBar() {
        return this.scrollPane.getVerticalScrollBar();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.scrollPane.getPreferredSize();
    }

    public JScrollBar getHorizontalScrollBar() {
        return this.scrollPane.getHorizontalScrollBar();
    }

    public void setViewportView(Component c) {
        this.scrollPane.setViewportView(c);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String key = evt.getPropertyName();
        if ("UI".equals(key)) {
            this.updateScrollPaneUI();
        }
    }

    protected void updateScrollPaneUI() {
        if (this.scrollPane == null) {
            return;
        }
        this.scrollPane.setLayout(new ScrollLayoutManagerDelegate((ScrollPaneLayout)this.scrollPane.getLayout()){

            @Override
            public void removeLayoutComponent(Component comp) {
                if (comp == OverlayScrollPane.this.scrollPane.getVerticalScrollBar() || comp == OverlayScrollPane.this.scrollPane.getHorizontalScrollBar()) {
                    return;
                }
                super.removeLayoutComponent(comp);
            }

            @Override
            public void layoutContainer(Container parent) {
                super.layoutContainer(parent);
                this.viewport = this.getViewport();
                JScrollBar verticalScrollBar = OverlayScrollPane.this.scrollPane.getVerticalScrollBar();
                JScrollBar horizontalScrollBar = OverlayScrollPane.this.scrollPane.getHorizontalScrollBar();
                if (this.viewport != null) {
                    Rectangle bounds = this.viewport.getBounds();
                    Rectangle vertBounds = verticalScrollBar.getBounds();
                    Rectangle horBounds = horizontalScrollBar.getBounds();
                    JViewport columnHeader = this.getColumnHeader();
                    JViewport rowHeader = this.getRowHeader();
                    if (OverlayScrollPane.this.getComponentOrientation().isLeftToRight()) {
                        if (verticalScrollBar.isVisible()) {
                            bounds.width += vertBounds.width;
                        }
                        if (columnHeader != null && verticalScrollBar.isVisible()) {
                            Rectangle chb = columnHeader.getBounds();
                            chb.width += vertBounds.width;
                            columnHeader.setBounds(chb);
                        }
                        if (rowHeader != null && horizontalScrollBar.isVisible()) {
                            Rectangle rhb = rowHeader.getBounds();
                            rhb.height += horBounds.height;
                            rowHeader.setBounds(rhb);
                        }
                    } else {
                        if (verticalScrollBar.isVisible()) {
                            bounds.x -= vertBounds.width;
                            bounds.width += vertBounds.width;
                        }
                        if (columnHeader != null && verticalScrollBar.isVisible()) {
                            Rectangle chb = columnHeader.getBounds();
                            chb.x -= vertBounds.width;
                            chb.width += vertBounds.width;
                            columnHeader.setBounds(chb);
                        }
                        if (rowHeader != null && horizontalScrollBar.isVisible()) {
                            Rectangle rhb = rowHeader.getBounds();
                            rhb.height += horBounds.height;
                            rowHeader.setBounds(rhb);
                        }
                    }
                    if (horizontalScrollBar.isVisible()) {
                        bounds.height += horBounds.height;
                    }
                    this.viewport.setBounds(bounds);
                }
            }
        });
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        super.setPreferredSize(preferredSize);
        this.scrollPane.setPreferredSize(preferredSize);
    }

    private static final class ControlPanel
    extends JPanel {
        private boolean showVertical;
        private boolean showHorizontal;
        private final JScrollPane scrollPane;

        private ControlPanel(JScrollPane scrollPane) {
            this.scrollPane = scrollPane;
            this.setLayout(null);
            scrollPane.setVerticalScrollBar(scrollPane.getVerticalScrollBar());
            if (scrollPane.getVerticalScrollBarPolicy() != 21) {
                this.showVertical = true;
                this.add(scrollPane.getVerticalScrollBar());
            }
            scrollPane.setHorizontalScrollBar(scrollPane.getHorizontalScrollBar());
            if (scrollPane.getHorizontalScrollBarPolicy() != 31) {
                this.showHorizontal = true;
                this.add(scrollPane.getHorizontalScrollBar());
            }
        }

        private void showVerticalScrollBar(boolean show) {
            if (show == this.showVertical) {
                return;
            }
            this.showVertical = show;
            this.scrollPane.getVerticalScrollBar().setVisible(show);
        }

        private void showHorizontalScrollBar(boolean show) {
            if (show == this.showHorizontal) {
                return;
            }
            this.showHorizontal = show;
            this.scrollPane.getHorizontalScrollBar().setVisible(show);
        }

        @Override
        public boolean contains(int x, int y) {
            if (this.scrollPane.getHorizontalScrollBar().isVisible() && this.scrollPane.getHorizontalScrollBar().getBounds().contains(x, y)) {
                return true;
            }
            return this.scrollPane.getVerticalScrollBar().isVisible() && this.scrollPane.getVerticalScrollBar().getBounds().contains(x, y);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    protected static final class PopupScrollBar
    extends JScrollBar {
        private PopupScrollBar(int direction) {
            super(direction);
            this.putClientProperty("JScrollBar.fastWheelScrolling", true);
            this.setOpaque(false);
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }
}

