/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.bolt.sampler;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.util.ConfigMergabilityIndicator;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.protocol.bolt.config.BoltConnectionElement;
import org.apache.jmeter.protocol.bolt.sampler.AbstractBoltTestElement;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testbeans.TestBean;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.summary.ResultSummary;

@TestElementMetadata(labelResource="displayName")
public class BoltSampler
extends AbstractBoltTestElement
implements Sampler,
TestBean,
ConfigMergabilityIndicator {
    private static final Set<String> APPLICABLE_CONFIG_CLASSES = new HashSet<String>(Collections.singletonList("org.apache.jmeter.config.gui.SimpleConfigGui"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SampleResult sample(Entry e) {
        Map<String, Object> params;
        SampleResult res = new SampleResult();
        res.setSampleLabel(this.getName());
        res.setSamplerData(this.request());
        res.setDataType("text");
        res.setContentType("text/plain");
        res.setDataEncoding(StandardCharsets.UTF_8.name());
        try {
            params = this.getParamsAsMap();
        }
        catch (IOException ex) {
            return this.handleException(res, ex);
        }
        res.setSuccessful(true);
        res.setResponseMessageOK();
        res.setResponseCodeOK();
        res.sampleStart();
        try {
            res.setResponseHeaders("Cypher request: " + this.getCypher());
            res.setResponseData(this.execute(BoltConnectionElement.getDriver(), this.getCypher(), params), StandardCharsets.UTF_8.name());
        }
        catch (Exception ex) {
            res = this.handleException(res, ex);
        }
        finally {
            res.sampleEnd();
        }
        return res;
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLICABLE_CONFIG_CLASSES.contains(guiClass);
    }

    private String execute(Driver driver, String cypher, Map<String, Object> params) {
        try (Session session = driver.session();){
            Result statementResult = session.run(cypher, params);
            String string = this.response(statementResult);
            return string;
        }
    }

    private SampleResult handleException(SampleResult res, Exception ex) {
        res.setResponseMessage(ex.toString());
        if (ex instanceof Neo4jException) {
            res.setResponseCode(((Neo4jException)ex).code());
        } else {
            res.setResponseCode("500");
        }
        res.setResponseData((String)ObjectUtils.defaultIfNull((Object)ex.getMessage(), (Object)"NO MESSAGE"), res.getDataEncodingNoDefault());
        res.setSuccessful(false);
        return res;
    }

    private Map<String, Object> getParamsAsMap() throws IOException {
        if (this.getParams() != null && this.getParams().length() > 0) {
            return (Map)Holder.OBJECT_READER.readValue(this.getParams());
        }
        return Collections.emptyMap();
    }

    private String request() {
        StringBuilder request = new StringBuilder();
        request.append("Query: \n").append(this.getCypher()).append("\n").append("Parameters: \n").append(this.getParams());
        return request.toString();
    }

    private String response(Result result) {
        StringBuilder response = new StringBuilder();
        response.append("\nSummary:");
        ResultSummary summary = result.consume();
        response.append("\nConstraints Added: ").append(summary.counters().constraintsAdded()).append("\nConstraints Removed: ").append(summary.counters().constraintsRemoved()).append("\nContains Updates: ").append(summary.counters().containsUpdates()).append("\nIndexes Added: ").append(summary.counters().indexesAdded()).append("\nIndexes Removed: ").append(summary.counters().indexesRemoved()).append("\nLabels Added: ").append(summary.counters().labelsAdded()).append("\nLabels Removed: ").append(summary.counters().labelsRemoved()).append("\nNodes Created: ").append(summary.counters().nodesCreated()).append("\nNodes Deleted: ").append(summary.counters().nodesDeleted()).append("\nRelationships Created: ").append(summary.counters().relationshipsCreated()).append("\nRelationships Deleted: ").append(summary.counters().relationshipsDeleted());
        response.append("\n\nRecords: ");
        if (this.isRecordQueryResults()) {
            for (Record record : result.list()) {
                response.append("\n").append(record);
            }
        } else {
            response.append("Skipped");
            result.consume();
        }
        return response.toString();
    }

    private static class Holder {
        private static final ObjectReader OBJECT_READER = new ObjectMapper().readerFor((TypeReference)new TypeReference<HashMap<String, Object>>(){});

        private Holder() {
        }
    }
}

