/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.DynamicIcon;
import com.github.weisj.darklaf.icons.ImageSource;
import com.github.weisj.darklaf.util.ImageUtil;
import com.github.weisj.darklaf.util.Scale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class IconUtil {
    private static final int FRAME_ICON_SIZE = 32;
    private static final Map<Window, Icon> windowIconSet = new WeakHashMap<Window, Icon>();

    public static void reloadDynamicFrameIcons() {
        SwingUtilities.invokeLater(() -> windowIconSet.forEach((window, icon) -> window.setIconImage(IconUtil.iconToImage(icon, window))));
    }

    static int getDynamicFrameIconCount() {
        return windowIconSet.size();
    }

    public static Image createFrameIcon(Icon icon, Window c) {
        if (icon == null) {
            return null;
        }
        if (c != null) {
            if (IconUtil.isDynamic(icon)) {
                windowIconSet.put(c, icon);
            }
            PropertyChangeListener propertyChangeListener = e -> c.setIconImage(IconUtil.iconToImage(icon, c));
            c.addPropertyChangeListener("graphicsConfiguration", propertyChangeListener);
        }
        return IconUtil.createScaledFrameIcon(icon, c);
    }

    private static boolean isDynamic(Icon icon) {
        return icon instanceof DynamicIcon;
    }

    private static Image createScaledFrameIcon(Icon icon, Window c) {
        Container parent;
        if (c != null && !c.isVisible() && (parent = c.getParent()) != null) {
            return IconUtil.iconToImage(icon, c);
        }
        return IconUtil.iconToImage(icon, c);
    }

    public static Image iconToImage(Icon icon, Component c) {
        if (icon == null) {
            return null;
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsConfiguration gc = c.getGraphicsConfiguration();
        double sx = Scale.getScaleX((GraphicsConfiguration)gc);
        double sy = Scale.getScaleY((GraphicsConfiguration)gc);
        double scaleX = sx * (32.0 / (double)w);
        double scaleY = sy * (32.0 / (double)h);
        return IconUtil.createScaledImage(icon, scaleX, scaleY);
    }

    public static Image createScaledImage(Icon icon, double scalex, double scaley) {
        if (icon == null) {
            return null;
        }
        int w = (int)(scalex * (double)icon.getIconWidth());
        int h = (int)(scaley * (double)icon.getIconHeight());
        if (icon instanceof ImageSource) {
            return ((ImageSource)((Object)icon)).createImage(w, h);
        }
        BufferedImage image = ImageUtil.createCompatibleTransparentImage((int)w, (int)h);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.scale(scalex, scaley);
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }
}

