/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.AwareIconStyle;
import com.github.weisj.darklaf.icons.CustomThemedIcon;
import com.github.weisj.darklaf.icons.DarkSVGIcon;
import com.github.weisj.darklaf.icons.DarkUIAwareIcon;
import com.github.weisj.darklaf.icons.DerivableIcon;
import com.github.weisj.darklaf.icons.DerivableImageIcon;
import com.github.weisj.darklaf.icons.IconUtil;
import com.github.weisj.darklaf.icons.LazyImageIconSupplier;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.github.weisj.darklaf.util.LazyValue;
import com.github.weisj.darklaf.util.LogUtil;
import java.awt.Image;
import java.awt.Window;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class IconLoader {
    private static final Logger LOGGER = LogUtil.getLogger(IconLoader.class);
    private static final Map<Class<?>, IconLoader> iconLoaderMap = new HashMap();
    private static final LazyValue<IconLoader> instance = new LazyValue(() -> IconLoader.get(null));
    private static final AtomicReference<Object> currentThemeKey = new AtomicReference<Object>(null);
    private static final AtomicReference<AwareIconStyle> currentAwareStyle = new AtomicReference<Object>(null);
    private static final int DEFAULT_W = 16;
    private static final int DEFAULT_H = 16;
    private final Class<?> parentClass;
    private boolean cacheEnabled = true;
    private final Map<IconKey, DarkUIAwareIcon> awareIconMap = new HashMap<IconKey, DarkUIAwareIcon>();
    private final Map<IconKey, Icon> iconMap = new HashMap<IconKey, Icon>();

    private IconLoader(Class<?> parentClass) {
        this.parentClass = parentClass;
        iconLoaderMap.put(parentClass, this);
    }

    public static IconLoader get() {
        return (IconLoader)instance.get();
    }

    public static IconLoader get(Class<?> parentClass) {
        if (iconLoaderMap.containsKey(parentClass)) {
            return iconLoaderMap.get(parentClass);
        }
        IconLoader loader = new IconLoader(parentClass);
        iconLoaderMap.put(parentClass, loader);
        return loader;
    }

    public void setCacheEnabled(boolean cacheEnabled) {
        this.cacheEnabled = cacheEnabled;
    }

    public boolean isCacheEnabled() {
        return this.cacheEnabled;
    }

    public static void updateAwareStyle(AwareIconStyle style) {
        currentAwareStyle.set(style);
    }

    public static void updateThemeStatus(Object theme) {
        currentThemeKey.set(theme);
    }

    public static void reloadFrameIcons() {
        IconUtil.reloadDynamicFrameIcons();
    }

    public static AwareIconStyle getAwareStyle() {
        return currentAwareStyle.get();
    }

    public static Object getThemeStatus() {
        return currentThemeKey.get();
    }

    public DarkUIAwareIcon getUIAwareIcon(String path) {
        return this.getUIAwareIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path));
    }

    public DarkUIAwareIcon getUIAwareIcon(String path, int w, int h) {
        IconKey key = new IconKey(path, w, h);
        if (this.isCacheEnabled() && this.awareIconMap.containsKey(key)) {
            return this.awareIconMap.get(key);
        }
        DarkUIAwareIcon icon = this.createUIAwareIcon(path, w, h);
        this.cache(this.awareIconMap, key, icon);
        return icon;
    }

    protected DarkUIAwareIcon createUIAwareIcon(String name, int w, int h) {
        return new DarkUIAwareIcon("dark/" + name, "light/" + name, w, h, this.parentClass);
    }

    public Icon getIcon(String path) {
        return this.getIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path));
    }

    public Icon getIcon(String path, boolean themed) {
        return this.getIcon(path, this.getDefaultWidth(path), this.getDefaultHeight(path), themed);
    }

    public Icon getIcon(String path, int w, int h) {
        return this.getIcon(path, w, h, false);
    }

    public Icon getIcon(String path, int w, int h, boolean themed) {
        Icon icon;
        IconKey key = new IconKey(path, w, h);
        if (this.isCacheEnabled()) {
            if (this.iconMap.containsKey(key)) {
                return this.iconMap.get(key);
            }
            if (this.awareIconMap.containsKey(key)) {
                return this.awareIconMap.get(key);
            }
            icon = this.getWildcardIcon(this.iconMap, key, w, h);
            if (icon != null) {
                return icon;
            }
        }
        if (this.isSVGIcon(path)) {
            icon = this.loadSVGIcon(path, w, h, themed);
            this.cache(this.iconMap, key, icon);
            return icon;
        }
        icon = new DerivableImageIcon(new LazyImageIconSupplier(path, key, this.parentClass), w, h);
        this.cache(this.iconMap, key, icon);
        return icon;
    }

    private Icon getWildcardIcon(Map<IconKey, Icon> iconMap, IconKey iconKey, int w, int h) {
        iconKey.isWildcardEnabled = true;
        Icon icon = iconMap.get(iconKey);
        if (icon instanceof DerivableIcon) {
            Object derived = ((DerivableIcon)icon).derive(w, h);
            iconKey.isWildcardEnabled = false;
            this.cache((Map)iconMap, iconKey, derived);
            return derived;
        }
        iconKey.isWildcardEnabled = false;
        return null;
    }

    private <T extends Icon> void cache(Map<IconKey, T> iconMap, IconKey key, T icon) {
        if (this.cacheEnabled) {
            iconMap.put(key, icon);
        }
    }

    public Icon loadSVGIcon(String path, boolean themed) {
        return this.loadSVGIcon(path, 16, 16, themed);
    }

    public Icon loadSVGIcon(String path, int w, int h, boolean themed) {
        return this.loadSVGIcon(path, w, h, themed, null);
    }

    public Icon loadSVGIcon(String path, int w, int h, boolean themed, Map<Object, Object> propertyMap) {
        Supplier<URI> uriSupplier = this.createURISupplier(path);
        if (themed) {
            if (propertyMap != null) {
                return new CustomThemedIcon(uriSupplier, w, h, propertyMap);
            }
            return new ThemedSVGIcon(uriSupplier, w, h);
        }
        return new DarkSVGIcon(this.createURISupplier(path), w, h);
    }

    private Supplier<URI> createURISupplier(String path) {
        return () -> {
            try {
                return Objects.requireNonNull(this.getResource(path).toURI());
            }
            catch (NullPointerException | URISyntaxException e) {
                LOGGER.log(Level.SEVERE, "Exception while loading '" + path + "'. Resolving from " + this.parentClass, e.getStackTrace());
                return null;
            }
        };
    }

    ImageIcon createImageIcon(String path, String description) {
        URL imgURL = this.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        LOGGER.severe("Could not find icon file: '" + path + "'");
        return null;
    }

    public static Image createFrameIcon(Icon icon, Window window) {
        return IconUtil.createFrameIcon(icon, window);
    }

    protected URL getResource(String name) {
        if (this.parentClass != null) {
            return this.parentClass.getResource(name);
        }
        return this.getClass().getClassLoader().getResource(name);
    }

    private int getDefaultWidth(String path) {
        if (!this.isSVGIcon(path)) {
            return -1;
        }
        return 16;
    }

    private int getDefaultHeight(String path) {
        if (!this.isSVGIcon(path)) {
            return -1;
        }
        return 16;
    }

    private boolean isSVGIcon(String path) {
        return path != null && path.endsWith(".svg");
    }

    protected static final class IconKey {
        final String path;
        int w;
        int h;
        boolean isWildcardEnabled;

        private IconKey(String path, int w, int h) {
            this.path = path;
            this.w = w;
            this.h = h;
        }

        public int hashCode() {
            return Objects.hash(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IconKey iconKey = (IconKey)o;
            if (iconKey.isWildcardEnabled || this.isWildcardEnabled) {
                return Objects.equals(this.path, iconKey.path);
            }
            if (this.w != iconKey.w) {
                return false;
            }
            if (this.h != iconKey.h) {
                return false;
            }
            return Objects.equals(this.path, iconKey.path);
        }

        public String toString() {
            return "[path=" + this.path + ", w=" + this.w + ", h=" + this.h + "]";
        }
    }
}

