/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.icons;

import com.github.weisj.darklaf.icons.IconColorMapper;
import com.github.weisj.darklaf.icons.ThemedSVGIcon;
import com.kitfox.svg.SVGUniverse;
import com.kitfox.svg.app.beans.SVGIcon;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class CustomThemedIcon
extends ThemedSVGIcon {
    private Map<Object, Object> defaults;
    private boolean derived;

    public CustomThemedIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight) {
        this(uriSupplier, displayWidth, displayHeight, null);
    }

    public CustomThemedIcon(Supplier<URI> uriSupplier, int displayWidth, int displayHeight, Map<Object, Object> colors) {
        super(uriSupplier, displayWidth, displayHeight);
        this.defaults = colors;
    }

    public CustomThemedIcon(URI uri, int displayWidth, int displayHeight, Map<Object, Object> colors) {
        super(uri, displayWidth, displayHeight);
        this.defaults = colors;
    }

    protected CustomThemedIcon(int width, int height, CustomThemedIcon icon) {
        super(width, height, icon);
        this.defaults = icon.defaults;
        this.derived = true;
    }

    public void setProperty(Object key, Object value) throws UnsupportedOperationException {
        this.getProperties().put(key, value);
    }

    public Object getProperty(Object key) {
        return this.getProperties().get(key);
    }

    public <T> T getPropertyOfType(Object key, Class<T> type) {
        Object obj = this.getProperty(key);
        if (type != null && type.isInstance(obj)) {
            return type.cast(obj);
        }
        return null;
    }

    private Map<Object, Object> getProperties() {
        if (this.defaults == null) {
            this.defaults = new HashMap<Object, Object>();
            return this.defaults;
        }
        if (this.derived) {
            this.defaults = new HashMap<Object, Object>(this.defaults);
            this.derived = false;
        }
        return this.defaults;
    }

    @Override
    public CustomThemedIcon derive(int width, int height) {
        return new CustomThemedIcon(width, height, this);
    }

    @Override
    protected SVGIcon createSVGIcon() {
        SVGIcon icon = new SVGIcon();
        icon.setSvgUniverse(new SVGUniverse());
        return icon;
    }

    @Override
    protected void patchColors() {
        IconColorMapper.patchColors(this.getSVGIcon(), this.getProperties());
    }
}

