/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.text.codepoint;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.compare.CompareHelper;
import com.helger.commons.compare.IComparable;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.text.codepoint.CodepointHelper;
import java.nio.charset.Charset;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Codepoint
implements IComparable<Codepoint> {
    private final int m_nValue;

    public Codepoint(@Nonnull byte[] byArray, @Nonnull Charset charset) {
        this(StringHelper.decodeBytesToChars(byArray, charset));
    }

    private static int _getValueFromCharSequence(@Nonnull CharSequence charSequence) {
        ValueEnforcer.notNull(charSequence, "CharSequence");
        int n = charSequence.length();
        if (n == 1) {
            return charSequence.charAt(0);
        }
        if (n > 2) {
            throw new IllegalArgumentException("Too many chars: " + charSequence);
        }
        return Character.toCodePoint(charSequence.charAt(0), charSequence.charAt(1));
    }

    public Codepoint(@Nonnull CharSequence charSequence) {
        this(Codepoint._getValueFromCharSequence(charSequence));
    }

    public Codepoint(@Nonnull String string) {
        this(string.toCharArray());
    }

    private static int _getValueFromCharArray(@Nonnull char[] cArray) {
        ValueEnforcer.notEmpty(cArray, "CharArray");
        int n = cArray.length;
        if (n == 1) {
            return cArray[0];
        }
        if (n > 2) {
            throw new IllegalArgumentException("Too many chars: " + Arrays.toString(cArray));
        }
        return Character.toCodePoint(cArray[0], cArray[1]);
    }

    public Codepoint(@Nonnull char[] cArray) {
        this(Codepoint._getValueFromCharArray(cArray));
    }

    public Codepoint(char c) {
        this((int)c);
    }

    public Codepoint(char c, char c2) {
        this(Character.toCodePoint(c, c2));
    }

    public Codepoint(@Nonnull Codepoint codepoint) {
        this(codepoint.m_nValue);
    }

    public Codepoint(@Nonnegative int n) {
        ValueEnforcer.isTrue(Character.isValidCodePoint(n), () -> "Invalid Codepoint: " + n);
        this.m_nValue = n;
    }

    protected Codepoint(@Nonnegative int n, boolean bl) {
        this.m_nValue = n;
    }

    @Nonnegative
    public final int getValue() {
        return this.m_nValue;
    }

    public final boolean isSupplementary() {
        return Character.isSupplementaryCodePoint(this.m_nValue);
    }

    public final boolean isLowSurrogate() {
        return Character.isLowSurrogate((char)this.m_nValue);
    }

    public final boolean isHighSurrogate() {
        return Character.isHighSurrogate((char)this.m_nValue);
    }

    public final char getHighSurrogate() {
        return CodepointHelper.getHighSurrogate(this.m_nValue);
    }

    public final char getLowSurrogate() {
        return CodepointHelper.getLowSurrogate(this.m_nValue);
    }

    public boolean isBidi() {
        return CodepointHelper.isBidi(this.m_nValue);
    }

    public boolean isDigit() {
        return Character.isDigit(this.m_nValue);
    }

    public boolean isAlpha() {
        return Character.isLetter(this.m_nValue);
    }

    public boolean isAlphaDigit() {
        return Character.isLetterOrDigit(this.m_nValue);
    }

    @Nonnull
    @Nonempty
    public String getAsString() {
        return CodepointHelper.getAsString(this.m_nValue);
    }

    @Nonnull
    @ReturnsMutableCopy
    public char[] getAsChars() {
        return Character.toChars(this.m_nValue);
    }

    @Nonnegative
    public int getCharCount() {
        return Character.charCount(this.m_nValue);
    }

    @Nonnull
    public byte[] getAsBytes(@Nonnull Charset charset) {
        return this.getAsString().getBytes(charset);
    }

    public final int getPlane() {
        return this.m_nValue / 65536;
    }

    @Nonnull
    public final Codepoint next() {
        if (this.m_nValue == 0x10FFFF) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue + 1);
    }

    @Nonnull
    public final Codepoint previous() {
        if (this.m_nValue == 0) {
            throw new IndexOutOfBoundsException();
        }
        return new Codepoint(this.m_nValue - 1);
    }

    public void appendTo(@Nonnull StringBuilder stringBuilder) {
        stringBuilder.append(this.getAsChars());
    }

    @Override
    public int compareTo(@Nonnull Codepoint codepoint) {
        return CompareHelper.compare(this.m_nValue, codepoint.m_nValue);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        Codepoint codepoint = (Codepoint)object;
        return this.m_nValue == codepoint.m_nValue;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nValue).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("value", this.m_nValue).getToString();
    }
}

