/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.JMeterGUIComponent;

public class MenuInfo {
    public static final int SORT_ORDER_DEFAULT = 100;
    private final String label;
    private final String className;
    private final JMeterGUIComponent guiComp;
    private final int sortOrder;

    public MenuInfo(String displayLabel, String classFullName) {
        this(displayLabel, null, classFullName);
    }

    public MenuInfo(JMeterGUIComponent item, String classFullName) {
        this(item.getStaticLabel(), item, classFullName);
    }

    public MenuInfo(String label, JMeterGUIComponent item, String classFullName) {
        this.label = label;
        this.guiComp = item;
        this.className = classFullName;
        this.sortOrder = this.getSortOrderFromName(classFullName);
    }

    private int getSortOrderFromName(String classFullName) {
        try {
            GUIMenuSortOrder menuSortOrder = Class.forName(classFullName, false, MenuInfo.class.getClassLoader()).getDeclaredAnnotation(GUIMenuSortOrder.class);
            if (menuSortOrder != null) {
                return menuSortOrder.value();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return 100;
    }

    public String getLabel() {
        if (this.guiComp != null) {
            return this.guiComp.getStaticLabel();
        }
        return this.label;
    }

    public String getClassName() {
        return this.className;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public boolean getEnabled(String actionCommand) {
        if ("Add".equals(actionCommand)) {
            return this.guiComp.canBeAdded();
        }
        return true;
    }
}

