/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.handler;

import com.helger.commons.ValueEnforcer;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSDeclarationList;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.handler.CSSHandlingException;
import com.helger.css.handler.CSSNodeToDomainObject;
import com.helger.css.handler.ECSSNodeType;
import com.helger.css.parser.CSSNode;
import com.helger.css.reader.CSSReader;
import com.helger.css.reader.errorhandler.ICSSInterpretErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CSSHandler {
    public static final boolean DEFAULT_USE_SOURCE_LOCATION = true;
    private static final CSSHandler s_aInstance = new CSSHandler();

    private CSSHandler() {
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, CSSReader.getDefaultInterpretErrorHandler(), true, cSSNode);
    }

    @Nonnull
    @Deprecated
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        return CSSHandler.readCascadingStyleSheetFromNode(eCSSVersion, iCSSInterpretErrorHandler, true, cSSNode);
    }

    @Nonnull
    public static CascadingStyleSheet readCascadingStyleSheetFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.ROOT.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a root node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler, bl).createCascadingStyleSheetFromNode(cSSNode);
    }

    @Nonnull
    @Deprecated
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode) {
        return CSSHandler.readDeclarationListFromNode(eCSSVersion, CSSReader.getDefaultInterpretErrorHandler(), true, cSSNode);
    }

    @Deprecated
    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull CSSNode cSSNode, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler) {
        return CSSHandler.readDeclarationListFromNode(eCSSVersion, iCSSInterpretErrorHandler, true, cSSNode);
    }

    @Nonnull
    public static CSSDeclarationList readDeclarationListFromNode(@Nonnull ECSSVersion eCSSVersion, @Nonnull ICSSInterpretErrorHandler iCSSInterpretErrorHandler, boolean bl, @Nonnull CSSNode cSSNode) {
        ValueEnforcer.notNull((Object)((Object)eCSSVersion), (String)"Version");
        ValueEnforcer.notNull((Object)cSSNode, (String)"Node");
        if (!ECSSNodeType.STYLEDECLARATIONLIST.isNode(cSSNode, eCSSVersion)) {
            throw new CSSHandlingException(cSSNode, "Passed node is not a style declaration node!");
        }
        ValueEnforcer.notNull((Object)iCSSInterpretErrorHandler, (String)"ErrorHandler");
        return new CSSNodeToDomainObject(eCSSVersion, iCSSInterpretErrorHandler, bl).createDeclarationListFromNode(cSSNode);
    }
}

