/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.spinner;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.ui.DividedWidgetPainter;
import com.github.weisj.darklaf.ui.VisualPaddingProvider;
import com.github.weisj.darklaf.ui.spinner.SpinnerConstants;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class DarkSpinnerBorder
implements Border,
UIResource,
VisualPaddingProvider {
    protected final Color focusBorderColor = UIManager.getColor("Spinner.focusBorderColor");
    protected final Color borderColor = UIManager.getColor("Spinner.activeBorderColor");
    protected final Color inactiveBorderColor = UIManager.getColor("Spinner.inactiveBorderColor");
    protected final int arc = UIManager.getInt("Spinner.arc");
    protected final int borderSize = UIManager.getInt("Spinner.borderThickness");
    protected final Insets editorInsets = UIManager.getInsets("Spinner.editorInsets");
    protected final Insets cellInsets = UIManager.getInsets("Spinner.cellEditorInsets");

    @Override
    public void paintBorder(Component c, Graphics g2, int x, int y, int width, int height) {
        Graphics2D g = (Graphics2D)g2;
        GraphicsContext config = new GraphicsContext(g);
        g.translate(x, y);
        if (c instanceof JComponent) {
            boolean tableCellEditor = SpinnerConstants.isTableCellEditor(c);
            boolean treeCellEditor = !tableCellEditor && SpinnerConstants.isTreeCellEditor(c);
            int dividerLocation = this.getDividerLocation(c);
            DividedWidgetPainter.paintBorder(g, (JComponent)c, width, height, this.arc, this.borderSize, dividerLocation, tableCellEditor, treeCellEditor, DarkUIUtil.hasFocus(c), this.borderColor, this.focusBorderColor);
        }
        g.translate(-x, -y);
        config.restore();
    }

    public int getDividerLocation(Component c) {
        JSpinner spinner;
        JComponent editor;
        int dividerLocation = -1;
        if (c instanceof JSpinner && (editor = (spinner = (JSpinner)c).getEditor()) != null) {
            boolean ltr = spinner.getComponentOrientation().isLeftToRight();
            dividerLocation = ltr ? editor.getBounds().x + editor.getWidth() + this.editorInsets.right : editor.getBounds().x - this.editorInsets.left;
        }
        return dividerLocation;
    }

    protected Color getBorderColor(Component c) {
        return c.isEnabled() ? this.borderColor : this.inactiveBorderColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (SpinnerConstants.isTreeOrTableCellEditor(c)) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        return new InsetsUIResource(this.borderSize, this.borderSize, this.borderSize, this.borderSize);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public Insets getVisualPaddings(Component component) {
        return this.getBorderInsets(component);
    }
}

