/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.util;

import com.github.weisj.darklaf.util.ColorWrapper;
import java.awt.Color;
import javax.swing.plaf.UIResource;

public final class ColorUtil {
    public static Color blendColors(Color color1, Color color2, double percent) {
        if (percent == 1.0) {
            return color1;
        }
        if (percent == 0.0) {
            return color2;
        }
        double inverse_percent = 1.0 - percent;
        int redPart = (int)Math.round((double)color1.getRed() * percent + (double)color2.getRed() * inverse_percent);
        int greenPart = (int)Math.round((double)color1.getGreen() * percent + (double)color2.getGreen() * inverse_percent);
        int bluePart = (int)Math.round((double)color1.getBlue() * percent + (double)color2.getBlue() * inverse_percent);
        return new Color(redPart, greenPart, bluePart);
    }

    public static Color shift(Color c, double d) {
        return new Color(ColorUtil.shift(c.getRed(), d), ColorUtil.shift(c.getGreen(), d), ColorUtil.shift(c.getBlue(), d), c.getAlpha());
    }

    private static int shift(int colorComponent, double d) {
        int n = (int)Math.round((double)colorComponent * d);
        return n > 255 ? 255 : Math.max(n, 0);
    }

    public static Color toAlpha(Color color, double alpha) {
        return ColorUtil.toAlpha(color, (int)Math.round(alpha * 255.0));
    }

    public static Color toAlpha(Color color, int a) {
        Color c = color != null ? color : Color.black;
        return new Color(c.getRed(), c.getGreen(), c.getBlue(), Math.min(Math.max(0, a), 255));
    }

    public static Color fromHex(String str, Color defaultValue) {
        try {
            return ColorUtil.fromHex(str);
        }
        catch (Exception var3) {
            return defaultValue;
        }
    }

    public static String toHex(Color color) {
        if (color == null) {
            return "";
        }
        int r = color.getRed();
        int b = color.getBlue();
        int g = color.getGreen();
        return String.format("%02X%02X%02X", r, g, b);
    }

    public static Color fromHex(String str) {
        if (str.startsWith("#")) {
            str = str.substring(1);
        }
        if (str.length() == 3) {
            return new Color(17 * Integer.valueOf(String.valueOf(str.charAt(0)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(1)), 16), 17 * Integer.valueOf(String.valueOf(str.charAt(2)), 16));
        }
        if (str.length() == 6) {
            return Color.decode("0x" + str);
        }
        throw new IllegalArgumentException("Should be String of 3 or 6 chars length.");
    }

    public static boolean canOverwriteColor(Color c) {
        return c == null || c instanceof UIResource || c instanceof NonUIResourceOverwritableColorWrapper;
    }

    public static Color stripUIResource(Color c, boolean canOverwrite) {
        if (c instanceof UIResource) {
            if (canOverwrite) {
                return new NonUIResourceOverwritableColorWrapper(c);
            }
            return new NonUIResourceColorWrapper(c);
        }
        return c;
    }

    public static Color removeAlpha(Color color) {
        return ColorUtil.toAlpha(color, 255);
    }

    public static double getPerceivedBrightness(Color c) {
        return Math.sqrt(0.299 * (double)c.getRed() * (double)c.getRed() + 0.587 * (double)c.getGreen() * (double)c.getGreen() + 0.114 * (double)c.getBlue() * (double)c.getBlue());
    }

    public static double getLuminance(Color c) {
        return ColorUtil.getLuminance(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static double getLuminance(int red, int green, int blue) {
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double R = r <= 0.03928 ? r / 12.92 : Math.pow((r + 0.055) / 1.055, 2.4);
        double G = g <= 0.03928 ? g / 12.92 : Math.pow((g + 0.055) / 1.055, 2.4);
        double B = b <= 0.03928 ? b / 12.92 : Math.pow((b + 0.055) / 1.055, 2.4);
        return 0.2126 * R + 0.7152 * G + 0.0722 * B;
    }

    public static class NonUIResourceOverwritableColorWrapper
    extends NonUIResourceColorWrapper {
        public NonUIResourceOverwritableColorWrapper(Color color) {
            super(color);
        }
    }

    public static class NonUIResourceColorWrapper
    extends ColorWrapper {
        public NonUIResourceColorWrapper(Color color) {
            super(color);
        }
    }
}

