/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.jmeter.util.JMeterUtils;

public class TimeHelper {
    private static final String TIMESTAMP_FORMAT_PROPERTY = "jmeter.save.saveservice.timestamp_format";

    public static String time(long t) {
        long h = t / 3600000L;
        long m = (t %= 3600000L) / 60000L;
        long s = (t %= 60000L) / 1000L;
        long ms = t %= 1000L;
        if (h > 0L) {
            return h + "h " + m + "m " + s + "s " + ms + " ms";
        }
        if (m > 0L) {
            return m + "m " + s + "s " + ms + " ms";
        }
        if (s > 0L) {
            return s + "s " + ms + " ms";
        }
        if (ms > 0L) {
            return ms + "ms";
        }
        return "0 ms";
    }

    public static String formatTimeStamp(long timeStamp) {
        return TimeHelper.formatTimeStamp(timeStamp, JMeterUtils.getProperty(TIMESTAMP_FORMAT_PROPERTY));
    }

    public static String formatTimeStamp(long timeStamp, String format) {
        SimpleDateFormat dateFormat = format != null ? new SimpleDateFormat(format) : new SimpleDateFormat();
        return dateFormat.format(new Date(timeStamp));
    }
}

