/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.JsseSSLManager;
import org.apache.jmeter.util.SSLManager;
import org.apache.jmeter.util.SlowSSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSSLProtocolSocketFactory
extends SSLSocketFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpSSLProtocolSocketFactory.class);
    private static final String PROTOCOL_LIST = JMeterUtils.getPropDefault("https.socket.protocols", "");
    private static final String[] protocols = PROTOCOL_LIST.split(" ");
    private static final String CIPHER_LIST = JMeterUtils.getPropDefault("https.cipherSuites", "");
    private static final String[] ciphers = CIPHER_LIST.split(", *");
    private final int cps;

    public HttpSSLProtocolSocketFactory() {
        this(0);
    }

    public HttpSSLProtocolSocketFactory(int cps) {
        this.cps = cps;
    }

    private void configureSocket(Socket socket) {
        block8: {
            SSLSocket sock;
            block7: {
                if (!(socket instanceof SSLSocket)) {
                    throw new IllegalArgumentException("Expected SSLSocket");
                }
                sock = (SSLSocket)socket;
                if (!PROTOCOL_LIST.isEmpty()) {
                    try {
                        sock.setEnabledProtocols(protocols);
                    }
                    catch (IllegalArgumentException e) {
                        if (!log.isWarnEnabled()) break block7;
                        log.warn("Could not set protocol list: {}.", (Object)PROTOCOL_LIST);
                        log.warn("Valid protocols are: {}", (Object)this.join(sock.getSupportedProtocols()));
                    }
                }
            }
            if (!CIPHER_LIST.isEmpty()) {
                try {
                    sock.setEnabledCipherSuites(ciphers);
                }
                catch (IllegalArgumentException e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn("Could not set cipher list: {}.", (Object)CIPHER_LIST);
                    log.warn("Valid ciphers are: {}", (Object)this.join(sock.getSupportedCipherSuites()));
                }
            }
        }
    }

    private String join(String[] strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    private SSLSocketFactory getSSLSocketFactory() throws IOException {
        try {
            SSLContext sslContext = ((JsseSSLManager)SSLManager.getInstance()).getContext();
            return sslContext.getSocketFactory();
        }
        catch (GeneralSecurityException ex) {
            throw new IOException("Rethrown as IOE", ex);
        }
    }

    private Socket wrapSocket(Socket sock) {
        if (this.cps > 0) {
            return new SlowSSLSocket((SSLSocket)sock, this.cps);
        }
        return sock;
    }

    @Override
    public Socket createSocket() throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket();
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(address, port, localAddress, localPort);
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getDefaultCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    @Override
    public String[] getSupportedCipherSuites() {
        try {
            SSLSocketFactory sslfac = this.getSSLSocketFactory();
            return sslfac.getSupportedCipherSuites();
        }
        catch (IOException ex) {
            return new String[0];
        }
    }

    @Override
    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(s, host, port, autoClose);
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port);
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress inetAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocketFactory sslfac = this.getSSLSocketFactory();
        Socket sock = sslfac.createSocket(host, port, inetAddress, localPort);
        this.configureSocket(sock);
        return this.wrapSocket(sock);
    }

    static {
        if (!PROTOCOL_LIST.isEmpty()) {
            log.info("Using protocol list:{} and cipher list: {}", (Object)PROTOCOL_LIST, (Object)CIPHER_LIST);
        }
    }
}

