/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.MenuElement;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.plugin.MenuCreator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchematicView
extends AbstractAction
implements MenuCreator {
    private static final Logger log = LoggerFactory.getLogger(SchematicView.class);
    private static final String DEFAULT_XSL_FILE = JMeterUtils.getProperty("docgeneration.schematic_xsl");
    private static final MessageFormat GENERATION_SUCCESS_MSG = new MessageFormat(JMeterUtils.getResString("schematic_view_generation_ok"));
    private static final Set<String> commands = new HashSet<String>();

    @Override
    public void doAction(ActionEvent e) {
        block28: {
            try {
                String updateFile = GuiPackage.getInstance().getTestPlanFile();
                if (updateFile != null) {
                    int response;
                    ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "check_dirty"));
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setDialogTitle(JMeterUtils.getResString("schematic_view_outputfile"));
                    jFileChooser.setCurrentDirectory(new File(updateFile).getParentFile());
                    jFileChooser.setSelectedFile(new File(updateFile + ".html"));
                    int retVal = jFileChooser.showSaveDialog(GuiPackage.getInstance().getMainFrame());
                    if (retVal != 0) break block28;
                    File outputFile = jFileChooser.getSelectedFile();
                    if (outputFile.exists() && ((response = JOptionPane.showConfirmDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString("save_overwrite_existing_file"), JMeterUtils.getResString("save?"), 0, 3)) == -1 || response == 1)) {
                        return;
                    }
                    try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
                         BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                        new XslSchematicViewGenerator().generate(GuiPackage.getInstance().getCurrentSubTree(), new File(updateFile), bufferedOutputStream);
                    }
                    JMeterUtils.reportInfoToUser(GENERATION_SUCCESS_MSG.format(new Object[]{outputFile.getAbsolutePath()}), JMeterUtils.getResString("schematic_view_info"));
                    break block28;
                }
                JMeterUtils.reportInfoToUser(JMeterUtils.getResString("schematic_view_no_plan"), JMeterUtils.getResString("schematic_view_info"));
            }
            catch (Exception ex) {
                JMeterUtils.reportErrorToUser(JMeterUtils.getResString("schematic_view_errors"), ex);
            }
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    @Override
    public JMenuItem[] getMenuItemsAtLocation(MenuCreator.MENU_LOCATION location) {
        if (location == MenuCreator.MENU_LOCATION.TOOLS) {
            JMenuItem menuItem = new JMenuItem(JMeterUtils.getResString("schematic_view"), 0);
            menuItem.setName("schematic_view");
            menuItem.setActionCommand("schematic_view");
            menuItem.setAccelerator(null);
            menuItem.addActionListener(ActionRouter.getInstance());
            return new JMenuItem[]{menuItem};
        }
        return new JMenuItem[0];
    }

    @Override
    public JMenu[] getTopLevelMenus() {
        return new JMenu[0];
    }

    @Override
    public boolean localeChanged(MenuElement menu) {
        return false;
    }

    @Override
    public void localeChanged() {
    }

    static {
        commands.add("schematic_view");
    }

    private static final class XslSchematicViewGenerator
    implements SchematicViewGenerator {
        private XslSchematicViewGenerator() {
        }

        @Override
        public void generate(HashTree testPlan, File testPlanFile, OutputStream outputStream) throws Exception {
            StreamSource xslt;
            TransformerFactory factory = TransformerFactory.newInstance("net.sf.saxon.BasicTransformerFactory", Thread.currentThread().getContextClassLoader());
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            if (!StringUtils.isEmpty((CharSequence)DEFAULT_XSL_FILE)) {
                log.info("Will use file {} for Schematic View generation", (Object)DEFAULT_XSL_FILE);
                xslt = new StreamSource(new File(DEFAULT_XSL_FILE));
            } else {
                xslt = new StreamSource(SchematicView.class.getResourceAsStream("/org/apache/jmeter/gui/action/schematic.xsl"));
            }
            Transformer transformer = factory.newTransformer(xslt);
            StreamSource text = new StreamSource(testPlanFile);
            transformer.transform(text, new StreamResult(outputStream));
        }
    }

    @FunctionalInterface
    public static interface SchematicViewGenerator {
        public void generate(HashTree var1, File var2, OutputStream var3) throws Exception;
    }
}

