/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.cluster.AddressSet;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.util.Clock;

public class ClusterRoutingTable
implements RoutingTable {
    private static final int MIN_ROUTERS = 1;
    private final Clock clock;
    private volatile long expirationTimestamp;
    private final AddressSet readers;
    private final AddressSet writers;
    private final AddressSet routers;
    private final DatabaseName databaseName;
    private boolean preferInitialRouter;

    public ClusterRoutingTable(DatabaseName ofDatabase, Clock clock, BoltServerAddress ... routingAddresses) {
        this(ofDatabase, clock);
        this.routers.update(new LinkedHashSet<BoltServerAddress>(Arrays.asList(routingAddresses)));
    }

    private ClusterRoutingTable(DatabaseName ofDatabase, Clock clock) {
        this.databaseName = ofDatabase;
        this.clock = clock;
        this.expirationTimestamp = clock.millis() - 1L;
        this.preferInitialRouter = true;
        this.readers = new AddressSet();
        this.writers = new AddressSet();
        this.routers = new AddressSet();
    }

    @Override
    public boolean isStaleFor(AccessMode mode) {
        return this.expirationTimestamp < this.clock.millis() || this.routers.size() < 1 || mode == AccessMode.READ && this.readers.size() == 0 || mode == AccessMode.WRITE && this.writers.size() == 0;
    }

    @Override
    public boolean hasBeenStaleFor(long extraTime) {
        long totalTime = this.expirationTimestamp + extraTime;
        if (totalTime < 0L) {
            totalTime = Long.MAX_VALUE;
        }
        return totalTime < this.clock.millis();
    }

    @Override
    public synchronized void update(ClusterComposition cluster) {
        this.expirationTimestamp = cluster.expirationTimestamp();
        this.readers.update(cluster.readers());
        this.writers.update(cluster.writers());
        this.routers.update(cluster.routers());
        this.preferInitialRouter = !cluster.hasWriters();
    }

    @Override
    public synchronized void forget(BoltServerAddress address) {
        this.routers.remove(address);
        this.readers.remove(address);
        this.writers.remove(address);
    }

    @Override
    public AddressSet readers() {
        return this.readers;
    }

    @Override
    public AddressSet writers() {
        return this.writers;
    }

    @Override
    public AddressSet routers() {
        return this.routers;
    }

    @Override
    public Set<BoltServerAddress> servers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        Collections.addAll(servers, this.readers.toArray());
        Collections.addAll(servers, this.writers.toArray());
        Collections.addAll(servers, this.routers.toArray());
        return servers;
    }

    @Override
    public DatabaseName database() {
        return this.databaseName;
    }

    @Override
    public void forgetWriter(BoltServerAddress toRemove) {
        this.writers.remove(toRemove);
    }

    @Override
    public boolean preferInitialRouter() {
        return this.preferInitialRouter;
    }

    public synchronized String toString() {
        return String.format("Ttl %s, currentTime %s, routers %s, writers %s, readers %s, database '%s'", this.expirationTimestamp, this.clock.millis(), this.routers, this.writers, this.readers, this.databaseName.description());
    }
}

