/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.util.List;
import org.apache.jmeter.extractor.Extractor;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.util.JOrphanUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JSoupExtractor
implements Extractor {
    private static final long serialVersionUID = -6308012192067714191L;
    private static final String CACHE_KEY_PREFIX = JSoupExtractor.class.getName() + "_PARSED_BODY";

    @Override
    public int extract(String expression, String attribute, int matchNumber, String inputString, List<String> result, int found, String cacheKey) {
        Document document;
        if (cacheKey != null) {
            document = (Document)JMeterContextService.getContext().getSamplerContext().get(CACHE_KEY_PREFIX + cacheKey);
            if (document == null) {
                document = Jsoup.parse((String)inputString);
                JMeterContextService.getContext().getSamplerContext().put(CACHE_KEY_PREFIX + cacheKey, document);
            }
        } else {
            document = Jsoup.parse((String)inputString);
        }
        Elements elements = document.select(expression);
        for (Element element : elements) {
            if (matchNumber > 0 && found == matchNumber) break;
            result.add(this.extractValue(attribute, element));
            ++found;
        }
        return found;
    }

    private String extractValue(String attribute, Element element) {
        if (!JOrphanUtils.isBlank((String)attribute)) {
            return element.attr(attribute);
        }
        return element.text().trim();
    }
}

