/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.registry;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.rmi.server.ObjID;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.objectweb.carol.jndi.registry.RegistryFireWall;
import org.objectweb.carol.jndi.registry.RegistryManager;
import org.objectweb.carol.jndi.registry.RegistryManagerImpl;
import sun.rmi.registry.RegistryImpl;

public class ManageableRegistry
extends RegistryImpl {
    public Hashtable remoteObjectTable = new Hashtable(101);
    public static ManageableRegistry manageableRegistry;
    public static ObjID id;
    public static RegistryFireWall writeFirewall;
    public static RegistryFireWall readFirewall;
    public static String REGISTRY_MANAGER_NAME;
    public Properties regProps = new Properties();
    RegistryManager manager = null;
    public static boolean verbose;

    public ManageableRegistry(int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        try {
            this.regProps.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("registry.properties"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setManager();
    }

    public ManageableRegistry(int port) throws RemoteException {
        super(port);
        try {
            this.regProps.load(Thread.currentThread().getContextClassLoader().getResourceAsStream("registry.properties"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setManager();
    }

    private void setManager() throws RemoteException {
        this.manager = new RegistryManagerImpl(this);
        try {
            this.bind(REGISTRY_MANAGER_NAME, this.manager);
        }
        catch (Exception e) {}
    }

    public void setVerbose(boolean v) {
        System.out.println("RegistryManager.setVerbose(" + v + ")");
        verbose = v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Remote lookup(String name) throws RemoteException, NotBoundException {
        ManageableRegistry.checkReadAccess(name);
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.lookup(" + name + ") from client: " + RemoteServer.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable hashtable = this.remoteObjectTable;
        synchronized (hashtable) {
            Remote obj = (Remote)this.remoteObjectTable.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        ManageableRegistry.checkWriteAccess();
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.bind(" + name + ", obj)" + " from client: " + RemoteServer.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable hashtable = this.remoteObjectTable;
        synchronized (hashtable) {
            Remote curr = (Remote)this.remoteObjectTable.get(name);
            if (curr != null) {
                throw new AlreadyBoundException(name);
            }
            this.remoteObjectTable.put(name, obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        ManageableRegistry.checkWriteAccess();
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.unbind(" + name + ")" + " from client: " + RemoteServer.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable hashtable = this.remoteObjectTable;
        synchronized (hashtable) {
            if (REGISTRY_MANAGER_NAME.equals(name)) {
                throw new NotBoundException("Can not unbind the Registry Manager use the Stop() method");
            }
            Remote obj = (Remote)this.remoteObjectTable.get(name);
            if (obj == null) {
                throw new NotBoundException(name);
            }
            this.remoteObjectTable.remove(name);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        ManageableRegistry.checkWriteAccess();
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.rebind(" + name + ", obj)" + " from client: " + RemoteServer.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        this.remoteObjectTable.put(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws RemoteException {
        String[] names;
        ManageableRegistry.checkReadAccess("");
        if (verbose) {
            try {
                System.out.println("ManageableRegistry.list() from client: " + RemoteServer.getClientHost());
            }
            catch (ServerNotActiveException e) {
                e.printStackTrace();
            }
        }
        Hashtable hashtable = this.remoteObjectTable;
        synchronized (hashtable) {
            int i = this.remoteObjectTable.size();
            names = new String[i];
            Enumeration enumeration = this.remoteObjectTable.keys();
            while (--i >= 0) {
                names[i] = (String)enumeration.nextElement();
            }
        }
        return names;
    }

    public static ObjID getID() {
        return id;
    }

    public static Registry createManagableRegistry(int port) throws RemoteException {
        return new ManageableRegistry(port);
    }

    public void purge() {
        RegistryManager reg = (RegistryManager)this.remoteObjectTable.get(REGISTRY_MANAGER_NAME);
        this.remoteObjectTable.clear();
        this.remoteObjectTable.put(REGISTRY_MANAGER_NAME, reg);
    }

    public static void main(String[] args) {
        try {
            int regPort = 1099;
            if (args.length >= 1) {
                regPort = Integer.parseInt(args[0]);
            }
            manageableRegistry = new ManageableRegistry(regPort);
            System.out.println("ManageableRegistry started on port " + regPort);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void checkWriteAccess() throws AccessException {
        try {
            String clientHostName = RemoteServer.getClientHost();
            InetAddress clientHost = InetAddress.getByName(clientHostName);
            if (!writeFirewall.isAllow(clientHost)) {
                throw new AccessException("Write in registry disallowed; from " + clientHost + " host");
            }
        }
        catch (ServerNotActiveException ex) {
        }
        catch (UnknownHostException ex) {
            throw new AccessException("Write in the registry disallowed; from unknown host");
        }
    }

    public static void checkReadAccess(String name) throws AccessException {
        try {
            String clientHostName = RemoteServer.getClientHost();
            InetAddress clientHost = InetAddress.getByName(clientHostName);
            if (!(REGISTRY_MANAGER_NAME.equals(name) && InetAddress.getLocalHost().equals(clientHost) || readFirewall.isAllow(clientHost))) {
                throw new AccessException("Read in registry disallowed; from " + clientHost + " host");
            }
        }
        catch (ServerNotActiveException ex) {
        }
        catch (UnknownHostException ex) {
            throw new AccessException("Read in the registry disallowed; from unknown host");
        }
    }

    public synchronized void allowWriteAll() {
        writeFirewall.allowAll();
    }

    public synchronized void forbidWriteAll() {
        writeFirewall.forbidAll();
    }

    public synchronized void addWriteForbidenAddress(InetAddress i) {
        writeFirewall.addForbidenAddress(i);
    }

    public synchronized void addWriteAllowAddress(InetAddress i) {
        writeFirewall.addAllowedAddress(i);
    }

    public InetAddress[] listWriteForbidenAddress() {
        return writeFirewall.listForbidenAddress();
    }

    public InetAddress[] listWriteAllowedAddress() {
        return writeFirewall.listAllowedAddress();
    }

    public boolean isWriteAllowAll() {
        return writeFirewall.isAllowAll();
    }

    public boolean isWriteAllow(InetAddress i) {
        return writeFirewall.isAllow(i);
    }

    public synchronized void allowReadAll() {
        readFirewall.allowAll();
    }

    public synchronized void forbidReadAll() {
        readFirewall.forbidAll();
    }

    public synchronized void addReadForbidenAddress(InetAddress i) {
        readFirewall.addForbidenAddress(i);
    }

    public synchronized void addReadAllowAddress(InetAddress i) {
        readFirewall.addAllowedAddress(i);
    }

    public InetAddress[] listReadForbidenAddress() {
        return readFirewall.listForbidenAddress();
    }

    public InetAddress[] listReadAllowedAddress() {
        return readFirewall.listAllowedAddress();
    }

    public boolean isReadAllowAll() {
        return readFirewall.isAllowAll();
    }

    public boolean isReadAllow(InetAddress i) {
        return readFirewall.isAllow(i);
    }

    static {
        id = new ObjID(0);
        writeFirewall = new RegistryFireWall();
        readFirewall = new RegistryFireWall();
        REGISTRY_MANAGER_NAME = "carolregistryadministator";
        verbose = false;
    }
}

