/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.hsqldb.util.SqlToolError;

public class SqlFile {
    private static final int DEFAULT_HISTORY_SIZE = 20;
    private File file;
    private boolean interactive;
    private String primaryPrompt = "sql> ";
    private String contPrompt = "  +> ";
    private Connection curConn = null;
    private boolean htmlMode = false;
    private HashMap userVars = null;
    private String[] statementHistory = null;
    BooleanBucket possiblyUncommitteds = new BooleanBucket();
    private static final int SEP_LEN = 2;
    private static final String DIVIDER = "----------------------------------------------------------------------------------------------------------------------------------";
    private static final String SPACES = "                                                                                                                                  ";
    private static String revnum = null;
    private static String BANNER;
    private static final String BUFFER_HELP_TEXT = "BUFFER Commands (only available for interactive use).\n\n    :?                Help\n    :;                Execute current buffer as an SQL Statement\n    :a[text]          Enter append mode with a copy of the buffer\n    :l                List current contents of buffer\n    :s/from/to        Substitute \"to\" for first occurrence of \"from\"\n    :s/from/to/[i;g2] Substitute \"to\" for occurrence(s) of \"from\"\n                from:  '$'s represent line breaks\n                to:    If empty, from's will be deleted (e.g. \":s/x//\").\n                       '$'s represent line breaks\n                       You can't use ';' in order to execute the SQL (use\n                       the ';' switch for this purpose, as explained below).\n                /:     Can actually be any character which occurs in\n                       neither \"to\" string nor \"from\" string.\n                SUBSTITUTION MODE SWITCHES:\n                       i:  case Insensitive\n                       ;:  execute immediately after substitution\n                       g:  Global (substitute ALL occurrences of \"from\" string)\n                       2:  Narrows substitution to specified buffer line number\n                           (Use any line number in place of '2').\n";
    private static final String HELP_TEXT = "SPECIAL Commands.\n* commands only available for interactive use.\nIn place of \"3\" below, you can use nothing for the previous command, or\nan integer \"X\" to indicate the Xth previous command.\n\n    \\?                   Help\n    \\p [line to print]   Print string to stdout\n    \\w file/path.sql     Append current buffer to file\n    \\i file/path.sql     Include/execute commands from external file\n    \\d{tv*sa} [substr]   List names of Tbls/Views/all/System Tbls/Aliases\n    \\d OBJECTNAME        Describe table or view\n    \\o [file/path.html]  Tee (or stop teeing) query output to specified file\n    \\H                   Toggle HTML output mode\n    \\! COMMAND ARGS      Execute external program (no support for stdin)\n    \\* [true|false]      Continue upon errors (a.o.t. abort upon error)\n    \\a [true|false]      Auto-commit JDBC DML commands\n    \\s                   * Show previous commands (i.e. SQL command history)\n    \\-[3]                * reload a command to buffer (for : commands)\n    \\-[3];               * reload command and execute (via \":;\")\n    \\q [abort message]   Quit (alternatively, end input like Ctrl-Z or Ctrl-D)\n";
    private static final String PL_HELP_TEXT = "PROCEDURAL LANGUAGE Commands.  MUST have white space after '*'.\n    * ?                           Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value (note spaces around =)\n    * VARNAME =                   Unset variable (note space before =)\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * list [VARNAME1...]          List values of variable(s) (defaults to all)\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may omit the {}'s iff *VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n* VARNAME ~ sets the variable value according to the very next SQL statement:\n    Query:  The value of the first field of the first row returned\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n";
    public boolean recursed = false;
    private String curCommand = null;
    private int curLinenum = -1;
    private int curHist = -1;
    private PrintStream psStd = null;
    private PrintStream psErr = null;
    private PrintWriter pwQuery = null;
    StringBuffer stringBuffer = new StringBuffer();
    private boolean continueOnError = false;
    private static final String DEFAULT_CHARSET = "US-ASCII";
    private BufferedReader br = null;
    private String charset = null;
    public boolean plMode = false;
    private String fetchingVar = null;
    private static final int DEFAULT_ELEMENT = 0;
    private static final int HSQLDB_ELEMENT = 1;
    private static final int ORACLE_ELEMENT = 2;
    private static final int[][] listMDTableCols;
    private static final int COL_HEAD = 0;
    private static final int COL_ODD = 1;
    private static final int COL_EVEN = 2;
    private static final String PRE_TR;
    private static final String PRE_TD;

    public SqlFile(File file, boolean bl, HashMap hashMap) throws IOException {
        this.file = file;
        this.interactive = bl;
        this.userVars = hashMap;
        if (this.interactive) {
            String string = System.getProperty("sqltool.historyLength");
            try {
                this.statementHistory = new String[Integer.parseInt(System.getProperty("sqltool.historyLength"))];
            }
            catch (Throwable throwable) {
                this.statementHistory = null;
            }
            if (this.statementHistory == null) {
                this.statementHistory = new String[20];
            }
        }
        if (this.file != null && !this.file.canRead()) {
            throw new IOException("Can't read SQL file '" + this.file + "'");
        }
    }

    public SqlFile(boolean bl, HashMap hashMap) throws IOException {
        this(null, bl, hashMap);
    }

    public void execute(Connection connection, Boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, bl);
    }

    public void execute(Connection connection, boolean bl) throws IOException, SqlToolError, SQLException {
        this.execute(connection, System.out, System.err, new Boolean(bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void execute(Connection connection, PrintStream printStream, PrintStream printStream2, Boolean bl) throws IOException, SqlToolError, SQLException {
        boolean bl2;
        block50: {
            String string;
            this.psStd = printStream;
            this.psErr = printStream2;
            this.curConn = connection;
            this.curLinenum = -1;
            boolean bl3 = false;
            bl2 = false;
            boolean bl4 = this.continueOnError = bl == null ? this.interactive : bl;
            if (this.userVars != null && this.userVars.size() > 0) {
                this.plMode = true;
            }
            this.charset = (string = System.getProperty("sqlfile.charset")) == null ? DEFAULT_CHARSET : string;
            try {
                try {
                    this.br = new BufferedReader(new InputStreamReader(this.file == null ? System.in : new FileInputStream(this.file), this.charset));
                    this.curLinenum = 0;
                    if (this.interactive) {
                        this.stdprintln(BANNER);
                    }
                    while (true) {
                        block49: {
                            String string2;
                            int n;
                            String string3;
                            if (this.interactive) {
                                this.psStd.print(this.stringBuffer.length() == 0 ? this.primaryPrompt : this.contPrompt);
                            }
                            if ((string3 = this.br.readLine()) == null) {
                                if (!this.interactive) break;
                                this.psStd.println();
                                break;
                            }
                            ++this.curLinenum;
                            if (bl3) {
                                n = string3.indexOf("*/") + 2;
                                if (n <= 1) continue;
                                string3 = string3.substring(n);
                                this.stringBuffer.setLength(0);
                                bl3 = false;
                            }
                            String string4 = string3.trim();
                            try {
                                if (this.stringBuffer.length() == 0) {
                                    if (string4.startsWith("/*")) {
                                        n = string4.indexOf("*/", 2) + 2;
                                        if (n > 1) {
                                            string3 = string3.substring(n + string3.length() - string4.length());
                                            string4 = string3.trim();
                                        } else {
                                            this.stringBuffer.append("COMMENT");
                                            bl3 = true;
                                            continue;
                                        }
                                    }
                                    if (string4.length() == 0) continue;
                                    if (string4.startsWith("* ") || string4.equals("*")) {
                                        try {
                                            this.processPL(string4.length() == 1 ? "" : string4.substring(2));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (string4.charAt(0) == '\\') {
                                        try {
                                            this.processSpecial(string4.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                    if (this.interactive && string4.charAt(0) == ':') {
                                        try {
                                            this.processBuffer(string4.substring(1));
                                            continue;
                                        }
                                        catch (BadSpecial badSpecial) {
                                            this.errprintln("Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + string3 + "\"\n" + badSpecial.getMessage());
                                            if (this.continueOnError) continue;
                                            throw new SqlToolError(badSpecial);
                                        }
                                    }
                                }
                                if (string4.length() == 0) {
                                    if (!this.interactive || bl3) continue;
                                    this.setBuf(this.stringBuffer.toString());
                                    this.stringBuffer.setLength(0);
                                    this.stdprintln("Current input moved into buffer.");
                                    continue;
                                }
                                String string5 = SqlFile.deTerminated(string3);
                                if (!string4.equals(";")) {
                                    if (this.stringBuffer.length() > 0) {
                                        this.stringBuffer.append('\n');
                                    }
                                    this.stringBuffer.append(string5 == null ? string3 : string5);
                                }
                                if (string5 == null) continue;
                                this.curCommand = this.stringBuffer.toString();
                                String string6 = this.curCommand.trim();
                                if (string6.length() == 0) {
                                    throw new SQLException("Empty SQL Statement");
                                }
                                if (this.interactive) {
                                    this.setBuf(this.curCommand);
                                }
                                this.processSQL();
                            }
                            catch (SQLException sQLException) {
                                this.errprintln("SQL Error at '" + (this.file == null ? "stdin" : this.file.toString()) + "' line " + this.curLinenum + ":\n\"" + this.curCommand + "\"\n" + sQLException.getMessage());
                                if (!this.continueOnError) {
                                    throw sQLException;
                                }
                            }
                            catch (BreakException breakException) {
                                string2 = breakException.getMessage();
                                if (!this.recursed && string2 != null && !string2.equals("file")) {
                                    this.errprintln("Unsatisfied break statement" + (string2 == null ? "" : " (type " + string2 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw breakException;
                                if (!this.continueOnError) {
                                    throw breakException;
                                }
                            }
                            catch (ContinueException continueException) {
                                string2 = continueException.getMessage();
                                if (!this.recursed) {
                                    this.errprintln("Unsatisfied continue statement" + (string2 == null ? "" : " (type " + string2 + ')') + '.');
                                } else {
                                    bl2 = true;
                                }
                                if (this.recursed) throw continueException;
                                if (!this.continueOnError) {
                                    throw continueException;
                                }
                            }
                            catch (QuitNow quitNow) {
                                throw quitNow;
                            }
                            catch (SqlToolError sqlToolError) {
                                if (this.continueOnError) break block49;
                                throw sqlToolError;
                            }
                        }
                        this.stringBuffer.setLength(0);
                    }
                    if (bl3 || this.stringBuffer.length() != 0) {
                        this.errprintln("Unterminated input:  [" + this.stringBuffer + ']');
                        throw new SqlToolError("Unterminated input:  [" + this.stringBuffer + ']');
                    }
                    bl2 = true;
                }
                catch (QuitNow quitNow) {
                    boolean bl5 = bl2 = quitNow.getMessage() == null;
                    if (!this.recursed && !bl2) {
                        this.errprintln("Aborting: " + quitNow.getMessage());
                    }
                    if (this.recursed) throw quitNow;
                    if (!bl2) {
                        throw quitNow;
                    }
                    Object var16_25 = null;
                    this.closeQueryOutputStream();
                    if (this.fetchingVar != null) {
                        this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                        bl2 = false;
                    }
                    if (this.br != null) {
                        this.br.close();
                    }
                    if (bl2) return;
                    if (!this.possiblyUncommitteds.get()) return;
                    this.errprintln("Rolling back SQL transaction.");
                    this.curConn.rollback();
                    this.possiblyUncommitteds.set(false);
                    return;
                }
                Object var16_24 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br == null) break block50;
            }
            catch (Throwable throwable) {
                Object var16_26 = null;
                this.closeQueryOutputStream();
                if (this.fetchingVar != null) {
                    this.errprintln("PL variable setting incomplete:  " + this.fetchingVar);
                    bl2 = false;
                }
                if (this.br != null) {
                    this.br.close();
                }
                if (bl2) throw throwable;
                if (!this.possiblyUncommitteds.get()) throw throwable;
                this.errprintln("Rolling back SQL transaction.");
                this.curConn.rollback();
                this.possiblyUncommitteds.set(false);
                throw throwable;
            }
            this.br.close();
        }
        if (bl2) return;
        if (!this.possiblyUncommitteds.get()) return;
        this.errprintln("Rolling back SQL transaction.");
        this.curConn.rollback();
        this.possiblyUncommitteds.set(false);
    }

    private static String deTerminated(String string) {
        int n = string.lastIndexOf(59);
        if (n < 0) {
            return null;
        }
        for (int i = n + 1; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return null;
        }
        return string.substring(0, n);
    }

    private void processBuffer(String string) throws BadSpecial, SQLException {
        boolean bl = false;
        int n = 105;
        String string2 = null;
        if (string.length() > 0) {
            n = string.charAt(0);
            string2 = string.substring(1);
            if (string2.trim().length() == 0) {
                string2 = null;
            }
        }
        switch (n) {
            case 59: {
                this.curCommand = this.commandFromHistory(0);
                this.stdprintln("Executing command from buffer:\n" + this.curCommand + '\n');
                this.processSQL();
                return;
            }
            case 65: 
            case 97: {
                this.stringBuffer.append(this.commandFromHistory(0));
                if (string2 != null) {
                    String string3 = SqlFile.deTerminated(string2);
                    if (!string2.equals(";")) {
                        this.stringBuffer.append(string3 == null ? string2 : string3);
                    }
                    if (string3 != null) {
                        this.curCommand = this.stringBuffer.toString();
                        this.setBuf(this.curCommand);
                        this.stdprintln("Executing:\n" + this.curCommand + '\n');
                        this.processSQL();
                        this.stringBuffer.setLength(0);
                        return;
                    }
                }
                this.stdprintln("Appending to:\n" + this.stringBuffer);
                return;
            }
            case 76: 
            case 108: {
                this.stdprintln("Current Buffer:\n" + this.commandFromHistory(0));
                return;
            }
            case 83: 
            case 115: {
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                int n2 = 0;
                try {
                    int n3;
                    int n4;
                    String string4 = this.commandFromHistory(0);
                    StringBuffer stringBuffer = new StringBuffer(string4);
                    if (string2 == null) {
                        throw new BadSwitch(0);
                    }
                    String string5 = string2.substring(0, 1);
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, string5, true);
                    if (stringTokenizer.countTokens() < 4 || !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(1);
                    }
                    String string6 = stringTokenizer.nextToken().replace('$', '\n');
                    if (!stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(2);
                    }
                    String string7 = stringTokenizer.nextToken().replace('$', '\n');
                    if (string7.equals(string5)) {
                        string7 = "";
                    } else if (stringTokenizer.countTokens() > 0 && !stringTokenizer.nextToken().equals(string5)) {
                        throw new BadSwitch(3);
                    }
                    if (stringTokenizer.countTokens() > 0) {
                        String string8 = stringTokenizer.nextToken("");
                        block15: for (n4 = 0; n4 < string8.length(); ++n4) {
                            switch (string8.charAt(n4)) {
                                case 'i': {
                                    bl2 = true;
                                    continue block15;
                                }
                                case ';': {
                                    bl4 = true;
                                    continue block15;
                                }
                                case 'g': {
                                    bl3 = true;
                                    continue block15;
                                }
                                case '1': 
                                case '2': 
                                case '3': 
                                case '4': 
                                case '5': 
                                case '6': 
                                case '7': 
                                case '8': 
                                case '9': {
                                    n2 = Character.digit(string8.charAt(n4), 10);
                                    continue block15;
                                }
                                default: {
                                    throw new BadSpecial("Unknown Substitution option: " + string8.charAt(n4));
                                }
                            }
                        }
                    }
                    if (bl2) {
                        string4 = string4.toUpperCase();
                        string6 = string6.toUpperCase();
                    }
                    int n5 = 0;
                    n4 = -1;
                    if (n2 > 0) {
                        for (n3 = 1; n3 < n2; ++n3) {
                            if ((n5 = string4.indexOf(10, n5) + 1) >= 1) continue;
                            throw new BadSpecial("There are not " + n2 + " lines in the buffer.");
                        }
                        n4 = string4.indexOf(10, n5);
                    }
                    if (n4 < 0) {
                        n4 = string4.length();
                    }
                    if (bl3) {
                        n3 = n4;
                        while ((n3 = string4.lastIndexOf(string6, n3 - 1)) >= n5) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    } else {
                        n3 = string4.indexOf(string6, n5);
                        if (n3 > -1 && n3 < n4) {
                            stringBuffer.replace(n3, n3 + string6.length(), string7);
                        }
                    }
                    this.statementHistory[this.curHist] = stringBuffer.toString();
                    this.stdprintln((bl4 ? "Executing" : "Current Buffer") + ":\n" + this.commandFromHistory(0));
                    if (bl4) {
                        this.stdprintln();
                    }
                }
                catch (BadSwitch badSwitch) {
                    throw new BadSpecial("Substitution syntax:  \":s/from this/to that/i;g2\".  Use '$' for line separations.  [" + badSwitch.getMessage() + ']');
                }
                if (bl4) {
                    this.curCommand = this.commandFromHistory(0);
                    this.processSQL();
                }
                return;
            }
            case 63: {
                this.stdprintln(BUFFER_HELP_TEXT);
                return;
            }
        }
        throw new BadSpecial("Unknown Buffer Command");
    }

    private void processSpecial(String string) throws BadSpecial, QuitNow, SQLException, SqlToolError {
        boolean bl = false;
        String string2 = null;
        if (string.length() < 1) {
            throw new BadSpecial("Null special command");
        }
        if (this.plMode) {
            string = this.dereference(string, false);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken("").trim();
        }
        switch (string3.charAt(0)) {
            case 'q': {
                if (string2 != null) {
                    throw new QuitNow(string2);
                }
                throw new QuitNow();
            }
            case 'H': {
                this.htmlMode = !this.htmlMode;
                this.stdprintln("HTML Mode is now set to: " + this.htmlMode);
                return;
            }
            case 'd': {
                if (string3.length() == 2) {
                    this.listTables(string3.charAt(1), string2);
                    return;
                }
                if (string3.length() == 1 && string2 != null) {
                    this.describe(string2);
                    return;
                }
                throw new BadSpecial("Describe commands must be like '\\dX' or like '\\d OBJECTNAME'.");
            }
            case 'o': {
                if (string2 == null) {
                    if (this.pwQuery == null) {
                        throw new BadSpecial("There is no query output file to close");
                    }
                    this.closeQueryOutputStream();
                    return;
                }
                if (this.pwQuery != null) {
                    this.stdprintln("Closing current query output file and opening new one");
                    this.closeQueryOutputStream();
                }
                try {
                    this.pwQuery = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    this.pwQuery.println((this.htmlMode ? "<HTML>\n<!--" : "#") + " " + new Date() + ".  Query output from " + this.getClass().getName() + (this.htmlMode ? ". -->\n\n<BODY>" : ".\n"));
                    this.pwQuery.flush();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to write to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'w': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply a destination file name");
                }
                if (this.commandFromHistory(0).length() == 0) {
                    throw new BadSpecial("Empty command in buffer");
                }
                try {
                    PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2, true), this.charset));
                    printWriter.println(this.commandFromHistory(0) + ';');
                    printWriter.flush();
                    printWriter.close();
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to append to file '" + string2 + "':  " + exception);
                }
                return;
            }
            case 'i': {
                if (string2 == null) {
                    throw new BadSpecial("You must supply an SQL file name");
                }
                try {
                    SqlFile sqlFile = new SqlFile(new File(string2), false, this.userVars);
                    sqlFile.recursed = true;
                    sqlFile.possiblyUncommitteds = this.possiblyUncommitteds;
                    sqlFile.plMode = this.plMode;
                    sqlFile.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException continueException) {
                    throw continueException;
                }
                catch (BreakException breakException) {
                    String string4 = breakException.getMessage();
                    if (string4 != null && !string4.equals("file")) {
                        throw breakException;
                    }
                }
                catch (QuitNow quitNow) {
                    throw quitNow;
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute SQL from file '" + string2 + "':  " + exception.getMessage());
                }
                return;
            }
            case 'p': {
                if (string2 == null) {
                    this.stdprintln(true);
                } else {
                    this.stdprintln(string2, true);
                }
                return;
            }
            case 'a': {
                if (string2 != null) {
                    this.curConn.setAutoCommit(Boolean.valueOf(string2));
                }
                this.stdprintln("Auto-commit is set to: " + this.curConn.getAutoCommit());
                return;
            }
            case '*': {
                if (string2 != null) {
                    this.continueOnError = Boolean.valueOf(string2);
                }
                this.stdprintln("Continue-on-error is set to: " + this.continueOnError);
                return;
            }
            case 's': {
                this.showHistory();
                return;
            }
            case '-': {
                String string5;
                boolean bl2;
                int n = 0;
                boolean bl3 = bl2 = string3.charAt(string3.length() - 1) == ';';
                if (bl2) {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                String string6 = string5 = string3.length() == 1 ? null : string3.substring(1, string3.length());
                if (string5 == null) {
                    n = 0;
                } else {
                    try {
                        n = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new BadSpecial("Malformatted command number");
                    }
                }
                this.setBuf(this.commandFromHistory(n));
                if (bl2) {
                    this.processBuffer(";");
                } else {
                    this.stdprintln("RESTORED following command to buffer.  Enter \":?\" to see buffer commands:\n" + this.commandFromHistory(0));
                }
                return;
            }
            case '?': {
                this.stdprintln(HELP_TEXT);
                return;
            }
            case '!': {
                byte[] byArray = new byte[1024];
                String string7 = (string3.length() == 1 ? "" : string3.substring(1)) + (string3.length() > 1 && string2 != null ? " " : "") + (string2 == null ? "" : string2);
                try {
                    int n;
                    Process process = Runtime.getRuntime().exec(string7);
                    process.getOutputStream().close();
                    InputStream inputStream = process.getInputStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.stdprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    inputStream = process.getErrorStream();
                    while ((n = inputStream.read(byArray)) > 0) {
                        this.errprint(new String(byArray, 0, n));
                    }
                    inputStream.close();
                    if (process.waitFor() != 0) {
                        throw new BadSpecial("External command failed: '" + string7 + "'");
                    }
                }
                catch (Exception exception) {
                    throw new BadSpecial("Failed to execute command '" + string7 + "':  " + exception);
                }
                return;
            }
        }
        throw new BadSpecial("Unknown Special Command");
    }

    private String dereference(String string, boolean bl) throws SQLException {
        int n;
        String string2;
        int n2;
        StringBuffer stringBuffer = new StringBuffer(string);
        if (bl && string.charAt(0) == '*') {
            Iterator iterator = this.userVars.keySet().iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                if (string.equals("*" + string3)) {
                    return (String)this.userVars.get(string3);
                }
                if (!string.startsWith("*" + string3 + ' ') && !string.startsWith("*" + string3 + '\t')) continue;
                stringBuffer.replace(0, string3.length() + 1, (String)this.userVars.get(string3));
                return stringBuffer.toString();
            }
            return string;
        }
        while ((n2 = (string2 = stringBuffer.toString()).indexOf("*{")) >= 0 && (n = string2.indexOf(125, n2 + 2)) >= 0) {
            String string4 = string2.substring(n2 + 2, n);
            if (!this.userVars.containsKey(string4)) {
                throw new SQLException("Use of unset PL variable: " + string4);
            }
            stringBuffer.replace(n2, n + 1, (String)this.userVars.get(string4));
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processPL(String var1_1) throws BadSpecial, SqlToolError, SQLException {
        block59: {
            if (var1_1.length() < 1) {
                this.plMode = true;
                this.stdprintln("PL variable expansion mode is now on");
                return;
            }
            if (var1_1.charAt(0) == '?') {
                this.stdprintln("PROCEDURAL LANGUAGE Commands.  MUST have white space after '*'.\n    * ?                           Help\n    *                             Expand PL variables from now on.\n                                  (this is also implied by all the following).\n    * VARNAME = Variable value    Set variable value (note spaces around =)\n    * VARNAME =                   Unset variable (note space before =)\n    * VARNAME ~                   Set variable value to the value of the very\n                                  next SQL statement executed (see details\n                                  at the bottom of this listing).\n    * list [VARNAME1...]          List values of variable(s) (defaults to all)\n    * foreach VARNAME ([val1...]) Repeat the following PL block with the\n                                  variable set to each value in turn.\n    * if (logical expr)           Execute following PL block only if expr true\n    * while (logical expr)        Repeat following PL block while expr true\n    * end foreach|if|while        Ends a PL block\n    * break [foreach|if|while|file] Exits a PL block or file early\n    * continue [foreach|while]    Exits a PL block iteration early\n\nUse PL variables (which you have set) like: *{VARNAME}.\nYou may omit the {}'s iff *VARNAME is the first word of a SQL command.\nUse PL variables in logical expressions like: *VARNAME.\n\n* VARNAME ~ sets the variable value according to the very next SQL statement:\n    Query:  The value of the first field of the first row returned\n    other:  Return status of the command (for updates this will be\n            the number of rows updated).\n");
                return;
            }
            if (this.plMode) {
                var1_1 = this.dereference(var1_1, false);
            }
            var2_2 = new StringTokenizer(var1_1);
            var3_3 = var2_2.nextToken();
            var4_4 = null;
            this.plMode = true;
            if (this.userVars == null) {
                this.userVars = new HashMap<K, V>();
            }
            if (var3_3.equals("end")) {
                throw new BadSpecial("PL end statements may only occur inside of a PL block");
            }
            if (var3_3.equals("continue")) {
                if (var2_2.hasMoreTokens() == false) throw new ContinueException();
                var5_5 = var2_2.nextToken("").trim();
                if (var5_5.equals("foreach") != false) throw new ContinueException(var5_5);
                if (var5_5.equals("while") == false) throw new BadSpecial("Bad continue statement.You may use no argument or one of 'foreach', 'while'");
                throw new ContinueException(var5_5);
            }
            if (var3_3.equals("break")) {
                if (var2_2.hasMoreTokens() == false) throw new BreakException();
                var5_6 = var2_2.nextToken("").trim();
                if (var5_6.equals("foreach") != false) throw new BreakException(var5_6);
                if (var5_6.equals("if") != false) throw new BreakException(var5_6);
                if (var5_6.equals("while") != false) throw new BreakException(var5_6);
                if (var5_6.equals("file") == false) throw new BadSpecial("Bad break statement.You may use no argument or one of 'foreach', 'if', 'while', 'file'");
                throw new BreakException(var5_6);
            }
            if (var3_3.equals("list")) {
                if (var2_2.countTokens() == 0) {
                    this.stdprint(SqlFile.formatNicely(this.userVars));
                    return;
                }
                var4_4 = SqlFile.getTokenArray(var2_2.nextToken(""));
                var5_7 = 0;
                while (var5_7 < var4_4.length) {
                    this.stdprintln("    " + var4_4[var5_7] + ": (" + this.userVars.get(var4_4[var5_7]) + ')');
                    ++var5_7;
                }
                return;
            }
            if (var3_3.equals("foreach")) {
                if (var2_2.countTokens() < 2) {
                    throw new BadSpecial("Malformatted PL foreach command (1)");
                }
                var5_8 = var2_2.nextToken();
                var6_12 = var2_2.nextToken("").trim();
                if (var6_12.length() < 2) throw new BadSpecial("Malformatted PL foreach command (2)");
                if (var6_12.charAt(0) != '(') throw new BadSpecial("Malformatted PL foreach command (2)");
                if (var6_12.charAt(var6_12.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL foreach command (2)");
                }
                var7_15 = SqlFile.getTokenArray(var6_12.substring(1, var6_12.length() - 1));
                var8_18 = null;
                try {
                    var8_18 = this.plBlockFile("foreach");
                }
                catch (IOException var10_32) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + var10_32);
                }
                var10_33 = (String)this.userVars.get(var5_8);
                try {
                    for (var12_35 = 0; var12_35 < var7_15.length; ++var12_35) {
                        try {
                            var9_37 = var7_15[var12_35];
                            this.userVars.put(var5_8, var9_37);
                            var11_41 = new SqlFile(var8_18, false, this.userVars);
                            var11_41.plMode = true;
                            var11_41.recursed = true;
                            var11_41.possiblyUncommitteds = this.possiblyUncommitteds;
                            var11_41.execute(this.curConn, this.continueOnError);
                            continue;
                        }
                        catch (ContinueException var13_45) {
                            var14_46 = var13_45.getMessage();
                            if (var14_46 == null || var14_46.equals("foreach")) continue;
                            throw var13_45;
                        }
                    }
                }
                catch (BreakException var11_42) {
                    var12_36 = var11_42.getMessage();
                    if (var12_36 != null && !var12_36.equals("foreach")) {
                        throw var11_42;
                    }
                }
                catch (QuitNow var11_43) {
                    throw var11_43;
                }
                catch (Exception var11_44) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + var11_44.getMessage());
                }
                if (var10_33 == null) {
                    this.userVars.remove(var5_8);
                } else {
                    this.userVars.put(var5_8, var10_33);
                }
                if (var8_18 == null) return;
                if (var8_18.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + var8_18 + "'");
            }
            if (var3_3.equals("if")) {
                if (var2_2.countTokens() < 1) {
                    throw new BadSpecial("Malformatted PL if command (1)");
                }
                var5_9 = var2_2.nextToken("").trim();
                if (var5_9.length() < 2) throw new BadSpecial("Malformatted PL if command (2)");
                if (var5_9.charAt(0) != '(') throw new BadSpecial("Malformatted PL if command (2)");
                if (var5_9.charAt(var5_9.length() - 1) != ')') {
                    throw new BadSpecial("Malformatted PL if command (2)");
                }
                var6_13 = SqlFile.getTokenArray(var5_9.substring(1, var5_9.length() - 1));
                var7_16 = null;
                try {
                    var7_16 = this.plBlockFile("if");
                }
                catch (IOException var8_19) {
                    throw new BadSpecial("Failed to write given PL block temp file: " + var8_19);
                }
                try {
                    if (this.eval(var6_13)) {
                        var8_20 = new SqlFile(var7_16, false, this.userVars);
                        var8_20.plMode = true;
                        var8_20.recursed = true;
                        var8_20.possiblyUncommitteds = this.possiblyUncommitteds;
                        var8_20.execute(this.curConn, this.continueOnError);
                    }
                }
                catch (BreakException var8_21) {
                    var9_38 = var8_21.getMessage();
                    if (var9_38 == null) throw var8_21;
                    if (!var9_38.equals("if")) {
                        throw var8_21;
                    }
                }
                catch (ContinueException var8_22) {
                    throw var8_22;
                }
                catch (QuitNow var8_23) {
                    throw var8_23;
                }
                catch (BadSpecial var8_24) {
                    throw new BadSpecial("Malformatted PL if command (3): " + var8_24);
                }
                catch (Exception var8_25) {
                    throw new BadSpecial("Failed to execute SQL from PL block.  " + var8_25.getMessage());
                }
                if (var7_16 == null) return;
                if (var7_16.delete() != false) return;
                throw new BadSpecial("Error occurred while trying to remove temp file '" + var7_16 + "'");
            }
            if (!var3_3.equals("while")) break block59;
            if (var2_2.countTokens() < 1) {
                throw new BadSpecial("Malformatted PL while command (1)");
            }
            var5_10 = var2_2.nextToken("").trim();
            if (var5_10.length() < 2) throw new BadSpecial("Malformatted PL while command (2)");
            if (var5_10.charAt(0) != '(') throw new BadSpecial("Malformatted PL while command (2)");
            if (var5_10.charAt(var5_10.length() - 1) != ')') {
                throw new BadSpecial("Malformatted PL while command (2)");
            }
            var6_14 = SqlFile.getTokenArray(var5_10.substring(1, var5_10.length() - 1));
            var7_17 = null;
            try {
                var7_17 = this.plBlockFile("while");
            }
            catch (IOException var8_26) {
                throw new BadSpecial("Failed to write given PL block temp file: " + var8_26);
            }
            ** try [egrp 6[TRYBLOCK] [13, 14, 15, 16 : 1384->1479)] { 
lbl151:
            // 1 sources

            ** GOTO lbl-1000
        }
        if (var2_2.countTokens() < 1) {
            throw new BadSpecial("Unknown PL command (1)");
        }
        var5_11 = var2_2.nextToken();
        if (var5_11.length() != 1) {
            throw new BadSpecial("Unknown PL command (2)");
        }
        switch (var5_11.charAt(0)) {
            case '~': {
                if (var2_2.countTokens() > 0) {
                    throw new BadSpecial("PL ~ set command takes no other args");
                }
                this.userVars.remove(var3_3);
                this.fetchingVar = var3_3;
                return;
            }
            case '=': {
                if (var2_2.countTokens() == 0) {
                    this.userVars.remove(var3_3);
                    return;
                }
                this.userVars.put(var3_3, var2_2.nextToken("").trim());
                return;
            }
        }
        throw new BadSpecial("Unknown PL command (3)");
lbl-1000:
        // 3 sources

        {
            while (this.eval(var6_14)) {
                try {
                    var8_27 = new SqlFile(var7_17, false, this.userVars);
                    var8_27.recursed = true;
                    var8_27.possiblyUncommitteds = this.possiblyUncommitteds;
                    var8_27.plMode = true;
                    var8_27.execute(this.curConn, this.continueOnError);
                }
                catch (ContinueException var9_39) {
                    var10_34 = var9_39.getMessage();
                    if (var10_34 == null || var10_34.equals("while")) continue;
                    throw var9_39;
                }
            }
        }
lbl188:
        // 1 sources

        catch (BreakException var8_28) {
            var9_40 = var8_28.getMessage();
            if (var9_40 != null && !var9_40.equals("while")) {
                throw var8_28;
            }
        }
lbl193:
        // 1 sources

        catch (QuitNow var8_29) {
            throw var8_29;
        }
lbl195:
        // 1 sources

        catch (BadSpecial var8_30) {
            throw new BadSpecial("Malformatted PL while command (3): " + var8_30);
        }
lbl197:
        // 1 sources

        catch (Exception var8_31) {
            throw new BadSpecial("Failed to execute SQL from PL block.  " + var8_31.getMessage());
        }
        if (var7_17 == null) return;
        if (var7_17.delete() != false) return;
        throw new BadSpecial("Error occurred while trying to remove temp file '" + var7_17 + "'");
    }

    private File plBlockFile(String string) throws IOException, SqlToolError {
        int n = 1;
        if (string == null || !string.equals("foreach") && !string.equals("if") && !string.equals("while")) {
            throw new RuntimeException("Assertion failed.  Unsupported PL block type:  " + string);
        }
        File file = File.createTempFile("sqltool-", ".sql");
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.charset));
        printWriter.println("/* " + new Date() + ". " + this.getClass().getName() + " PL block. */\n");
        while (true) {
            String string2;
            if ((string2 = this.br.readLine()) == null) {
                this.errprintln("Unterminated '" + string + "' PL block");
                throw new SqlToolError("Unterminated '" + string + "' PL block");
            }
            ++this.curLinenum;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() > 1 && stringTokenizer.nextToken().equals("*")) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(string)) {
                    ++n;
                } else if (string3.equals("end")) {
                    if (stringTokenizer.countTokens() < 1) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (1)");
                        throw new SqlToolError("PL end statement requires arg  of 'foreach' or 'if' or 'while' (1)");
                    }
                    String string4 = stringTokenizer.nextToken();
                    if (string4.equals(string) && --n < 1) break;
                    if (!(string4.equals("foreach") || string4.equals("if") || string4.equals("while"))) {
                        this.errprintln("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                        throw new SqlToolError("PL end statement requires arg of 'foreach' or 'if' or 'while' (2)");
                    }
                }
            }
            printWriter.println(string2);
        }
        printWriter.flush();
        printWriter.close();
        return file;
    }

    private void stdprintln() {
        this.stdprintln(false);
    }

    private void stdprint(String string) {
        this.stdprint(string, false);
    }

    private void stdprintln(String string) {
        this.stdprintln(string, false);
    }

    private void stdprintln(boolean bl) {
        if (this.htmlMode) {
            this.psStd.println("<BR>");
        } else {
            this.psStd.println();
        }
        if (bl && this.pwQuery != null) {
            if (this.htmlMode) {
                this.pwQuery.println("<BR>");
            } else {
                this.pwQuery.println();
            }
            this.pwQuery.flush();
        }
    }

    private void errprint(String string) {
        this.psErr.print(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void errprintln(String string) {
        this.psErr.println(this.htmlMode ? "<DIV style='color:white; background: red; font-weight: bold'>" + string + "</DIV>" : string);
    }

    private void stdprint(String string, boolean bl) {
        this.psStd.print(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.print(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void stdprintln(String string, boolean bl) {
        this.psStd.println(this.htmlMode ? "<P>" + string + "</P>" : string);
        if (bl && this.pwQuery != null) {
            this.pwQuery.println(this.htmlMode ? "<P>" + string + "</P>" : string);
            this.pwQuery.flush();
        }
    }

    private void listTables(char c, String string) throws SQLException, BadSpecial {
        int[] nArray = null;
        String[] stringArray = null;
        DatabaseMetaData databaseMetaData = this.curConn.getMetaData();
        String string2 = databaseMetaData.getDatabaseProductName();
        Object var7_7 = null;
        if (c != '*') {
            stringArray = new String[1];
            switch (c) {
                case 's': {
                    stringArray[0] = "SYSTEM TABLE";
                    break;
                }
                case 'a': {
                    stringArray[0] = "ALIAS";
                    break;
                }
                case 't': {
                    stringArray[0] = "TABLE";
                    break;
                }
                case 'v': {
                    stringArray[0] = "VIEW";
                    break;
                }
                default: {
                    throw new BadSpecial("Unknown describe option: '" + c + "'");
                }
            }
        }
        nArray = string2.indexOf("HSQL") > -1 ? listMDTableCols[1] : (string2.indexOf("Oracle") > -1 ? listMDTableCols[2] : listMDTableCols[0]);
        this.displayResultSet(null, databaseMetaData.getTables(null, null, null, stringArray), nArray, string);
    }

    private void processSQL() throws SQLException {
        Statement statement = this.curConn.createStatement();
        this.possiblyUncommitteds.set(true);
        statement.execute(this.plMode ? this.dereference(this.curCommand, true) : this.curCommand);
        this.displayResultSet(statement, statement.getResultSet(), null, null);
    }

    private void displayResultSet(Statement statement, ResultSet resultSet, int[] nArray, String string) throws SQLException {
        String string2 = string == null ? null : string.toUpperCase();
        int n = statement == null ? -1 : statement.getUpdateCount();
        switch (n) {
            case -1: {
                int n2;
                String[] stringArray;
                int n3;
                boolean bl;
                int n4;
                int n5;
                if (resultSet == null) {
                    this.stdprintln("No result", true);
                    break;
                }
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                int n6 = resultSetMetaData.getColumnCount();
                int n7 = nArray == null ? n6 : nArray.length;
                ArrayList<String[]> arrayList = new ArrayList<String[]>();
                String[] stringArray2 = null;
                int[] nArray2 = new int[n7];
                if (!this.htmlMode) {
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = 0;
                    }
                }
                boolean[] blArray = new boolean[n7];
                if (n7 > 1) {
                    n5 = -1;
                    stringArray2 = new String[n7];
                    for (n4 = 1; n4 <= n6; ++n4) {
                        if (nArray != null) {
                            bl = true;
                            for (n3 = 0; n3 < nArray.length; ++n3) {
                                if (n4 != nArray[n3]) continue;
                                bl = false;
                            }
                            if (bl) continue;
                        }
                        stringArray2[++n5] = resultSetMetaData.getColumnLabel(n4);
                        String string3 = resultSetMetaData.getColumnTypeName(n4);
                        boolean bl2 = blArray[n5] = string3.equals("INTEGER") || string3.equals("NUMBER");
                        if (this.htmlMode || stringArray2[n5].length() <= nArray2[n5]) continue;
                        nArray2[n5] = stringArray2[n5].length();
                    }
                }
                while (resultSet.next()) {
                    stringArray = new String[n7];
                    n5 = -1;
                    n4 = string2 != null ? 1 : 0;
                    for (n3 = 1; n3 <= n6; ++n3) {
                        String string4 = resultSet.getString(n3);
                        if (this.fetchingVar != null) {
                            this.userVars.put(this.fetchingVar, string4);
                            this.fetchingVar = null;
                        }
                        if (nArray != null) {
                            bl = true;
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                if (n3 != nArray[n2]) continue;
                                bl = false;
                            }
                            if (bl) continue;
                        }
                        if (string4 == null && !resultSet.wasNull()) {
                            string4 = "NON-CONVERTIBLE TYPE!";
                        }
                        if (string2 != null && string4.toUpperCase().indexOf(string2) > -1) {
                            n4 = 0;
                        }
                        String string5 = string4 == null ? (this.htmlMode ? "<I>null</I>" : "null") : (stringArray[++n5] = string4);
                        if (this.htmlMode || stringArray[n5].length() <= nArray2[n5]) continue;
                        nArray2[n5] = stringArray[n5].length();
                    }
                    if (n4 != 0) continue;
                    arrayList.add(stringArray);
                }
                this.condlPrintln("<TABLE border='1'>", true);
                if (stringArray2 != null) {
                    this.condlPrint(SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
                    for (n3 = 0; n3 < stringArray2.length; ++n3) {
                        this.condlPrint("<TD>" + stringArray2[n3] + "</TD>", true);
                        this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n3], nArray2[n3], blArray[n3], n3 < stringArray2.length - 1 || blArray[n3]), false);
                    }
                    this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                    this.condlPrintln("", false);
                    if (!this.htmlMode) {
                        for (n3 = 0; n3 < stringArray2.length; ++n3) {
                            this.condlPrint((n3 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray2[n3]), false);
                        }
                        this.condlPrintln("", false);
                    }
                }
                for (n3 = 0; n3 < arrayList.size(); ++n3) {
                    this.condlPrint(SqlFile.htmlRow(n3 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
                    stringArray = (String[])arrayList.get(n3);
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.condlPrint("<TD>" + stringArray[n2] + "</TD>", true);
                        this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n2], nArray2[n2], blArray[n2], n2 < stringArray.length - 1 || blArray[n2]), false);
                    }
                    this.condlPrintln("\n" + PRE_TR + "</TR>", true);
                    this.condlPrintln("", false);
                }
                this.condlPrintln("</TABLE>", true);
                if (arrayList.size() != 1) {
                    this.stdprintln("\n" + arrayList.size() + " rows", true);
                }
                this.condlPrintln("<HR>", true);
                break;
            }
            default: {
                if (this.fetchingVar != null) {
                    this.userVars.put(this.fetchingVar, Integer.toString(n));
                    this.fetchingVar = null;
                }
                if (n == 0) break;
                this.stdprintln(Integer.toString(n) + " row" + (n == 1 ? "" : "s") + " updated");
            }
        }
    }

    private static String htmlRow(int n) {
        switch (n) {
            case 0: {
                return PRE_TR + "<TR style='font-weight: bold;'>";
            }
            case 1: {
                return PRE_TR + "<TR style='background: #94d6ef; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
            case 2: {
                return PRE_TR + "<TR style='background: silver; font: normal " + "normal 10px/10px Arial, Helvitica, sans-serif;'>";
            }
        }
        return null;
    }

    private static String divider(int n) {
        return n > DIVIDER.length() ? DIVIDER : DIVIDER.substring(0, n);
    }

    private static String spaces(int n) {
        return n > SPACES.length() ? SPACES : SPACES.substring(0, n);
    }

    private static String pad(String string, int n, boolean bl, boolean bl2) {
        if (!bl2) {
            return string;
        }
        int n2 = n - string.length();
        if (n2 < 1) {
            return string;
        }
        String string2 = SqlFile.spaces(n2);
        return (bl ? string2 : "") + string + (bl ? "" : string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void showHistory() {
        String[] stringArray;
        int n;
        block17: {
            block16: {
                block15: {
                    n = -1;
                    stringArray = new String[this.statementHistory.length];
                    try {
                        String string;
                        int n2;
                        for (n2 = this.curHist; n2 >= 0; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                Object var6_5 = null;
                                if (n < 0) {
                                    this.stdprintln("<<<    No history yet    >>>");
                                    return;
                                }
                                break block15;
                            }
                            stringArray[++n] = string;
                        }
                        for (n2 = this.statementHistory.length - 1; n2 > this.curHist; --n2) {
                            string = this.statementHistory[n2];
                            if (string == null) {
                                break block16;
                            }
                            stringArray[++n] = string;
                        }
                        break block17;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        if (n < 0) {
                            this.stdprintln("<<<    No history yet    >>>");
                            return;
                        }
                        int n3 = n;
                        while (true) {
                            if (n3 < 0) {
                                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                                throw throwable;
                            }
                            this.psStd.println((n3 == 0 ? "BUFR" : "-" + n3 + "  ") + " **********************************************\n" + stringArray[n3]);
                            --n3;
                        }
                    }
                }
                for (int i = n; i >= 0; --i) {
                    this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
                }
                this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
                return;
            }
            Object var6_6 = null;
            if (n < 0) {
                this.stdprintln("<<<    No history yet    >>>");
                return;
            }
            for (int i = n; i >= 0; --i) {
                this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
            }
            this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
            return;
        }
        Object var6_7 = null;
        if (n < 0) {
            this.stdprintln("<<<    No history yet    >>>");
            return;
        }
        for (int i = n; i >= 0; --i) {
            this.psStd.println((i == 0 ? "BUFR" : "-" + i + "  ") + " **********************************************\n" + stringArray[i]);
        }
        this.psStd.println("\n<<<  Copy a command to buffer like \"\\-3\"       Re-execute buffer like \":;\"  >>>");
    }

    private String commandFromHistory(int n) throws BadSpecial {
        if (n >= this.statementHistory.length) {
            throw new BadSpecial("History can only hold up to " + this.statementHistory.length + " commands");
        }
        String string = this.statementHistory[(this.statementHistory.length + this.curHist - n) % this.statementHistory.length];
        if (string == null) {
            throw new BadSpecial("History doesn't go back that far");
        }
        return string;
    }

    private void setBuf(String string) {
        ++this.curHist;
        if (this.curHist == this.statementHistory.length) {
            this.curHist = 0;
        }
        this.statementHistory[this.curHist] = string;
    }

    private void describe(String string) throws SQLException {
        int n;
        String[] stringArray;
        int n2;
        Statement statement = this.curConn.createStatement();
        statement.execute("SELECT * FROM " + string + " WHERE 1 = 2");
        ResultSet resultSet = statement.getResultSet();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n3 = resultSetMetaData.getColumnCount();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        String[] stringArray2 = new String[]{"name", "datatype", "width", "no-nulls"};
        int[] nArray = new int[]{0, 0, 0, 0};
        boolean[] blArray = new boolean[]{false, false, true, false};
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            if (this.htmlMode || stringArray2[n2].length() <= nArray[n2]) continue;
            nArray[n2] = stringArray2[n2].length();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray = new String[4];
            stringArray[0] = resultSetMetaData.getColumnName(n2 + 1);
            stringArray[1] = resultSetMetaData.getColumnTypeName(n2 + 1);
            stringArray[2] = Integer.toString(resultSetMetaData.getColumnDisplaySize(n2 + 1));
            stringArray[3] = resultSetMetaData.isNullable(n2 + 1) == 1 ? (this.htmlMode ? "&nbsp;" : "") : "*";
            arrayList.add(stringArray);
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].length() <= nArray[n]) continue;
                nArray[n] = stringArray[n].length();
            }
        }
        this.condlPrint("<TABLE border='1'>\n" + SqlFile.htmlRow(0) + '\n' + PRE_TD, true);
        for (n2 = 0; n2 < stringArray2.length; ++n2) {
            this.condlPrint("<TD>" + stringArray2[n2] + "</TD>", true);
            this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray2[n2], nArray[n2], blArray[n2], n2 < stringArray2.length - 1 || blArray[n2]), false);
        }
        this.condlPrintln("\n" + PRE_TR + "</TR>", true);
        this.condlPrintln("", false);
        if (!this.htmlMode) {
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                this.condlPrint((n2 > 0 ? SqlFile.spaces(2) : "") + SqlFile.divider(nArray[n2]), false);
            }
            this.condlPrintln("", false);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            this.condlPrint(SqlFile.htmlRow(n2 % 2 == 0 ? 2 : 1) + '\n' + PRE_TD, true);
            stringArray = (String[])arrayList.get(n2);
            for (n = 0; n < stringArray.length; ++n) {
                this.condlPrint("<TD>" + stringArray[n] + "</TD>", true);
                this.condlPrint((n > 0 ? SqlFile.spaces(2) : "") + SqlFile.pad(stringArray[n], nArray[n], blArray[n], n < stringArray.length - 1 || blArray[n]), false);
            }
            this.condlPrintln("\n" + PRE_TR + "</TR>", true);
            this.condlPrintln("", false);
        }
        this.condlPrintln("\n</TABLE>\n<HR>", true);
    }

    public static String[] getTokenArray(String string) {
        String[] stringArray = new String[]{};
        if (string == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringTokenizer.nextToken();
        }
        return stringArray2;
    }

    private boolean eval(String[] stringArray) throws BadSpecial {
        boolean bl = stringArray.length > 0 && stringArray[0].equals("!");
        String[] stringArray2 = new String[bl ? stringArray.length - 1 : stringArray.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            String string = stringArray[i + (bl ? 1 : 0)].length() > 1 && stringArray[i + (bl ? 1 : 0)].charAt(0) == '*' ? (String)this.userVars.get(stringArray[i + (bl ? 1 : 0)].substring(1)) : (stringArray2[i] = stringArray[i + (bl ? 1 : 0)]);
            if (stringArray2[i] != null) continue;
            stringArray2[i] = "";
        }
        if (stringArray2.length == 1) {
            return (stringArray2[0].length() > 0 && !stringArray2[0].equals("0")) ^ bl;
        }
        if (stringArray2.length == 3) {
            if (stringArray2[1].equals("==")) {
                return stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals("!=") || stringArray2[1].equals("<>") || stringArray2[1].equals("><")) {
                return !stringArray2[0].equals(stringArray2[2]) ^ bl;
            }
            if (stringArray2[1].equals(">")) {
                return (stringArray2[0].length() > stringArray2[2].length() || stringArray2[0].length() == stringArray2[2].length() && stringArray2[0].compareTo(stringArray2[2]) > 0) ^ bl;
            }
            if (stringArray2[1].equals("<")) {
                return (stringArray2[2].length() > stringArray2[0].length() || stringArray2[2].length() == stringArray2[0].length() && stringArray2[2].compareTo(stringArray2[0]) > 0) ^ bl;
            }
        }
        throw new BadSpecial("Unrecognized logical operation");
    }

    private void closeQueryOutputStream() {
        if (this.pwQuery == null) {
            return;
        }
        if (this.htmlMode) {
            this.pwQuery.println("</BODY></HTML>");
            this.pwQuery.flush();
        }
        this.pwQuery.close();
        this.pwQuery = null;
    }

    private void condlPrintln(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.println(string);
        if (this.pwQuery != null) {
            this.pwQuery.println(string);
            this.pwQuery.flush();
        }
    }

    private void condlPrint(String string, boolean bl) {
        if (bl && !this.htmlMode || this.htmlMode && !bl) {
            return;
        }
        this.psStd.print(string);
        if (this.pwQuery != null) {
            this.pwQuery.print(string);
            this.pwQuery.flush();
        }
    }

    private static String formatNicely(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = new TreeMap(map).keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append("    " + string + ": (" + map.get(string) + ")\n");
        }
        return stringBuffer.toString();
    }

    static {
        revnum = "$Revision: 1.88 $".substring("$Revision: ".length(), "$Revision: 1.88 $".length() - 2);
        BANNER = "(SqlFile processor v. " + revnum + ")\n" + "Distribution is permitted under the terms of the HSQLDB license.\n" + "(c) 2004 Blaine Simpson and the HSQLDB Development Group.\n\n" + "    \\q    to Quit.\n" + "    \\?    lists Special Commands.\n" + "    :?    lists Buffer/Editing commands.\n" + "    * ?   lists PL commands (including alias commands).\n\n" + "SPECIAL Commands begin with '\\' and execute when you hit ENTER.\n" + "BUFFER Commands begin with ':' and execute when you hit ENTER.\n" + "COMMENTS begin with '/*' and end with the very next '*/'.\n" + "PROCEDURAL LANGUAGE commands begin with '* ' and end when you hit ENTER.\n" + "All other lines comprise SQL Statements.\n" + "  SQL Statements are terminated by either a blank line (which moves the\n" + "  statement into the buffer without executing) or a line ending with ';'\n" + "  (which executes the statement).\n";
        listMDTableCols = new int[][]{{2, 3}, {3}, {2, 3}};
        PRE_TR = SqlFile.spaces(4);
        PRE_TD = SqlFile.spaces(8);
    }

    private class BadSwitch
    extends Exception {
        private BadSwitch(int n) {
            super(Integer.toString(n));
        }
    }

    private class ContinueException
    extends SqlToolError {
        public ContinueException() {
        }

        public ContinueException(String string) {
            super(string);
        }
    }

    private class BreakException
    extends SqlToolError {
        public BreakException() {
        }

        public BreakException(String string) {
            super(string);
        }
    }

    private class QuitNow
    extends SqlToolError {
        public QuitNow(String string) {
            super(string);
        }

        public QuitNow() {
        }
    }

    private class BadSpecial
    extends Exception {
        private BadSpecial(String string) {
            super(string);
        }
    }

    private static class BooleanBucket {
        private boolean bPriv = false;

        private BooleanBucket() {
        }

        public void set(boolean bl) {
            this.bPriv = bl;
        }

        public boolean get() {
            return this.bPriv;
        }
    }
}

