
open Syntax
open Location


(* ------------------------------------------------------------
 * Errors
 * ------------------------------------------------------------ *)

val mfatal : metadata -> string -> 'a
val pfatal : metadata -> Prettyutil.pretty -> 'a
val mwarning : metadata -> string -> unit
val pwarning : metadata -> Prettyutil.pretty -> unit
val pmsg : Prettyutil.pretty -> unit


(* ------------------------------------------------------------
 * Ids
 * ------------------------------------------------------------ *)

val strid : string -> id
val strvar : string -> expression

val id_str : id -> string
val id_meta : id -> metadata
val id_span : id -> span 
val noid : id

val id_equal : id -> id -> bool


(* ------------------------------------------------------------
 * Prefixes and suffixes
 * ------------------------------------------------------------ *)

val add_prefix : string -> string -> string

val id_add_suffix : id -> string -> id
val id_add_prefix : id -> string -> id

val id_strip_prefix : string -> id -> id
val id_strip_suffix : string -> id -> id

val id_is_prefix : string -> id -> bool


(* ------------------------------------------------------------
 * Types
 * ------------------------------------------------------------ *)

val tywild : id -> typ
val tyvoid : typ
val tybool : typ
val tyint : typ

val typ_name_nocheck : typ -> id
val typ_args_nocheck : typ -> typ list

val typ_mods : typ -> declmod list
val typ_core : typ -> coretyp 

val is_tagged_typ : typ -> bool
val is_closure_typ : typ -> bool
val is_function_typ : typ -> bool
val is_wild_typ : typ -> bool
val is_basic_typ : typ -> bool

val coretyp_equal : coretyp -> coretyp -> bool

val tyiface_id : tyiface -> id

val insert_specs: specqual list -> specqual list -> specqual list

(* ------------------------------------------------------------
* Free type variables
* ------------------------------------------------------------ *)

val decl_freevars : declaration -> id list
val typ_freevars : typ -> id list


(* ------------------------------------------------------------
* Unpack declarations
* ------------------------------------------------------------ *)

val is_simpledecl : declaration -> bool
val simpledecl_name : declaration -> id
val simpledecl_typ : declaration -> typ
val simpledecl_init : declaration -> initialiser option

val split_fundecl : declaration -> (id * typ * argdetails * funkind)
val fundef_decl : fundef -> declaration

val decl_names : declaration -> id list
val init_names : init_declarator -> id list


(* ------------------------------------------------------------
 * Equality
 * ------------------------------------------------------------ *)

val dictenv_equal : dictenv -> dictenv -> bool


(* ------------------------------------------------------------
 * Translation stuff 
 * ------------------------------------------------------------ *)

val as_dictmethod : id -> id -> tyiface list -> declaration -> declaration
val strip_tyargs : declmod list -> declmod list
val decl_strip_parens : decl -> decl


(* ------------------------------------------------------------
 * Bulitin operators
 * ------------------------------------------------------------ *)

val builtin_ops : string list
val builtin_prefix_ops : string list
val builtin_postfix_ops : string list

val builtin_twoint_ops : string list
val builtin_intcmp_ops : string list
val builtin_oneint_ops : string list
val builtin_twobool_ops : string list
val builtin_onebool_ops : string list
val builtin_ptrcmp_ops : string list


(* ------------------------------------------------------------
 * Pretty printing stuff
 * ------------------------------------------------------------ *)

val strip_typ_extras : typ -> typ
val trim_postfix_op : string -> string
