
open Location
open Prettyutil


(* function calls 
 * 
 * Pretty much everything is a function call.
 * This includes while, for, operators, constructors,
 * and even array operations *)


type id = metadata * string


(* ------------------------------------------------------------
 * Statements
 * ------------------------------------------------------------ *)

and stmt = 
	| Label of id * statement
	| SExp of expression
	| Block of block
	| Switch of expression * statement 
	| Case of pattern * statement
	| If of expression * statement * statement option
	| While of expression * statement
	| Do of statement * expression
	| For of expression option * expression option * 
			 expression option * statement
	| Jump of jumpdetails
	| Semicolon

and statement = metadata * stmt
	
and jumpdetails = 
	| JBreak | JContinue 
	| JReturn of expression option | JGoto of id	
	| JRet of expression option
	
and block = declaration list * statement list

and pattern =
	| PTag of id * id option
	| PDefault
	| PConst of expression

(* ------------------------------------------------------------
 * Expressions
 * ------------------------------------------------------------ *)
(* TODO: tidy up tinit by separating from parse type *)

and const = 
	| ConstInt of string	
	| ConstFloat of string
	| ConstString of string
	| ConstSizeTy of typ
	| ConstSizeExp of expression
	| ConstAlignTy of typ
	| ConstAlignExp of expression
	
and expr = 
	| JklNonDet of key * expression list * expression
	| LocalFun of declaration list * block
	| FunCall of expression * expression list
	| Var of id
	| Field of bool * expression * id
	| Const of const
	| Cast of typ * expression
	| Index of expression * expression
	| Choice of expression * expression * expression
	| Assign of expression * string * expression
	| Parens of expression
	| Init of tinitialiser
	| Unsafe of expression
	| EBlock of block
	
and expression = metadata * expr

and tinit =
	| TConApp of id * expression option 
	| TStruct of (string * expression) list
	| TAlloc of memkind * expression
	
and tinitialiser = metadata * tinit
	
and memkind = New | Malloc


(* ------------------------------------------------------------
 * Types
 * ------------------------------------------------------------ *)
	
and specqual = 
    | SStatic | SExtern | SAuto | SRegister | SInline
	| SChar | SShort | SInt | SLong | SFloat | SDouble 
	| SSigned | SUnsigned 
	| SConst | SVolatile | SCoreHere
	| STypeDef | STaggedOnly

and structkind = SKStruct | SKUnion | SKTagged
and structdetails = metadata * id list * declaration list	
and enumdetails = (id * expression option) list	

and coretyp = 
	| TyBasic	(* determined purely by specifiers *)
	| TyWild of id
	| TyVoid
	| TyName of id
	| TyStruct of structkind * id option * structdetails option
	| TyEnum of id option * enumdetails option
	| TyTypeofExp of bool * expression
	| TyTypeofTyp of bool * typ
			
and basetyp = specqual list * coretyp

and argdetails = 
	| ArgsFull of metadata * tyiface list * declaration list
	| ArgsNamed of id list
	| ArgsNoinfo 


and funkind = 
	| VarArgs 	
	| SimpleFun
	| Closure
	| IfaceMethod
	| DictMethod of (id * id) option

(* type modifiers attached to the id declaration *)
and declmod = 
	| DPtr of specqual list			(* a pointer to *)
	| DFatPtr of specqual list		(* a fat pointer to *)
	| DArray of expression option		(* an array of *)
	| DBitField of expression		(* a bitfield of *)
	| DFun of argdetails * funkind		(* a function returning *)
	| DWithArgs of typ list 		(* these typ args applied to *)
	| DParens					

and typ = specqual list * coretyp * declmod list


(* ------------------------------------------------------------
 * Various util types
 * ------------------------------------------------------------ *)

and dictbody = 
	| DictProto of tyiface list 
	| DictImpl of tyiface list * (metadata * fundef) list

and fundef = declaration * declaration list * block
and funsig = declaration
and funcall = expression * expression list
and tyiface = id * ifacespec 		(* typ var, interface *)
and ifacedef = id * funsig list
and dictdecl = typ * ifacespec * tyiface list
and dictdef = typ * ifacespec * dictbody
and dictproto = tyiface list * typ * ifacespec 
and declarator = declmod list * id option	
and init_declarator = declarator * initialiser option
and decl = basetyp * init_declarator list
and declaration = metadata * decl

(* an instantiation of a named interface *)
and ifacespec = id

and defdetails =
	| DKOpaque of string	(* a complex #define that we don't understand *)
	| DKConst of const * string	(* a simple constant #define *)
	| DKUndef of string
	| DKEmpty of string

and initialiser =
	| IExp of expression
	| IFields of initialiser list * bool

(* ------------------------------------------------------------
 * Metadata attached to syntax elements
 * ------------------------------------------------------------ *)

and localfuninfo = {funname : namevar; envname : namevar;
			strname : namevar; envvars : (string * typ) list}

and lamdef = metadata * declaration list * block

and tag = 
	| HasType of typ				(* C type of a var *)
	| BodyTy of typ				(* the type of the body of a pattern *)
	| LocalFunInfo of localfuninfo	
	| DictArgs of impl list
	| CallDict of impl * string
	| DictEnvs of (string * id * id * dictenv) list
	| Scrutinee of expression 
	| ReturnType of typ
	| OpName of string
	| Envarg of envarg
	| EnvVar 
	| EnvName of string
	| SharedPretty of pretty option ref
	| Temps of tinitialiser list
	| TempName of namevar
	| LamEnvs of localfuninfo list
	| FwdDecls of (namevar * typ) list
	| TempDecls of (namevar * typ) list
	| Lambdas of lamdef list
	| FieldName of string
	| Hidden
	| DictProtos of declaration list
	| IfaceProtos of declaration list
	| FunEnv of string
	| NeedsCast of typ	 (* needs to be cast to this type *)
	| ArgTys of typ list (* expected types for function args *)
	| ClosureVar 		(* var is a function closure *)
	| Lang of lang		(* language of the file this extdecl came from *)
	| MaybeHidden of key	(* 0 -> hidden, 1 -> not hidden *)
	| AlreadyExpanded

and lang = PureC | Jekyll | EncodedC

and envarg = EnvOpaque | EnvDict of id * id
	
and metadata = {span : Location.span; 
				mutable tags : tag list}


(* ------------------------------------------------------------
 * Top Level Declarations
 * ------------------------------------------------------------ *)

and extdecl = 
	| Include of string
	| Interface of id * ifacedef
	| Dict of dictdef
	| Decl of declaration	
	| Func of fundef
	| MacroType of macrokind
	| StdType of declaration
	| NonDet of key * extdeclaration list * extdeclaration
	| DSemicolon

and extdeclaration = metadata * extdecl

and dictarg = {dictname : string; dictenv : string}

and macrokind =
	| MDecl of declaration
	| MSilent of id list | MSilentFun of id list


and program = extdeclaration list	


(* ------------------------------------------------------------
 * Representation of a dictionary
 * ------------------------------------------------------------ *)

(* a dictionary, used to implement an interface for a type *)
(* name of the dict is derived automatically, here we provide
 * the names of the extra dicts to be passed as args to this dict *)
and dictkind =
	| DictArg		
	| DictEnv
	| DictThis
	| DictGlobal of string option

(* an implementation of an interface by a type *)
and impl = ifacespec * id * dictkind	

and dictenv = (tyiface * impl) list
	


