open Syntaxutil
open Errors
open Util
open Metadata

module SS = Data.StringCols.Set


let name_envvar = "_env"

(* the name of the tagged type that a tag is part of *)
let get_tagged_typename m = "???"

(* get the namespace prefix of an ID *)
let id_prefix _ = ""

(* get the local name part of an ID *)
let id_name (_,s) = s

(* get the full name of an ID *)
let id_fullname (_,s) = s

(* TODO: automatically ensure names are unique by adding suffixes if
 * they clash with others in the namespace *)

let name_dict tyid ifaceid =
		"_dm" ^ id_fullname ifaceid ^ "_" ^ id_fullname tyid
let name_dictenv tyid ifaceid =
		"_de" ^ id_fullname ifaceid ^ "_" ^ id_fullname tyid 

let name_tag_selector id = id_prefix id ^ "IS_" ^ id_name id
let name_tag_const id = get_tagged_typename id ^ id_name id
let name_iface_dy id = id_fullname id ^ "_dynamic"
let name_get_inner = "GET_INNER"
let name_enum_tag id = id_fullname id ^ "_tag"
let name_iface id = id_fullname id
let name_argdict var iface = id_fullname var ^ "_" ^ id_name iface
let name_method tyname iface methodname = 
	id_fullname tyname ^ "_" ^ id_name methodname
let name_tagged id = id_fullname id
let name_jkl_tyvar id = "%" ^ id_fullname id
let name_c_tyvar id = "void"
let name_funenv id = "_fe_" ^ id_str id
let name_temp s = "_tmp" ^ s
let name_dicttemp s = "_dt" ^ s

let is_dict_name id = id_is_prefix "_dm" id
let is_dictenv_name id = id_is_prefix "_de" id
let is_dicttemp_name id = id_is_prefix "_dt" id
let is_dictnull_name id = id_str id = "_DNULL"
let is_funtemp_name id = id_is_prefix "_ft" id
let is_lambda_name id = id_is_prefix "_ff" id
let is_funenv_name id = id_is_prefix "_fe" id
let is_temp_name id = id_is_prefix "_t" id
let is_tagged_name id = id_is_prefix "_t" id
let is_iface_name id = id_is_prefix "_i" id
let is_thisenv_name id = id_str id = "_env"
let is_tyvar_name id = id_is_prefix "_v" id
let is_cons_name id = 
	let firstchar = String.get (id_str id) 0 in
	Char.uppercase firstchar = firstchar

let is_env_name id = 		
		is_dict_name id || is_dictenv_name id || 
		is_funtemp_name id || is_thisenv_name id ||
		is_dictnull_name id || is_funenv_name id ||
		is_dicttemp_name id

let strip_iface_name id = id_strip_prefix "_i" id

let split_tycontext_name (m,s) = 
	try 
		Scanf.sscanf s "_dm%[^'_']_%[^'_']"
		(fun iname varname -> Some ((m,varname),(cpm m,iname)))
	with _ -> None
	
		

let is_operator_name opname = match String.get opname 0 with
	| '+' | '-' | '<' | '>' | '&' | '*' | '=' | '%' | '^' | '|' 
	| '$' | '?' | '!' | '/' | '~' -> true
	| _ -> false

let untagged_name id = 
	if not (is_tagged_name id) then begin
		error (id_span id) ("Name of a tagged struct must start with '_t'");  
		id
	end else
		id_strip_prefix "_t" id
let untagged_nameo ido = option_apply untagged_name ido

let name_untagged id = id_strip_prefix "_t" id

let basetyp_names : SS.t = SS.of_list 
		["int";"char";"long";"longlong";"float";"double"]
let is_basetyp_name str = SS.mem str basetyp_names
let is_envvar_name id = (snd id = name_envvar)
let is_tag_name id = id_str id = "_tag"
let is_body_name id = id_str id = "_body"
