#include <jekyll_1.h>

#include "basictypes.h"
#include <stdio.h>

extern void error(int err);
extern void error_string (string str);
extern string concat_string(string a, string b);


typedef struct List List;

/* test for equality */
struct Eq{
	bool (* equals)(void* _env,void* x, void* y);
};

/* display as a string */
struct Show{
	string (* show)(void* _env,void *x);
};

struct Ordering{
    enum{GT, EQ, LT} _tag; union {
    } _body;
} ;

/* order elements */
struct Ord{
	struct Ordering (* compare)(void* _env,void* x, void* y);
};

/* can enumerate through them */
struct Enum{
	void (* succ)(void* _env,void *x);
	void (* pred)(void* _env,void *x);
	void (* toEnum)(void* _env,void *x);
	int (* fromEnum)(void* _env,void *x);
	List (* enumFromTo)(void* _env,void *start, void *end);
};

struct Bounded{
	void (* minBound)(void* _env);
	void (* maxBound)(void* _env);
};

/* convertable to and from an integer */
struct Num{
	void (* plus)(void* _env,void *x, void *y);
	void (* minus)(void* _env,void *x, void *y);
	void (* negate)(void* _env,void *x);
	void (* abs)(void* _env,void* x);
	void (* fromInteger)(void* _env,int x);
};

typedef struct Rational Rational;

struct Real{
	Rational (* toRational)(void* _env,void* x);
};

/* has standard integer operations */
struct Integral{
	/* quotient and remainder */
	void* (* quot)(void* _env,void *x, void *y);
	void* (* rem)(void* _env,void *x, void *y);	
	
	int (* toInteger)(void* _env,void *x);	
};


void subtract(struct Num* _dmNum_a , void* _deNum_a,void *x, void *y){
	return _dmNum_a-> minus(_deNum_a,x,y);
}


/* skip a few boring arithmetic bits */

struct Functor{
	void* (* map)(void* _env,void* fun(void* _env,void* x), void* _fe_fun, void* collection);
};

/* Haskell-stype monads */
struct Monad{
	void* (* bind)(void* _env,void *first, void* fun(void* _env,void* arg), void* _fe_fun);
	void* (* unit)(void* _env,void *result);
};

void foldr(void fun(void* arg, void* env), void* init, List* list);
void foldl(void fun(void* env, void* arg), void* init, List* list);

/* TODO: implement "sequence", once I%ve worked out what it does */

void *flip(void* fun(void *x,void *y), void *y, void *x){
	return fun(x,y);
}



typedef struct Node Node;

struct Node{
	void *element;
	List *tail;
};	

/* TODO: check all used types are well formed */
struct List{
    enum{NODE, EMPTY} _tag; union {
	Node NODE;
	} _body;
};

extern struct Show _dmShow_List;
struct _deShow_List {
    struct Show* _dmShow_a; void* _deShow_a;
};
    string List_show(struct _deShow_List* _env, struct List *x);

/* Implement the Show interface for List */
struct Show _dmShow_List = {
    (void*)&List_show
	};

	/* Turn a list into a string */
	string List_show(struct _deShow_List* _env,struct List *x){
		switch((*x)._tag){
		    Node node;
			case NODE : node =(*x)._body.NODE; {
				return concat_string(_env->_dmShow_a->
					show(_env->_deShow_a,node.element),_dmShow_List.
					show(_env,node.tail));
			}
			case EMPTY:
				return "";
		}
	}


struct List wibble;

extern struct Functor _dmFunctor_List;
    struct List * List_map(void* _env, void *fun(void* _env, void *x), void* _fe_fun, struct List *collection);

/* implement the map function for lists */
struct Functor _dmFunctor_List = {
    (void*)&List_map
	};
	List* List_map(void* _env,void* fun(void* _env,void* x), void* _fe_fun, List* collection){
		switch ((*collection)._tag){
		    List *_tmp0;
		    Node node;
			case EMPTY:
			_tmp0 =(List *) GC_malloc (sizeof(List ));
			_tmp0->_tag= EMPTY; return _tmp0;
			case NODE : node =(*collection)._body.NODE; {
			    List *_tmp0;
			    _tmp0 =(List *) GC_malloc (sizeof(List ));
			    _tmp0->_tag= NODE;
			    _tmp0->_body.NODE.element =fun(_fe_fun,node.element);
			    _tmp0->_body.NODE.tail =List_map(_DNULL,fun,_fe_fun,node.tail);
				return _tmp0;
			}
		}
	}

List* append(List* x, List* y){
	switch ((*x)._tag){
	    Node node;
		case EMPTY: return y;
		case NODE : node =(*x)._body.NODE; {
		    List *_tmp0;
		    _tmp0 =(List *) GC_malloc (sizeof(List ));
		    _tmp0->_tag= NODE;
		    _tmp0->_body.NODE.element =node.element;
		    _tmp0->_body.NODE.tail =append(node.tail,y);
			return _tmp0;
		}
	}
}

List* concat(List* ls){
	switch ((*ls)._tag){
	    List *_tmp0;
	    Node node;
		case EMPTY:
		_tmp0 =(List *) GC_malloc (sizeof(List ));
		_tmp0->_tag= EMPTY; return _tmp0;
		case NODE : node =(*ls)._body.NODE; {
			return append(node.element,concat(node.tail));
		}
	}
	
}

extern struct Monad _dmMonad_List;
    struct List * List_bind(void* _env, struct List *first, struct List *fun(void* _env, void *arg), void* _fe_fun);
    struct List * List_unit(void* _env, void *result);

struct Monad _dmMonad_List = {
    (void*)&List_bind, (void*)&List_unit
	};
	List* 
	List_bind(void* _env,List* first, List* fun(void* _env,void *arg), void* _fe_fun){
		List*  results = List_map(_DNULL, (void*)fun,_fe_fun,first);
		return concat(results);
	}
	
	List* 
	List_unit(void* _env,void* result){
	    List *_tmp0;
	    _tmp0 =(List *) GC_malloc (sizeof(List ));
	    _tmp0->_tag= NODE;
	    _tmp0->_body.NODE.element =result;
	    _tmp0->_body.NODE.tail =(List *)GC_malloc (sizeof(List ));
	    _tmp0->_body.NODE.tail->_tag= EMPTY;
		return _tmp0;
	}

string showsomething(struct Show* _dmShow_z , void* _deShow_z,void *thing){
	return _dmShow_z-> show(_deShow_z,thing);
}

/* basic C entry point */
int main(int argc, char* argv[]){
	printf("hello world\n");
	return 0;
}
