#compdef highlight

_highlight() {
  local -a options=(
    {-B,--batch-recursive}"[convert all matching files, searches subdirs (example\: -B '*.cpp')]: :_files"
    {-D,--data-dir}"[set path to data directory]: :_files"
    "--config-file[set path to a lang or theme file]: :_files"
    {-d,--outdir}"[name of output directory]: :_files"
    "-h[print help and exit]"
    "--help[print help or a topic description]: :(syntax theme plugin config test lsp)"
    {-i,--input}"[name of single input file]: :_files"
    {-o,--output}"[name of single output file]: :_files"
    {-P,--progress}"[print progress bar in batch mode]"
    {-q,--quiet}"[suppress progress info in batch mode]"
    {-S,--syntax}"[specify type of source code or syntax file path]: :_files"
    "--syntax-by-name[specify type of source code by given name]: :_files"
    "--syntax-supported[test if the given syntax can be loaded]"
    "*"{-v,--verbose}"[print debug info; repeat to show more information]"
    "--force[generate output if input syntax is unknown]: :_files"
    "--list-scripts[list installed scripts with given type]: :(langs themes plugins)"
    "--list-cat[filter the scripts by the given categories (example\: --list-cat='source;script')]: :_files"
    "--max-size[set maximum input file size (examples\: 512M, 1G; default\: 256M)]: :_files"
    "*--plug-in[execute Lua plug-in script; repeat option to execute multiple plug-ins]: :_files"
    "--plug-in-param[set plug-in input parameter]: :_files"
    "--print-config[print path configuration]"
    "--print-style[print stylesheet only (see --style-outfile)]"
    "--skip[ignore listed unknown file types (Example\: --skip='bak;c~;h~')]: :_files"
    "--stdout[output to stdout (batch mode, --print-style)]"
    "--validate-input[test if input is text, remove Unicode BOM]"
    "--version[print version and copyright information]"
    {-O,--out-format}"[output file in given format]: :(html xhtml latex tex odt rtf ansi xterm256 truecolor bbcode pango svg)"
    {-c,--style-outfile}"[name of style file or print to stdout, if 'stdout' is given as file argument]: :_files"
    {-e,--style-infile}"[to be included in style-outfile (deprecated) use a plug-in file instead]: :_files"
    {-f,--fragment}"[omit document header and footer]"
    {-F,--reformat}"[reformats and indents output in given style]: :(allman gnu google horstmann java kr linux lisp mozilla otbs pico vtk ratliff stroustrup webkit whitesmith)"
    {-I,--include-style}"[include style definition in output file]"
    {-J,--line-length}"[line length before wrapping (see -V, -W)]: :_files"
    {-j,--line-number-length}"[line number width incl]: :_files"
    "--line-range[output only lines from number <start> to <end>]: :_files"
    {-k,--font}"[set font (specific to output format)]: :_files"
    {-K,--font-size}"[set font size (specific to output format)]: :_files"
    {-l,--line-numbers}"[print line numbers in output file]"
    {-m,--line-number-start}"[start line numbering with cnt (assumes -l)]: :_files"
    {-s,--style}"[set colour style (theme) or theme file path]: :_files"
    {-t,--replace-tabs}"[replace tabs by <num> spaces]: :_files"
    {-T,--doc-title}"[document title]: :_files"
    {-u,--encoding}"[set output encoding which matches input file encoding; omit encoding info if set to NONE]: :_files"
    {-V,--wrap-simple}"[wrap lines after 80 (default) characters w/o indenting function parameters and statements]"
    {-W,--wrap}"[wrap lines after 80 (default) characters]"
    "--wrap-no-numbers[omit line numbers of wrapped lines (assumes -l)]"
    {-z,--zeroes}"[pad line numbers with 0's]"
    "--isolate[output each syntax token separately (verbose output)]"
    "--keep-injections[output plug-in injections in spite of -f]"
    "--kw-case[change case of case insensitive keywords to given case]: :(upper lower capitalize)"
    "--no-trailing-nl[omit trailing newline]: :(empty-file)"
    "--no-version-info[omit version info comment]"
    {-a,--anchors}"[attach anchor to line numbers]"
    {-y,--anchor-prefix}"[set anchor name prefix]: :_files"
    {-N,--anchor-filename}"[use input file name as anchor prefix]"
    {-C,--print-index}"[print index with hyperlinks to output files]"
    {-n,--ordered-list}"[print lines as ordered list items]"
    "--class-name[set CSS class name prefix; omit class name if set to NONE]: :_files"
    "--inline-css[output CSS within each tag (verbose output)]"
    "--enclose-pre[enclose fragmented output with pre tag (assumes -f)]"
    {-b,--babel}"[disable Babel package shorthands]"
    {-r,--replace-quotes}"[replace double quotes by \dq{}]"
    "--beamer[adapt output for the Beamer package]"
    "--pretty-symbols[improve appearance of brackets and other symbols]"
    "--page-color[include page color attributes]"
    {-x,--page-size}"[set page size]: :(a3 a4 a5 b4 b5 b6 letter)"
    "--char-styles[include character stylesheets]"
    "--height[set image height (units allowed)]"
    "--width[set image width (see --height)]"
    "--canvas[set background colour padding (default\: 80)]: :_files"
    "--ls-profile[read LSP configuration from lsp.conf]: :_files"
    "--ls-delay[set server initialization delay]: :_files"
    "--ls-exec[set server executable name]: :_files"
    "*--ls-option[set server CLI option (can be repeated)]: :_files"
    "--ls-hover[execute hover requests (HTML output only)]"
    "--ls-semantic[retrieve semantic token types (requires LSP 3.16)]"
    "--ls-syntax[set syntax which is understood by the server]: :_files"
    "--ls-syntax-error[retrieve syntax error information (assumes --ls-hover or --ls-semantic)]"
    "--ls-workspace[set workspace directory to init]: :_files"
  )
  _arguments -s -S \
    $options \
    "*: :_files" \
    && return 0

  return 1
}

_highlight
