@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem    Created:   Scott Wegner, 9/17/07
rem    Modified:  Scott Wegner, 5/23/08
rem

setlocal enabledelayedexpansion
pushd %~dp0

rem a relative name
set h5toh4=h5toh4
rem an absolute command path
set h5toh4_bin=%CD%\%1\%h5toh4%

set rm=del /f

set h4diff=%hdf4_path%\bin\hdiff.exe

rem Verify if %h4diff% is a valid command
if exist %h4diff% (
    set tmpfile=testh5toh4.tmp
    %h4diff% -H > !tmpfile!
    if not exist !tmpfile! (
        echo.    Could not run the H4DIFF command. The test can still proceed
        echo.    but it may fail if H4DIFF is needed to verify the output.
        echo.    You can make sure H4DIFF is among your shell PATH and run
        echo.    the test again. You may also visit http://hdfgroup.org
        echo.    or email help@hdfgroup.org for more information.
        set h4diff=
        sets h4diffver=0
    )
    %rm% !tmpfile! 2> nul
) else (
    echo.    Could not run the H4DIFF command. The test can still proceed
    echo.    but it may fail if H4DIFF is needed to verify the output.
    echo.    You can make sure H4DIFF is among your shell PATH and run
    echo.    the test again. You may also visit http://hdfgroup.org
    echo.    or email help@hdfgroup.org for more information.
    set h4diff=
    sets h4diffver=0
)

if not exist ..\testfiles mkdir ..\testfiles

set srcdir=%CD%\..\testfiles
set outdir=%CD%\..\testfiles\Results

if not exist %outdir% mkdir %outdir%
set tmpfile=%outdir%\tmp.txt

set /a nerrors=0
set verbose=yes

goto main


rem Print a line-line message left justified in a field of 70 characters
rem beginning with the word "Testing".
rem
:testing
    set test_msg=Testing
    for %%a in (%*) do (
        if %%a neq PASSED (
        if %%a neq *FAILED* (
            set test_msg=!test_msg! %%~nxa
        ) )
    )
    set test_msg=!test_msg!                                                                
    echo.%test_msg:~0,69% %1
    
    exit /b
    
    
rem Run a test and print PASS or *FAIL*.  If a test fails then increment
rem the `nerrors' global variable and (if %verbose% is set) display the
rem difference between the actual and the expected hdf4 files. The
rem expected hdf5 files are in testfiles/Expected directory.
rem The actual hdf5 file is not removed if %HDF5_NOCLEANUP% is to a non-null
rem value.
:convert
    rem Run h5toh4 convert.
    
    rem
    rem Set up arguments to run the conversion test.
    rem The converter assumes all hdf4 files has the .hdf suffix as in the form
    rem of foo.hdf.  It creates the corresponding hdf5 files with the .h5 suffix
    rem as in the form of foo.h5.  One exception is that if exactly two file
    rem names are given, it treats the first argument as an hdf4 file and creates
    rem the corresponding hdf5 file with the name as the second argument, WITHOUT
    rem any consideration of the suffix.  (For this test script, in order to
    rem match the output hdf5 file with the expected hdf5 file, it expects the
    rem second file of the two-files tests has the .h5 suffix too.)
    rem
    rem If SRCDIR != OUTDIR, need to copy the input hdf4 files from the SRCDIR
    rem to the OUTDIR and transform the input file pathname because of the suffix
    rem convention mentioned above.  This way, the hdf5 files are always created
    rem in the OUTDIR directory.
    rem
    
    set infiles=
    set outfiles=
    set multirun=
    set root=
    
    rem On Windows, the shift command isn't effective with %*.  Also, we don't
    rem have $# as Linux does.  So, iterate through parameters and declare
    rem params, to achieve this functionality.  --SJW 9/13/07
    set numparams=0
    set params=
    for %%a in (%*) do (
        if "!params!"=="" (
            set params=%%a
        ) else (
            set params=!params! %%a
        )
        set /a numparams=!numparams!+1
    )

    if "%1"=="-m" (
        rem multiple files conversion
        set multirun=-m
        rem On Windows, shift command doesn't effect %*, so we manipulate
        rem params variable manually.  --SJW 9/17/07
        set params=!params:* =!
        for %%a in (!params!) do (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%%a %outdir%\%%a > nul
            )
            set infiles=!infiles! %%a
            set outfiles=!outfiles! %%~na!root!.hdf
            set params=!params:* =!
        )
    ) else (
        rem Single file conversion
        if "!numparams!"=="1" (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%~n1!root!.hdf
            
        ) else if "!numparams!"=="2" (
            rem hdf4 file specified
            if "%2"=="-r" (
                set root=-r
                if not "%srcdir%"=="%outdir%" (
                    copy /y %srcdir%\%1 %outdir%\%1 > nul
                )
                set infiles=%1
                set outfiles=%~n1!root!.hdf
            ) else (
                if not "%srcdir%"=="%outdir%" (
                    copy /y %srcdir%\%1 %outdir%\%1 > nul
                )
                set infiles=%1
                set outfiles=%2
            )
            
        ) else if "!numparams!"=="3" (
            rem "-r" specified?
            if not "%2"=="-r" (
                echo.Illegal arguments
                exit /b 1
            )
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%~n3!root!.hdf
            set root=-r
            
        ) else (
            rem Illegal
            echo.Illegal arguments
            exit /b 1
        )
    )

    rem run the conversion and remove input files that have been copied over
    if defined root (
        (
            pushd %outdir%
            %h5toh4_bin% %infiles% %root% %outfiles% 2>nul
            if not "%srcdir%"=="%outdir%" (
                %rm% %infiles%
            )
            popd
        )
    ) else (
        (
            pushd %outdir%
            %h5toh4_bin% %multirun% %infiles% 2>nul
            if not "%srcdir%"=="%outdir%" (
                %rm% %infiles%
            )
            popd
        )
    )
        
    rem Verify results
    for %%a in (%outfiles%) do (
        fc %srcdir%\Expected\%%a %outdir%\%%a > nul
        if !errorlevel! neq 0 (
            rem Use hdiff to compare the HDF4 files
            set outfile=%%~na
            set expect_out=!outfile!.expect
            set actual_out=!outfile!.actual
            
            if not defined h4diff (
                call :testing PASSED %h5toh4% %*
            ) else (
                %h4diff% %srcdir%\Expected\!outfile!.hdf %outdir%\!outfile!.hdf
                if !errorlevel! neq 0 (
                    call :testing *FAILED* %h5toh4% %*
                    set /a nerrors=!nerrors!+1
                ) else (
                call :testing PASSED %h5toh4% %*
                )
            )
        )
        
        rem Clean up output file
        if not defined hdf5_nocleanup (
            %rm% !expect_out! !actual_out! 2> nul
            %rm% %outdir%\%%a
        )
    )
    
rem    if "%result%"=="passed" (
rem        call :testing PASSED %h5toh4% %*
rem    )
   
    
    exit /b

rem ############################################################################
rem ############################################################################
rem #                       T H E   T E S T S                                ###
rem ############################################################################
rem ############################################################################
:main

    %rm% %outdir%\*.hdf %outdir%\*.tmp 2> nul

    rem
    rem The HDF4 filenames are created based upon the HDF5 filenames
    rem without the extension.
    rem

    rem test for call :converting H5 groups to H4 Vgroups.
    call :convert tgroup.h5

    rem test for call :converting H5 datasets to H4 SDS's.
    call :convert tdset.h5

    rem test for call :converting H5 attributes to H4 attributes.
    call :convert tattr.h5

    rem test for call :converting H5 soft links.
    call :convert tslink.h5

    rem test for call :converting H5 hard links.
    call :convert thlink.h5

    rem test for call :converting H5 compound data type to H4 Vdata.
    call :convert tcompound.h5

    rem test for call :converting all H5 objects at in same file.
    call :convert tall.h5

    rem tests for call :converting H5 objects with loops.
    call :convert tloop.h5

    rem test for call :converting extendable H5 datasets to H4 SDS's.
    call :convert tdset2.h5

    rem test for call :converting extendable H5 datasets with compound data type to H4 Vdata.
    call :convert tcompound2.h5

    rem tests for call :converting H5 objects from many different pathways.
    call :convert tmany.h5

    rem tests for call :converting H5 string objects.
    call :convert tstr.h5

    rem tests for call :converting more H5 string objects.
    call :convert tstr2.h5
    call :convert timage.h5
    call :convert ttable.h5
    call :convert tsds_attr.h5
    call :convert tsds_dim.h5


    rem
    rem The test for conversion are the same as above with the only difference
    rem being that the HDF4 filenames are given explicitly.
    rem

    %rm% %outdir%\*.tmp 2>nul
    call :convert tgroup.h5 tgroup.hdf
    call :convert tdset.h5 tdset.hdf
    call :convert tattr.h5 tattr.hdf
    call :convert tslink.h5 tslink.hdf
    call :convert thlink.h5 thlink.hdf
    call :convert tcompound.h5 tcompound.hdf
    call :convert tall.h5 tall.hdf
    call :convert tloop.h5 tloop.hdf
    call :convert tdset2.h5 tdset2.hdf
    call :convert tcompound2.h5 tcompound2.hdf
    call :convert tmany.h5 tmany.hdf
    call :convert tstr.h5 tstr.hdf
    call :convert tstr2.h5 tstr2.hdf
    call :convert timage.h5 timage.hdf
    call :convert ttable.h5 ttable.hdf
    call :convert tsds_attr.h5 tsds_attr.hdf
    call :convert tsds_dim.h5 tsds_dim.hdf

    rem
    rem Again, the test for conversion are the same as the first set of test.
    rem Here, multiple conversion are done on HDF5 files at one time.
    rem

    %rm% %outdir%\*.hdf %outdir%\*.tmp 2> nul
    call :convert -m tgroup.h5 tdset.h5 tattr.h5 tslink.h5 thlink.h5
    call :convert -m tcompound.h5 tall.h5
    call :convert -m tloop.h5
    call :convert -m tdset2.h5 tcompound2.h5 tmany.h5
    call :convert -m tstr.h5 tstr2.h5
    %rm% %outdir%\*.hdf %outdir%\*.tmp 2> nul
    call :convert tgroup.h5 -r 
    call :convert tdset.h5 -r
    call :convert tattr.h5 -r
    call :convert tslink.h5 -r
    call :convert thlink.h5 -r
    call :convert tcompound.h5 -r
    call :convert tall.h5 -r
    call :convert tloop.h5 -r
    call :convert tdset2.h5 -r
    call :convert tcompound2.h5 -r
    call :convert tmany.h5 -r
    call :convert tstr.h5 -r
    call :convert tstr2.h5 -r
    call :convert timage.h5 -r
    call :convert ttable.h5 -r
    call :convert tsds_attr.h5 -r
    call :convert tsds_dim.h5 -r

    %rm% %outdir%\*.hdf %outdir%\*.tmp 2> nul
    call :convert tgroup.h5 -r tgroup-r.hdf
    call :convert tdset.h5 -r tdset-r.hdf
    call :convert tattr.h5 -r tattr-r.hdf
    call :convert tslink.h5 -r tslink-r.hdf
    call :convert thlink.h5 -r thlink-r.hdf
    call :convert tcompound.h5 -r tcompound-r.hdf
    call :convert tall.h5 -r tall-r.hdf
    call :convert tloop.h5 -r tloop-r.hdf
    call :convert tdset2.h5 -r tdset2-r.hdf
    call :convert tcompound2.h5 -r tcompound2-r.hdf
    call :convert tmany.h5 -r tmany-r.hdf
    call :convert tstr.h5 -r tstr-r.hdf
    call :convert tstr2.h5 -r tstr2-r.hdf
    call :convert timage.h5 -r timage-r.hdf
    call :convert ttable.h5 -r ttable-r.hdf
    call :convert tsds_attr.h5 -r tsds_attr-r.hdf
    call :convert tsds_dim.h5 -r tsds_dim-r.hdf

    rem to do: -m and -r together
    if "%nerrors%"=="0" (
        echo.All h5toh4 tests passed.
    )
    
    if not defined hdf5_nocleanup (
        %rm% %tmpfile% 2> nul
        rmdir /s /q %outdir%
    )
   
:end   
    popd
    endlocal & exit /b %nerrors%
    
