@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem
rem Purpose:
rem
rem Test script for the h4toh5 tests.
rem
rem Using the h4toh5 convert to convert a pre-created hdf file to an hdf5
rem file (output file), then compare it with a pre-created corresponding
rem hdf5 file (expected file). If the same, that particular test passes.
rem If not the same, the output file and expected file are processed by
rem the h5dump tool to see if they produce the same results. If the same,
rem the test passes. If not, show the difference of the two results and
rem report the test failed.
rem

rem
rem h5diff is default to use the one in your PATH.  It can be overridden
rem by setting %h5diff% to a different value.
rem
rem    Created:  Scott Wegner, 9/17/07
rem    Modified:  Scott Wegner, 5/23/08
rem

setlocal enabledelayedexpansion
pushd %~dp0

rem *********************************************************************
rem     Change these values if you are not using the default filters
rem *********************************************************************
call :setfilter H5_USE_FILTER_SZIP          yes
call :setfilter H5_USE_FILTER_SZIP_ENCODE   yes
call :setfilter H5_USE_FILTER_ZLIB          yes
call :setfilter H4_USE_FILTER_SZIP          yes
rem *********************************************************************
rem     You shouldn't need to edit anything else below this line
rem *********************************************************************



rem the tool name
set h4toh5=h4toh5%2
rem the path of the tool binary
set h4toh5_bin=%CD%\%1\%h4toh5%
set h5path=%hdf5_path%\bin
set h5szip=%h5_use_filter_szip%
set h5szip_encode=%h5_use_filter_szip_encode%
set h5zlib=%h5_use_filter_zlib%
set h4szip=%h4_use_filter_szip%
rem this is set when h4h5check is called, via the "enableeos" parameter
set h5_use_hdfeos2=%h4h5_eos_conditional%

set rm=del /f

set h5diff=%h5path%\h5diff.exe

rem Verify if %h5diff% is a valid command
if not exist %h5diff% (
    echo.    Could not run the 'H5DIFF' command. The test can still proceed
    echo.    but it may fail if 'H5DIFF' is needed to verify the output.
    echo.    You can make sure 'H5DIFF' is among your environment PATH and run
    echo.    the test again. You may also visit http://hdfgroup.org
    echo.    or email help@hdfgroup.org for more information.
    set h5diff=
)

if not exist ..\testfiles mkdir ..\testfiles

set srcdir=%CD%\..\testfiles
set outdir=%CD%\..\testfiles\Results

if not exist %outdir% mkdir %outdir%

set /a nerrors=0
set verbose=yes

goto main

rem Print a line-line message left justified in a field of 70 characters
rem beginning with the word "Testing".
rem
:testing
    set test_msg=Testing
    for %%a in (%*) do (
        if %%a neq PASSED (
        if %%a neq *FAILED* (
            set test_msg=!test_msg! %%~nxa
        ) )
    )
    set test_msg=!test_msg!                                                                
    echo.%test_msg:~0,69% %1
    
    exit /b
    

rem Print a message indicating that a test was skipped
:skip
    call :testing -SKIP- %h5toh5% %*
    
    exit /b
    
    
rem Run a test and print PASS or *FAIL*.  If a test fails then increment
rem the `nerrors' global variable and (if %verbose% is set) display the
rem difference between the actual and the expected hdf4 files. The
rem expected hdf5 files are in testfiles/Expected directory.
rem The actual hdf5 file is not removed if %HDF5_NOCLEANUP% is to a non-null
rem value.
:convert
    rem Run h4toh5convert
    
    rem
    rem Set up arguments to run the conversion test.
    rem The converter assumes all hdf4 files has the .hdf suffix as in the form
    rem of foo.hdf.  It creates the corresponding hdf5 files with the .h5 suffix
    rem as in the form of foo.h5.  One exception is that if exactly two file
    rem names are given, it treats the first argument as an hdf4 file and creates
    rem the corresponding hdf5 file with the name as the second argument, WITOUT
    rem any consideration of the suffix.  (For this test script, in order to
    rem match the output hdf5 file with the expected hdf5 file, it expects the
    rem second file of the two-files tests has the .h5 suffix too.)
    rem
    rem If SRCDIR != OUTDIR, need to copy the input hdf4 files from the SRCDIR
    rem to the OUTDIR and transform the input file pathname because of the suffix
    rem convention mentioned above.  This way, the hdf5 files are always created
    rem in the OUTDIR directory.
    rem
    
    set infiles=
    set outfiles=
    set multirun=
    set h4toh5opt=
    set shouldfail=
    set h4toh5failed=
    
    rem On Windows, the shift command isn't effective with %*.  Also, we don't
    rem have $# as Linux does.  So, iterate through parameters and declare
    rem params, to achieve this functionality.  --SJW 9/13/07
    set numparams=0
    set params=
    for %%a in (%*) do (
        if "!params!"=="" (
            set params=%%a
        ) else (
            set params=!params! %%a
        )
        set /a numparams=!numparams!+1
    )

    if "%1"=="-m" (
        rem multiple files conversion
        set multirun=-m
        rem On Windows, shift command doesn't effect %*, so we manipulate
        rem params variable manually.  --SJW 9/17/07
        set params=!params:* =!
        for %%a in (!params!) do (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%%a %outdir%\%%a > nul
            )
            set infiles=!infiles %%a!
            set outfiles=!outfiles %%~na.h5
            set params=!params:* =!
        )
        
        
    ) else if "%1"=="-e" (
        rem HDF-EOS2 file conversion
        rem On Windows, use only the first "substring" of the second parameter
        rem as our outpath.  In the tests below, it is always the case that the
        rem relative path is one subdirectory.  Thus, we can look for this
        rem --SJW 5/23/08
        for /f "tokens=1 delims=\" %%a in ("%2") do (
            set outpath=%%a
        )

        if not "%srcdir%"=="%outdir%" (
            if not exist %outdir%\!outpath! (
                mkdir %outdir%\!outpath!
            )
            copy %srcdir%\%2 %outdir%\%2 > nul
        )
        set infiles=%2
        set outfiles=%3
        set h4toh5opt=-eos -nc4 -nc4strict

    ) else if "%1"=="-f" (
        rem HDF-EOS2 file conversion that should fail
        set shouldfail=yes
        
        rem HDF-EOS2 file conversion
        rem On Windows, use only the first "substring" of the second parameter
        rem as our outpath.  In the tests below, it is always the case that the
        rem relative path is one subdirectory.  Thus, we can look for this
        rem --SJW 5/23/08
        for /f "tokens=1 delims=\" %%a in ("%2") do (
            set outpath=%%a
        )

        if not "%srcdir%"=="%outdir%" (
            if not exist %outdir%\!outpath! (
                mkdir %outdir%\!outpath!
            )
            copy %srcdir%\%2 %outdir%\%2 > nul
        )
        set infiles=%2
        set outfiles=%3
        set h4toh5opt=-eos -nc4 -nc4strict
    
    ) else (
        rem Single file conversion
        if "!numparams!"=="1" (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%~n1.h5
            
        ) else if "!numparams!"=="2" (
            rem hdf4 file specified
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%2
        
        ) else (
            rem Illegal
            echo.Illegal arguments
            exit /b 1
        )
    )

    rem run the conversion and remove input files that have been copied over
    pushd .
    (
        cd %outdir%
        %h4toh5_bin% %h4toh5opt% %infiles% %outfiles% 2>nul
        if !errorlevel! neq 0 (
            if "%shouldfail%"=="yes" (
                set forcesuccess=yes
            )
            set h4toh5failed=yes
        )
        if not "%srcdir%"=="%outdir%" (
            %rm% %infiles% 2> nul
        )
        
        if "!h4toh5failed!"=="yes" (
            if "!forcesuccess!"=="yes" (
                call :testing PASSED !h4toh5_bin:%CD%=! %*
            ) else (
                call :testing *FAILED* !h4toh5_bin:%CD%=! %*
                set /a nerrors=!nerrors!+1
            )
        ) else (
            set needcmp=yes
        )
    )
    popd
    
    if not "%h4toh5failed%"=="yes" (
        rem Verify results
        set result=passed
        for %%a in (%outfiles%) do (
            fc %srcdir%\Expected\%%a %outdir%\%%a > nul 2>&1
            if !errorlevel! neq 0 (
                rem Use h5diff to compare the HDF5 files.
                rem Now, testfiles directory has subdirectories
                rem set outfile=%%~na
                set outfile=%%a
                set expect_out=!outfile!.expect
                set actual_out=!outfile!.actual
                
                if not defined h5diff (
                    call :testing PASSED !h4toh5_bin:%CD%=! %*
                ) else ( 
                    %h5diff% %srcdir%\Expected\!outfile! %outdir%\!outfile! > nul
                    if !errorlevel! neq 0 (
                        call :testing *FAILED* !h4toh5_bin:%CD%=! %*
                        set /a nerrors=!nerrors!+1
                    ) else (
                        call :testing PASSED !h4toh5_bin:%CD%=! %*
                    )
                )
            )
            
            rem Clean up output file
            if not defined h4h5_nocleanup (
                %rm% !expect_out! !actual_out! 2> nul
                %rm% %outdir%\%%a 2> nul
            )
        )
    )
    
    exit /b

    
    
rem Helper function to set filter flags on Windows.  Other platforms use
rem configure flags, but we don't have that option in Windows.  Users will
rem need to manually edit this batch script or set these environment variables
rem to disable filters.
rem
rem Expected options:
rem     %1      Flag to set
rem     %2      Either "yes" or "no"
:setfilter
    if not defined %1 set %1=%2
    exit /b
    
    
rem ############################################################################
rem ############################################################################
rem #                          T H E   T E S T S                             ###
rem ############################################################################
rem ############################################################################
:main

    rem
    rem The HDF5 filenames are created based upon the HDF4 filenames
    rem without the extension.
    rem

    rem test for converting H5 groups to H4 Vgroups.
    rem CONVERT vg.hdf


    rem
    rem The test for conversion are the same as above with the only difference
    rem being that the HDF5 filenames are given explicitly.
    rem

    %rm% %outdir%\*.tmp 2>nul
    call :convert anno_test.hdf anno_test.h5
    call :convert gr_typ_test.hdf gr_typ_test.h5
    call :convert grnameclash_test.hdf grnameclash_test.h5

    rem Windows doesn't have OR logic as part of its if statement, so
    rem we combine all of these and check to make sure they are all true.
    rem --SJW 9/17/07
    if not "%h5szip% %h5szip_encode% %h5zlib% %h4szip%"=="yes yes yes yes" (
       call :skip gr_comp_test.hdf gr_comp_test.h5
    ) else (
       call :convert gr_comp_test.hdf gr_comp_test.h5  
    )

    call :convert image_attr_test.hdf image_attr_test.h5
    rem call :convert image_maxsize.hdf image_maxsize.h5
    call :convert ras24il.hdf ras24il.h5
    call :convert ras_24_test.hdf ras_24_test.h5
    call :convert ras_8_test.hdf ras_8_test.h5
    call :convert sds_attr_test.hdf sds_attr_test.h5
    call :convert sds_dim_test.hdf sds_dim_test.h5
    call :convert sds_typ_test.hdf sds_typ_test.h5
    call :convert sdsnameclash_test.hdf sdsnameclash_test.h5

    if not "%h5szip% %h5szip_encode% %h5zlib% %h4szip%"=="yes yes yes yes" (
       call :skip sds_comp_test.hdf sds_comp_test.h5
    ) else (
       call :convert sds_comp_test.hdf sds_comp_test.h5
    )

    call :convert vdata_test.hdf vdata_test.h5
    call :convert vdnameclash_test.hdf vdnameclash_test.h5
    call :convert vg_hl_test.hdf vg_hl_test.h5
    call :convert vg_loop_test.hdf vg_loop_test.h5
    call :convert vgnameclash_test.hdf vgnameclash_test.h5
    call :convert vg_all_test.hdf vg_all_test.h5
    rem
    rem Again, the test for conversion are the same as the first set of test.
    rem Here, multiple conversion are done on HDF4 files at one time.
    rem

    %rm% %outdir%\*.hdf %outdir%\*.tmp 2>nul
    rem call :convert -m vg.hdf
    
    rem test HDF-EOS2 conversion
    if defined h5_use_hdfeos2 (
        
        rem Be sure to convert the path syntax here to use Windows-style.  i.e,
        rem convert the slashes to backslashes.  --SJW 5/23/08
        call :convert -e grid\grid_geo_xy.hdf grid\grid_geo_xy.h5
        call :convert -e grid\grid_geo_yx.hdf grid\grid_geo_yx.h5
        call :convert -e grid\grid_geo_timexy.hdf grid\grid_geo_timexy.h5
        call :convert -e grid\grid_geo_timeyx.hdf grid\grid_geo_timeyx.h5
        call :convert -e grid\grid_utm_xy.hdf grid\grid_utm_xy.h5
        call :convert -e grid\grid_utm_yx.hdf grid\grid_utm_yx.h5
        call :convert -e grid\grid_utm_timexy.hdf grid\grid_utm_timexy.h5
        call :convert -e grid\grid_utm_timeyx.hdf grid\grid_utm_timeyx.h5
        call :convert -e grid\grid_geo_xyxy.hdf grid\grid_geo_xyxy.h5
        call :convert -e grid\grid_geo_yxyx.hdf grid\grid_geo_yxyx.h5
        call :convert -f grid\grid_geo_xyyx.hdf grid\grid_geo_xyyx.h5
        call :convert -f grid\grid_geo_nil.hdf grid\grid_geo_nil.h5
        call :convert -e grid\grid_utm_xyxy.hdf grid\grid_utm_xyxy.h5
        call :convert -e grid\grid_utm_yxyx.hdf grid\grid_utm_yxyx.h5
        call :convert -f grid\grid_utm_xyyx.hdf grid\grid_utm_xyyx.h5
        call :convert -f grid\grid_utm_nil.hdf grid\grid_utm_nil.h5
        call :skip grid\grid_multgrids.hdf grid\grid_multgrids.h5
        call :convert -e swath\swath_basic.hdf swath\swath_basic.h5
        call :convert -e swath\swath_0101.hdf swath\swath_0101.h5
        call :convert -e swath\swath_1111.hdf swath\swath_1111.h5
        call :convert -e swath\swath_2121.hdf swath\swath_2121.h5
        call :convert -e swath\swath_n11n11.hdf swath\swath_n11n11.h5
        call :convert -e swath\swath_n11n11_tight.hdf swath\swath_n11n11_tight.h5
        call :convert -e swath\swath_n21n21.hdf swath\swath_n21n21.h5
        call :convert -e swath\swath_0202.hdf swath\swath_0202.h5
        call :convert -e swath\swath_1212.hdf swath\swath_1212.h5
        call :convert -e swath\swath_2222.hdf swath\swath_2222.h5
        call :convert -e swath\swath_n12n12.hdf swath\swath_n12n12.h5
        call :convert -e swath\swath_n22n22.hdf swath\swath_n22n22.h5
        call :convert -e swath\swath_0n20n2.hdf swath\swath_0n20n2.h5
        call :convert -e swath\swath_1n21n2.hdf swath\swath_1n21n2.h5
        call :convert -e swath\swath_2n22n2.hdf swath\swath_2n22n2.h5
        call :convert -e swath\swath_n1n2n1n2.hdf swath\swath_n1n2n1n2.h5
        call :convert -e swath\swath_n2n2n2n2.hdf swath\swath_n2n2n2n2.h5
        call :convert -e swath\swath_qdd.hdf swath\swath_qdd.h5
        call :convert -e swath\swath_dqd.hdf swath\swath_dqd.h5
        call :convert -e swath\swath_ddq.hdf swath\swath_ddq.h5
        call :convert -e swath\swath_qgg.hdf swath\swath_qgg.h5
        call :convert -e swath\swath_gqg.hdf swath\swath_gqg.h5
        call :convert -e swath\swath_ggq.hdf swath\swath_ggq.h5
        call :convert -e swath\swath_tll.hdf swath\swath_tll.h5
        call :convert -e swath\swath_tll02.hdf swath\swath_tll02.h5
        call :skip swath\swath_multswaths.hdf swath\swath_multswaths.h5
    )
    

    if "%nerrors%"=="0" (
        echo.All h4toh5 tests passed
    )
    
    if not "%outdir%"=="%srcdir%" (
        rmdir /s /q %outdir%
    )
    
    popd
    endlocal & exit /b %nerrors%
    
