@echo off
rem
rem Copyright by  The HDF Group (THG) and
rem               The Board of Trustees of the University of Illinois.
rem All rights reserved.
rem
rem This file is part of H4H5TOOLS. The full H4H5TOOLS copyright notice,
rem including terms governing use, modification, and redistribution, is
rem contained in the files COPYING and Copyright.html.  COPYING can be found
rem at the root of the source code distribution tree; Copyright.html can be
rem found at the root level of an installed copy of the electronic H4H5TOOLS
rem document set and is linked from the top-level documents page.  It can
rem also be found at http://www.hdfgroup.org/H4H5TOOLS/doc/Copyright.html.
rem If you do not have access to either file, you may request a copy from
rem help@hdfgroup.org.
rem
rem
rem Test script for the h4toh5 tests.
rem Using the h4toh5 convert to convert a pre-created hdf file to
rem an hdf5 file (output file), then compare it with a pre-created
rem corresponding hdf5 file (expected file).
rem If the same, that particular test passes.
rem If not the same, the output file and expected file are processed
rem by the h5dump tool to see if they produce the same results.
rem If the same, the test passes.
rem If not, show the difference of the two results and report the test failed.
rem
rem h5diff is default to use the one just built.  It can be overridden
rem by setting %h5diff%
rem
rem    Created:  Scott Wegner, 9/13/07
rem    Modified:  5/23/08
rem

setlocal enabledelayedexpansion
pushd %~dp0

rem currently only add h5dump path in this file
rem If %hdf5path% is not set, fail out-- we have no other way of detecting
rem this on Windows.  --SJW 9/13/07
if defined hdf5path (
    set h5path=%hdf5_path%\bin
) else (
    echo.  Error: HDF5PATH must be set in environment to test libh4toh5.
    set nerrors=1
    goto end
)
set h4toh5def=%1\h4h5apitestdefault
set h4toh5nam=%1\h4h5apitestname
set h4toh5sds=%1\h4h5apitestsds
set h4toh5vdata=%1\h4h5apitestvdata
set h4toh5basvgroup=%1\h4h5apitestbasvgroup
set h4toh5advgroup=%1\h4h5apitestadvgroup
set h4toh5image=%1\h4h5apitestimage
set h4toh5imageattr=%1\h4h5apitestimageattr
set h4toh5sdsattr=%1\h4h5apitestsdsattr
set h4toh5imagelone=%1\h4h5apitestloneimage
set h4toh5sdslone=%1\h4h5apitestlonesds
set h4toh5vdatalone=%1\h4h5apitestlonevdata

rem h4toh5_bin=%CD%\%h4toh5def%

set rm=del /f
set h5diff=%h5path%\h5diff.exe

if not exist %h5diff% (
    echo.    Could not run the 'H5DIFF' command. The test can still proceed
    echo.    but it may fail if 'H5DIFF' is needed to verify the output.
    echo.    You can make sure 'H5DIFF' is among your environment PATH and run
    echo.    the test again. You may also visit http://hdfgroup.org
    echo.    or email help@hdfgroup.org for more information.
    set h5diff=
)

if not exist ..\testfiles mkdir ..\testfiles

set srcdir=%CD%\..\testfiles
set outdir=%CD%\..\testfiles\Results

if not exist %outdir% mkdir %outdir%

set nerrors=0
set verbose=yes

goto main


rem Print a line-line message left justified in a field of 70 characters
rem beginning with the word "Testing".
rem
:testing
    set test_msg=Testing
    for %%a in (%*) do (
        if %%a neq PASSED (
        if %%a neq *FAILED* (
            set test_msg=!test_msg! %%~nxa
        ) )
    )
    set test_msg=!test_msg!                                                                
    echo.%test_msg:~0,69% %1
    
    exit /b

    
rem Run a test and print PASS or *FAIL*.  If a test fails then increment
rem the `nerrors' global variable and (if %verbose% is set) display the
rem difference between the actual output and the expected output. The
rem expected output is given as the first argument to this function and
rem the actual output file is calculated by replacing the `.ddl' with
rem `.out'.  The actual output is not removed if %HDF5_NOCLEANUP% has a
rem non-zero value.
rem
:convert
    rem
    rem Set up arguments to run the conversion test.
    rem The converter assumes all hdf4 files has the .hdf suffix as in the form
    rem of foo.hdf.  It creates the corresponding hdf5 files with the .h5 suffix
    rem as in the form of foo.h5.  One exception is that if exactly two file
    rem names are given, it treats the first argument as an hdf4 file and creates
    rem the corresponding hdf5 file with the name as the second argument, WITHOUT
    rem any consideration of the suffix.  (For this test script, in order to
    rem match the output hdf5 file with the expected hdf5 file, it expects the
    rem second file of the two-files tests has the .h5 suffix too.)
    rem
    rem If SRCDIR != OUTDIR, need to copy the input hdf4 files from the SRCDIR
    rem to the OUTDIR and transform the input file pathname because of the suffix
    rem convention mentioned above.  This way, the hdf5 files are always created
    rem in the OUTDIR directory.
    rem
    
    set infiles=
    set outfiles=
    set multirun=
    
    rem On Windows, the shift command isn't effective with %*.  Also, we don't
    rem have $# as Linux does.  So, iterate through parameters and declare
    rem params, to achieve this functionality.  --SJW 9/13/07
    set numparams=0
    set params=
    for %%a in (%*) do (
        if "!params!"=="" (
            set params=%%a
        ) else (
            set params=!params! %%a
        )
        set /a numparams=!numparams!+1
    )
    
    if "%1"=="-m" (
        rem multiple files conversion
        set multirun=-m
        rem On Windows, shift command doesn't effect %*, so we manipulate
        rem params variable manually.  --SJW 9/17/07
        set params=!params:* =!
        for %%a in (!params!) do (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%%a %outdir%\%%a > nul
            )
            set infiles=!infiles %%a!
            set outfiles=!outfiles %%~na.h5
            set params=!params:* =!
        )
    ) else (
        rem Single file conversion
        if "!numparams!"=="1" (
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%~n1.h5
            
        ) else if "!numparams!"=="2" (
            rem hdf4 file specified
            if not "%srcdir%"=="%outdir%" (
                copy /y %srcdir%\%1 %outdir%\%1 > nul
            )
            set infiles=%1
            set outfiles=%2
        
        ) else (
            rem Illegal
            echo.Illegal arguments
            exit /b 1
        )
    )
    
    rem run the conversion and remove input files that have been copied over
    (
        pushd %outdir%
        %h4toh5_bin% %infiles% %outfiles% 2>nul
        if not "%srcdir%"=="%outdir%" (
            %rm% %infiles%
        )
        popd
    )
    
    rem Verify results
    set result=passed
    for %%a in (%outfiles%) do (
        fc %srcdir%\Expected\%%a %outdir%\%%a > nul
        if !errorlevel! neq 0 (
            rem Use h5diff to compare the HDF5 files and verify the output.
            set outfile=%%~na
            set expect_out=!outfile!.expect
            set actual_out=!outfile!.actual
            
            if not defined h5diff (
                call :testing PASSED !h4toh5_bin:%CD%=! %*
            ) else (
                %h5diff% %srcdir%\Expected\!outfile!.h5 %outdir%\!outfile!.h5
                if !errorlevel! neq 0 (
                    call :testing *FAILED* !h4toh5_bin:%CD%=! %*
                    set /a nerrors=!nerrors!+1
                ) else (
                    call :testing PASSED !h4toh5_bin:%CD%=! %*
                )
            )
        )
        
        rem Clean up output file
        if not defined h4h5_nocleanup (
            %rm% !expect_out! !actual_out! 2> nul
            %rm% %outdir%\%%a
        )
    )
    
    exit /b
    
    
:convert1
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5def%
    call :convert vg_all_test.hdf vg_all_test.h5
    
    exit /b
    
    
:convert2
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5nam%
    call :convert vg_all_testname.hdf vg_all_testname.h5
    
    exit /b
    
    
:convert3
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5sds%
    call :convert sds_lib_test.hdf sds_lib_test.h5
    
    exit /b
    
    
:convert4
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5image%
    call :convert image_lib_test.hdf image_lib_test.h5
    
    exit /b
    
    
:convert5
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5vdata%
    call :convert vdata_lib_test.hdf vdata_lib_test.h5
    
    exit /b
    
    
:convert6
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5imageattr%
    call :convert image_lib_test.hdf image_lib_testattr.h5
    
    exit /b
    
    
:convert7
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5sdsattr%
    call :convert sds_lib_test.hdf sds_lib_testattr.h5
    
    exit /b
    

:convert8
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5basvgroup%
    call :convert vg_bas_test.hdf vg_bas_test.h5
    
    exit /b
    
    
:convert9
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5advgroup%
    call :convert testallvgroup.hdf testallvgroup.h5
    
    exit /b
    
    
:convert10
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5imagelone%
    call :convert image_lib_lonetest.hdf image_lib_lonetest.h5
    
    exit /b
    
    
:convert11
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5sdslone%
    call :convert sds_lib_lonetest.hdf sds_lib_lonetest.h5
    
    exit /b
    
    
:convert12
    rem Run h4toh5 convert.
    set h4toh5_bin=%CD%\%h4toh5vdatalone%
    call :convert vdata_lib_lonetest.hdf vdata_lib_lonetest.h5
    
    exit /b
    
    
rem ############################################################################
rem #                       T H E   T E S T S                                ###
rem ############################################################################
rem ############################################################################

:main

    %rm% %outdir%\*.hdf %outdir%\*.tmp 2>nul
    
    rem
    rem The HDF5 filenames are created based upon the HDF4 filenames
    rem without the extension.
    rem
    
    rem test for converting H5 groups to H4 Vgroups.
    rem call :convert vg.hdf


    rem
    rem The test for conversion are the same as above with the only difference
    rem being that the HDF5 filenames are given explicitly.
    rem

    %rm% %outdir%\*.tmp 2>nul
    call :convert1 
    call :convert2 
    call :convert3 
    call :convert4
    call :convert5 
    call :convert6
    call :convert7
    call :convert8
    call :convert9
    call :convert10
    call :convert11
    call :convert12
    rem
    rem Again, the test for conversion are the same as the first set of test.
    rem Here, multiple conversion are done on HDF4 files at one time.
    rem
    
    %rm% %outdir%\*.hdf %outdir%\*.tmp 2> nul
    rem call :convert -m vg.hdf
    
    if "%nerrors%"=="0" (
        echo.All h4toh5 tests passed.
    )
    
    if not "%outdir%"=="%srcdir%" (
        rmdir /s /q %outdir%
    )
    
    :end
    popd
    endlocal & exit /b %nerrors%
    
